/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.AbstractFtpDoorV1;
import diskCacheV111.util.Base64;
import diskCacheV111.util.Version;
import dmg.cells.nucleus.CellVersion;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.StreamEngine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;

public abstract class GssFtpDoorV1
extends AbstractFtpDoorV1 {
    public static final String GLOBUS_URL_COPY_DEFAULT_USER = ":globus-mapping:";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected GSSName _gssIdentity;
    protected String _gssFlavor;
    protected GSSContext _serviceContext;

    public GssFtpDoorV1(String name, StreamEngine engine, Args args) throws InterruptedException, ExecutionException {
        super(name, engine, args);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this._gssFlavor = "unknown";
    }

    @Override
    protected void secure_reply(String answer, String code) {
        answer = answer + "\r\n";
        byte[] data = answer.getBytes(UTF8);
        MessageProp prop = new MessageProp(0, false);
        try {
            data = this._serviceContext.wrap(data, 0, data.length, prop);
        }
        catch (GSSException e) {
            this.println("500 Reply encryption error: " + e);
            return;
        }
        this.println(code + " " + Base64.byteArrayToBase64((byte[])data));
    }

    @Override
    public void ac_auth(String arg) {
        this.info("GssFtpDoorV1::secure_reply: going to authorize using " + this._gssFlavor);
        if (!arg.equals("GSSAPI")) {
            this.reply("504 Authenticating method not supported");
            return;
        }
        if (this._serviceContext != null && this._serviceContext.isEstablished()) {
            this.reply("234 Already authenticated");
            return;
        }
        try {
            this._serviceContext = this.getServiceContext();
        }
        catch (Exception e) {
            this.error(e.toString());
            this.reply("500 Error: " + e.toString());
            return;
        }
        this.reply("334 ADAT must follow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ac_adat(String arg) {
        if (arg == null || arg.length() <= 0) {
            this.reply("501 ADAT must have data");
            return;
        }
        if (this._serviceContext == null) {
            this.reply("503 Send AUTH first");
            return;
        }
        byte[] token = Base64.base64ToByteArray((String)arg);
        try {
            ChannelBinding cb = new ChannelBinding(this._engine.getInetAddress(), InetAddress.getLocalHost(), null);
        }
        catch (UnknownHostException e) {
            this.reply("500 Can not determine address of local host: " + e);
            return;
        }
        try {
            this.enableInterrupt();
            token = this._serviceContext.acceptSecContext(token, 0, token.length);
            this._gssIdentity = this._serviceContext.getSrcName();
        }
        catch (Exception e) {
            this._logger.error("GssFtpDoorV1::ac_adat: got service context exception", (Throwable)e);
            this.reply("535 Authentication failed: " + e);
            return;
        }
        finally {
            this.disableInterrupt();
        }
        if (token != null) {
            if (!this._serviceContext.isEstablished()) {
                this.reply("335 ADAT=" + Base64.byteArrayToBase64((byte[])token));
            } else {
                this.reply("235 ADAT=" + Base64.byteArrayToBase64((byte[])token));
            }
        } else if (!this._serviceContext.isEstablished()) {
            this.reply("335 ADAT=");
        } else {
            this.info("GssFtpDoorV1::ac_adat: security context established with " + this._gssIdentity);
            this.reply("235 OK");
        }
    }

    @Override
    public void secure_command(String answer, String sectype) throws CommandExitException {
        int i;
        if (answer == null || answer.length() <= 0) {
            this.reply("500 Wrong syntax of " + sectype + " command");
            return;
        }
        if (this._serviceContext == null || !this._serviceContext.isEstablished()) {
            this.reply("503 Security context is not established");
            return;
        }
        byte[] data = Base64.base64ToByteArray((String)answer);
        MessageProp prop = new MessageProp(0, false);
        try {
            data = this._serviceContext.unwrap(data, 0, data.length, prop);
        }
        catch (GSSException e) {
            this.reply("500 Can not decrypt command: " + e);
            this.error("GssFtpDoorV1::secure_command: got GSSException: " + e.getMessage());
            return;
        }
        for (i = data.length; i > 0 && data[i - 1] == 0; --i) {
        }
        String msg = new String(data, 0, i, UTF8);
        if ((msg = msg.trim()).equalsIgnoreCase("CCC")) {
            this._gReplyType = "clear";
            this.reply("200 OK");
        } else {
            this._gReplyType = sectype;
            this.ftpcommand(msg);
        }
    }

    public static CellVersion getStaticCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 1.18 $");
    }

    @Override
    protected String getUser() {
        return this._gssIdentity == null ? null : ((Object)this._gssIdentity).toString();
    }

    @Override
    public void ac_pass(String arg) {
        this.debug("GssFtpDoorV1::ac_pass: PASS is a no-op with GSSAPI authentication.");
        if (this._subject != null) {
            this.reply(this.ok("PASS"));
        } else {
            this.reply("500 Send USER first");
        }
    }

    protected abstract GSSContext getServiceContext() throws GSSException;
}

