/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.doors.GssFtpDoorV1;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.Version;
import dmg.cells.nucleus.CellVersion;
import dmg.util.Args;
import dmg.util.StreamEngine;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.Subjects;
import org.dcache.cells.Option;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GsiFtpDoorV1
extends GssFtpDoorV1 {
    @Option(name="service-key", defaultValue="/etc/grid-security/hostkey.pem")
    protected String service_key;
    @Option(name="service-cert", defaultValue="/etc/grid-security/hostcert.pem")
    protected String service_cert;
    @Option(name="service-trusted-certs", defaultValue="/etc/grid-security/certificates")
    protected String service_trusted_certs;
    private String _user;

    public GsiFtpDoorV1(String name, StreamEngine engine, Args args) throws InterruptedException, ExecutionException {
        super(name, engine, args);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        Args args = this.getArgs();
        this._gssFlavor = "gsi";
        this.ftpDoorName = "GSI FTP";
    }

    public static CellVersion getStaticCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 1.17 $");
    }

    @Override
    public void startTlog(FTPTransactionLog tlog, String path, String action) {
        if (this._subject != null) {
            try {
                String user = this._user + "(" + Subjects.getUid((Subject)this._subject) + "." + Subjects.getPrimaryGid((Subject)this._subject) + ")";
                tlog.begin(user, "gsiftp", action, path, this._engine.getInetAddress());
            }
            catch (Exception e) {
                this.error("GsiFtpDoor: couldn't start tLog. Ignoring exception: " + e.getMessage());
            }
        }
    }

    @Override
    protected GSSContext getServiceContext() throws GSSException {
        GlobusCredential serviceCredential;
        try {
            serviceCredential = new GlobusCredential(this.service_cert, this.service_key);
        }
        catch (GlobusCredentialException gce) {
            String errmsg = "GsiFtpDoor: couldn't load host globus credentials: " + gce.toString();
            this.error(errmsg);
            throw new GSSException(13, 0, errmsg);
        }
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(serviceCredential, 2);
        TrustedCertificates trusted_certs = TrustedCertificates.load((String)this.service_trusted_certs);
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
        context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
        context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
        return context;
    }

    @Override
    public void ac_user(String arg) {
        if (arg.equals("")) {
            this.reply(this.err("USER", arg));
            return;
        }
        if (this._serviceContext == null || !this._serviceContext.isEstablished()) {
            this.reply("530 Authentication required");
            return;
        }
        Subject subject = new Subject();
        try {
            subject.getPrincipals().add((Principal)this._origin);
            if (!arg.equals(":globus-mapping:")) {
                subject.getPrincipals().add((Principal)new LoginNamePrincipal(arg));
            }
            if (!(this._serviceContext instanceof ExtendedGSSContext)) {
                throw new RuntimeException("GSSContext not instance of ExtendedGSSContext");
            }
            ExtendedGSSContext extendedcontext = (ExtendedGSSContext)this._serviceContext;
            X509Certificate[] chain = (X509Certificate[])extendedcontext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
            subject.getPublicCredentials().add(chain);
            this.login(subject);
            this._user = arg;
            this.reply("200 User " + arg + " logged in");
        }
        catch (GSSException e) {
            this.error("Failed to extract X509 chain: " + e);
            this.println("530 Login failed: " + e.getMessage());
        }
        catch (PermissionDeniedCacheException e) {
            this.warn("Login denied for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login incorrect");
        }
        catch (CacheException e) {
            this.error("Login failed for " + subject + ": " + (Object)((Object)e));
            this.println("530 Login failed: " + e.getMessage());
        }
    }
}

