/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.doors;

import com.google.common.base.Strings;
import com.google.common.collect.Ranges;
import diskCacheV111.doors.FTPCommandException;
import diskCacheV111.doors.FTPTransactionLog;
import diskCacheV111.movers.GFtpPerfMarker;
import diskCacheV111.movers.GFtpPerfMarkersBlock;
import diskCacheV111.util.ActiveAdapter;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CheckStagePermission;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.ProxyAdapter;
import diskCacheV111.util.SocketAdapter;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.DoorRequestInfoMessage;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.GFtpProtocolInfo;
import diskCacheV111.vehicles.GFtpTransferStartedMessage;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.StreamEngine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessType;
import org.dcache.auth.KauthFileLoginStrategy;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Origin;
import org.dcache.auth.Subjects;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellStub;
import org.dcache.cells.Option;
import org.dcache.commons.util.NDC;
import org.dcache.namespace.ACLPermissionHandler;
import org.dcache.namespace.ChainedPermissionHandler;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.namespace.PermissionHandler;
import org.dcache.namespace.PosixPermissionHandler;
import org.dcache.services.login.RemoteLoginStrategy;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.util.FireAndForgetTask;
import org.dcache.util.Glob;
import org.dcache.util.PortRange;
import org.dcache.util.Transfer;
import org.dcache.util.TransferRetryPolicy;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.DirectoryListSource;
import org.dcache.util.list.ListDirectoryHandler;
import org.dcache.vehicles.FileAttributes;

public abstract class AbstractFtpDoorV1
extends AbstractCell
implements Runnable {
    private static final String[] FEATURES = new String[]{"EOF", "PARALLEL", "MODE-E-PERF", "SIZE", "SBUF", "ERET", "ESTO", "GETPUT", "MDTM", "CKSUM " + AbstractFtpDoorV1.buildChecksumList(), "MODEX", "TVFS"};
    private static final int DEFAULT_DATA_PORT = 20;
    private static final int MAX_RETRIES_WRITE = 1;
    private final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected StreamEngine _engine;
    protected PrintWriter _out;
    protected PnfsHandler _pnfs;
    protected DirectoryListSource _listSource;
    protected Origin _origin;
    @Option(name="poolManager", description="Well known name of the pool manager", defaultValue="PoolManager")
    protected String _poolManager;
    @Option(name="pnfsManager", description="Well known name of the PNFS manager", defaultValue="PnfsManager")
    protected String _pnfsManager;
    @Option(name="clientDataPortRange")
    protected String _portRange;
    @Option(name="ftp-adapter-internal-interface", description="Interface to bind to")
    protected String _local_host;
    @Option(name="read-only", description="Whether to mark the FTP door read only", defaultValue="false")
    protected boolean _readOnly;
    @Option(name="maxRetries", defaultValue="3")
    protected int _maxRetries;
    @Option(name="poolManagerTimeout", defaultValue="1500", unit="seconds")
    protected int _poolManagerTimeout;
    @Option(name="pnfsTimeout", defaultValue="60", unit="seconds")
    protected int _pnfsTimeout;
    @Option(name="poolTimeout", defaultValue="300", unit="seconds")
    protected int _poolTimeout;
    @Option(name="retryWait", defaultValue="30", unit="seconds")
    protected int _retryWait;
    @Option(name="maxBlockSize", defaultValue="131072", unit="bytes")
    protected int _maxBlockSize;
    @Option(name="deleteOnConnectionClosed", description="Whether to remove files on incomplete transfers", defaultValue="false")
    protected boolean _removeFileOnIncompleteTransfer;
    @Option(name="proxyPassive", description="Whether proxy is required for passive transfers", required=true)
    protected boolean _isProxyRequiredOnPassive;
    @Option(name="proxyActive", description="Whether proxy is required for active transfers", required=true)
    protected boolean _isProxyRequiredOnActive;
    @Option(name="use-login-service", description="Whether to use the login service", defaultValue="false")
    protected boolean _useLoginService;
    @Option(name="kpwd-file", description="Path to kpwd file", defaultValue="")
    protected String _kpwdFilePath;
    @Option(name="stageConfigurationFilePath", description="File containing DNs and FQANs for which STAGING is allowed", defaultValue="")
    protected String _stageConfigurationFilePath;
    @Option(name="transfer-timeout", description="Transfer timeout", defaultValue="0", unit="seconds")
    protected int _transferTimeout;
    @Option(name="tlog", description="Path to FTP transaction log")
    protected String _tLogRoot;
    @Option(name="overwrite", defaultValue="false")
    protected boolean _overwrite;
    @Option(name="io-queue")
    private String _ioQueueName;
    @Option(name="maxStreamsPerClient", description="Maximum allowed streams per client in mode E", defaultValue="-1", unit="streams")
    protected int _maxStreamsPerClient;
    @Option(name="defaultStreamsPerClient", description="Default number of streams per client in mode E", defaultValue="1", unit="streams")
    protected int _defaultStreamsPerClient;
    @Option(name="perfMarkerPeriod", description="Performance marker period", defaultValue="90", unit="seconds")
    protected long _performanceMarkerPeriod;
    protected final int _sleepAfterMoverKill = 1;
    protected final int _spaceManagerTimeout = 300;
    protected PortRange _passiveModePortRange;
    protected ServerSocketChannel _passiveModeServerSocket;
    private final CommandQueue _commandQueue = new CommandQueue();
    private final CountDownLatch _shutdownGate = new CountDownLatch(1);
    private final Map<String, Method> _methodDict = new HashMap<String, Method>();
    private static final ExecutorService _executor = Executors.newCachedThreadPool();
    private Thread _workerThread;
    protected int _commandCounter = 0;
    protected String _lastCommand = "<init>";
    protected InetSocketAddress _clientDataAddress;
    protected volatile Socket _dataSocket;
    protected long prm_offset = -1L;
    protected long prm_size = -1L;
    protected long _skipBytes = 0L;
    protected boolean _confirmEOFs = false;
    protected Subject _subject;
    protected boolean _isUserReadOnly;
    protected FsPath _pathRoot = new FsPath();
    protected String _cwd = "/";
    protected FsPath _filepath = null;
    protected String _xferMode = "S";
    protected CellStub _billingStub;
    protected CellStub _poolManagerStub;
    protected CellStub _poolStub;
    protected TransferRetryPolicy _readRetryPolicy;
    protected TransferRetryPolicy _writeRetryPolicy;
    protected CheckStagePermission _checkStagePermission;
    protected LoginStrategy _loginStrategy;
    protected String _gReplyType = "clear";
    protected Mode _mode = Mode.ACTIVE;
    protected int _parallel;
    protected int _bufSize = 0;
    protected String ftpDoorName = "FTP";
    protected Checksum _checkSum;
    protected ChecksumFactory _checkSumFactory;
    protected ChecksumFactory _optCheckSumFactory;
    protected long _allo;
    protected Set<Fact> _currentFacts = new HashSet<Fact>(Arrays.asList(Fact.SIZE, Fact.MODIFY, Fact.TYPE, Fact.UNIQUE, Fact.PERM, Fact.OWNER, Fact.GROUP, Fact.MODE));
    protected FtpTransfer _transfer;
    protected AdminCommandListener adminCommandListener;
    private static final Pattern ALLO_PATTERN = Pattern.compile("(\\d+)( R \\d+)?");
    private static final Pattern GLOB_PATTERN = Pattern.compile("[*?]");
    private static final Pattern _parameterPattern = Pattern.compile("(\\w+)(?:=([^;]+))?;");
    private static final Map<String, Pattern> _valuePatterns = new HashMap<String, Pattern>();

    private static final String buildChecksumList() {
        String result = "";
        int mod = 0;
        for (ChecksumType type : ChecksumType.values()) {
            result = result + type.getName() + ",";
            mod = 1;
        }
        return result.substring(0, result.length() - mod);
    }

    public static CellVersion getStaticCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 17678 $");
    }

    public AbstractFtpDoorV1(String name, StreamEngine engine, Args args) throws InterruptedException, ExecutionException {
        super(name, args);
        for (Method method : this.getClass().getMethods()) {
            String name2 = method.getName();
            if (!name2.regionMatches(false, 0, "ac_", 0, 3)) continue;
            this._methodDict.put(name2.substring(3), method);
        }
        try {
            this._engine = engine;
            this.doInit();
            this._workerThread.start();
        }
        catch (InterruptedException e) {
            this.reply("421 " + this.ftpDoorName + " door not ready");
            this._shutdownGate.countDown();
        }
        catch (ExecutionException e) {
            this.reply("421 " + this.ftpDoorName + " door not ready");
            this._shutdownGate.countDown();
        }
    }

    protected void init() throws Exception {
        super.init();
        Transfer.initSession();
        Args args = this.getArgs();
        this._out = new PrintWriter(this._engine.getWriter());
        this._clientDataAddress = new InetSocketAddress(this._engine.getInetAddress(), 20);
        this._logger.debug("Client host: {}", (Object)this._clientDataAddress.getAddress().getHostAddress());
        if (this._local_host == null) {
            this._local_host = this._engine.getLocalAddress().getHostAddress();
        }
        if (this._useLoginService) {
            this._loginStrategy = new RemoteLoginStrategy(new CellStub((CellEndpoint)this, new CellPath("gPlazma"), 30000L));
        } else {
            if (Strings.isNullOrEmpty((String)this._kpwdFilePath)) {
                String s = "-kpwd-file file argument wasn't specified";
                this._logger.error(s);
                throw new IllegalArgumentException(s);
            }
            File file = new File(this._kpwdFilePath);
            if (!file.exists()) {
                String s = "File not found: " + file;
                this._logger.error(s);
                throw new IllegalArgumentException(s);
            }
            this._loginStrategy = new KauthFileLoginStrategy(file);
        }
        this._passiveModePortRange = this._portRange != null ? PortRange.valueOf((String)this._portRange) : new PortRange(0);
        this._parallel = this._defaultStreamsPerClient;
        this._origin = new Origin(Origin.AuthType.ORIGIN_AUTHTYPE_STRONG, this._engine.getInetAddress());
        this._billingStub = new CellStub((CellEndpoint)this, new CellPath("billing"));
        this._poolManagerStub = new CellStub((CellEndpoint)this, new CellPath(this._poolManager), (long)(this._poolManagerTimeout * 1000));
        this._poolStub = new CellStub((CellEndpoint)this, null, (long)(this._poolTimeout * 1000));
        this._readRetryPolicy = new TransferRetryPolicy(this._maxRetries, (long)(this._retryWait * 1000), Long.MAX_VALUE, (long)(this._poolTimeout * 1000));
        this._writeRetryPolicy = new TransferRetryPolicy(1, 0L, Long.MAX_VALUE, (long)(this._poolTimeout * 1000));
        this.adminCommandListener = new AdminCommandListener();
        this.addCommandListener(this.adminCommandListener);
        this._checkStagePermission = new CheckStagePermission(this._stageConfigurationFilePath);
        this.useInterpreter(true);
        this._workerThread = new Thread(this);
    }

    protected void login(Subject subject) throws CacheException {
        LoginReply login = this._loginStrategy.login(subject);
        this._subject = login.getSubject();
        this._subject = new Subject(false, this._subject.getPrincipals(), this._subject.getPublicCredentials(), this._subject.getPrivateCredentials());
        this._subject.getPrincipals().add((Principal)this._origin);
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (attribute instanceof RootDirectory) {
                this._pathRoot = new FsPath(((RootDirectory)attribute).getRoot());
                continue;
            }
            if (attribute instanceof HomeDirectory) {
                this._cwd = ((HomeDirectory)attribute).getHome();
                continue;
            }
            if (!(attribute instanceof ReadOnly)) continue;
            this._isUserReadOnly = ((ReadOnly)attribute).isReadOnly();
        }
        this._pnfs = new PnfsHandler((CellEndpoint)this, new CellPath(this._pnfsManager));
        this._pnfs.setPnfsTimeout((long)this._pnfsTimeout * 1000L);
        this._pnfs.setSubject(this._subject);
        this._listSource = new ListDirectoryHandler(this._pnfs);
        this.addMessageListener(this._listSource);
    }

    private int spawn(String cmd, int errexit) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            int returnCode = p.exitValue();
            p.destroy();
            return returnCode;
        }
        catch (IOException e) {
            return errexit;
        }
        catch (InterruptedException e) {
            return errexit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ftpcommand(String cmdline) throws CommandExitException {
        int l = 4;
        if (cmdline.length() < 3) {
            this.reply(this.err(cmdline, ""));
            return;
        }
        if (cmdline.length() == 3 || cmdline.charAt(3) == ' ') {
            l = 3;
        }
        String cmd = cmdline.substring(0, l);
        String arg = cmdline.length() > l + 1 ? cmdline.substring(l + 1) : "";
        Object[] args = new Object[]{arg};
        if ((cmd = cmd.toLowerCase()).equals("mic") || cmd.equals("conf") || cmd.equals("enc") || cmd.equals("adat") || cmd.equals("pass")) {
            this._logger.info("ftpcommand <{} ...>", (Object)cmd);
        } else {
            this._lastCommand = cmdline;
            this._logger.info("ftpcommand <{}>", (Object)cmdline);
        }
        AbstractFtpDoorV1 abstractFtpDoorV1 = this;
        synchronized (abstractFtpDoorV1) {
            if (!(this._transfer == null || cmd.equals("abor") || cmd.equals("mic") || cmd.equals("conf") || cmd.equals("enc") || cmd.equals("quit") || cmd.equals("bye"))) {
                this.reply("503 Transfer in progress", false);
                return;
            }
        }
        if (!this._methodDict.containsKey(cmd)) {
            this._skipBytes = 0L;
            this.reply(this.err(cmd, arg));
            return;
        }
        Method m = this._methodDict.get(cmd);
        try {
            m.invoke((Object)this, args);
            if (!cmd.equals("rest")) {
                this._skipBytes = 0L;
            }
        }
        catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            if (te instanceof FTPCommandException) {
                FTPCommandException failure = (FTPCommandException)te;
                this.reply(String.valueOf(failure.getCode()) + " " + failure.getReply());
            } else {
                if (te instanceof CommandExitException) {
                    throw (CommandExitException)te;
                }
                this.reply("500 Operation failed due to internal error: " + te.getMessage());
                this._logger.error("FTP command '{}' got exception", (Object)cmd, (Object)te);
            }
            this._skipBytes = 0L;
        }
        catch (IllegalAccessException e) {
            this._logger.error("This is a bug. Please report it.", (Throwable)e);
        }
    }

    private synchronized void shutdownInputStream() {
        try {
            Socket socket = this._engine.getSocket();
            if (!socket.isClosed() && !socket.isInputShutdown()) {
                socket.shutdownInput();
            }
        }
        catch (IOException e) {
            this._logger.info("Failed to shut down input stream of the control channel: {}", (Object)e.getMessage());
        }
    }

    private synchronized void closePassiveModeServerSocket() {
        if (this._passiveModeServerSocket != null) {
            try {
                this._logger.info("Closing passive mode server socket");
                this._passiveModeServerSocket.close();
            }
            catch (IOException e) {
                this._logger.warn("Failed to close passive mode server socket: {}", (Object)e.getMessage());
            }
            this._passiveModeServerSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NDC.push((String)CDC.getSession());
        try {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(this._engine.getInputStream(), "UTF-8"));
                this.reply("220 " + this.ftpDoorName + " door ready");
                String s = in.readLine();
                while (s != null) {
                    this._commandQueue.add(s);
                    s = in.readLine();
                }
            }
            catch (IOException e) {
                this._logger.error("Got error reading data: {}", (Object)e.getMessage());
            }
            finally {
                try {
                    this._commandQueue.stop();
                }
                catch (InterruptedException e) {
                    this._logger.error("Failed to shut down command processing: {}", (Object)e.getMessage());
                }
                FtpTransfer transfer = this._transfer;
                if (transfer != null) {
                    transfer.abort(451, "Aborting transfer due to session termination");
                }
                this.closePassiveModeServerSocket();
                this._logger.debug("End of stream encountered");
            }
        }
        finally {
            this._shutdownGate.countDown();
            this.kill();
            NDC.clear();
        }
    }

    public void cleanUp() {
        this.shutdownInputStream();
        try {
            this._shutdownGate.await();
        }
        catch (InterruptedException e) {
            this._logger.error("Got interrupted exception shutting down input stream");
        }
        try {
            this._engine.getSocket().close();
        }
        catch (IOException e) {
            this._logger.error("Got I/O exception closing socket: {}", (Object)e.getMessage());
        }
        super.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String str) {
        PrintWriter out;
        PrintWriter printWriter = out = this._out;
        synchronized (printWriter) {
            out.println(str + "\r");
            out.flush();
        }
    }

    public void execute(String command) {
        try {
            if (command.equals("")) {
                this.reply(this.err("", ""));
            } else {
                ++this._commandCounter;
                this.ftpcommand(command);
            }
        }
        catch (CommandExitException e) {
            this.shutdownInputStream();
        }
    }

    protected String getUser() {
        return Subjects.getUserName((Subject)this._subject);
    }

    public String toString() {
        String user = this.getUser();
        String address = this._clientDataAddress.getAddress().getHostAddress();
        if (user == null) {
            return address;
        }
        return user + "@" + address;
    }

    public void getInfo(PrintWriter pw) {
        String user = this.getUser();
        pw.println("            FTPDoor");
        if (user != null) {
            pw.println("         User  : " + user);
        }
        pw.println("    User Host  : " + this._clientDataAddress.getAddress().getHostAddress());
        pw.println("   Local Host  : " + this._local_host);
        pw.println(" Last Command  : " + this._lastCommand);
        pw.println(" Command Count : " + this._commandCounter);
        pw.println("     I/O Queue : " + this._ioQueueName);
        pw.println(this.adminCommandListener.ac_get_door_info(new Args((CharSequence)"")));
    }

    public void messageArrived(CellMessage envelope, GFtpTransferStartedMessage message) {
        this._logger.debug("Received TransferStarted message");
        FtpTransfer transfer = this._transfer;
        if (transfer != null) {
            transfer.transferStarted(envelope, message);
        }
    }

    public void messageArrived(DoorTransferFinishedMessage message) {
        this._logger.debug("Received TransferFinished message [rc={}]", (Object)message.getReturnCode());
        FtpTransfer transfer = this._transfer;
        if (transfer != null) {
            transfer.finished(message);
        }
    }

    protected void reply(String answer, boolean resetReply) {
        if (answer.startsWith("335 ADAT=")) {
            this._logger.info("REPLY(reset={} GReplyType={}): <335 ADAT=...>", (Object)resetReply, (Object)this._gReplyType);
        } else {
            this._logger.info("REPLY(reset={} GReplyType={}): <{}>", new Object[]{resetReply, this._gReplyType, answer});
        }
        if (this._gReplyType.equals("clear")) {
            this.println(answer);
        } else if (this._gReplyType.equals("mic")) {
            this.secure_reply(answer, "631");
        } else if (this._gReplyType.equals("enc")) {
            this.secure_reply(answer, "633");
        } else if (this._gReplyType.equals("conf")) {
            this.secure_reply(answer, "632");
        }
        if (resetReply) {
            this._gReplyType = "clear";
        }
    }

    protected void reply(String answer) {
        this.reply(answer, true);
    }

    protected abstract void secure_reply(String var1, String var2);

    protected void checkLoggedIn() throws FTPCommandException {
        if (this._subject == null) {
            throw new FTPCommandException(530, "Not logged in.");
        }
    }

    protected void checkWritable() throws FTPCommandException {
        if (this._readOnly || this._isUserReadOnly) {
            throw new FTPCommandException(500, "Command disabled");
        }
        if (Subjects.isNobody((Subject)this._subject)) {
            throw new FTPCommandException(554, "Anonymous write access not permitted");
        }
    }

    public void ac_feat(String arg) {
        StringBuilder builder = new StringBuilder();
        builder.append("211-OK\r\n");
        for (String string : FEATURES) {
            builder.append(' ').append(string).append("\r\n");
        }
        builder.append(" MLST ");
        for (Fact fact : Fact.values()) {
            builder.append(fact.getName());
            if (this._currentFacts.contains((Object)fact)) {
                builder.append('*');
            }
            builder.append(';');
        }
        builder.append("\r\n");
        builder.append("211 End");
        this.reply(builder.toString());
    }

    public void opts_retr(String opt) {
        String[] st = opt.split("=");
        String real_opt = st[0];
        String real_value = st[1];
        if (!real_opt.equalsIgnoreCase("Parallelism")) {
            this.reply("501 Unrecognized option: " + real_opt + " (" + real_value + ")");
            return;
        }
        st = real_value.split(",|;");
        this._parallel = Integer.parseInt(st[0]);
        if (this._maxStreamsPerClient > 0) {
            this._parallel = Math.min(this._parallel, this._maxStreamsPerClient);
        }
        this.reply("200 Parallel streams set (" + opt + ")");
    }

    public void opts_stor(String opt, String val) {
        if (!opt.equalsIgnoreCase("EOF")) {
            this.reply("501 Unrecognized option: " + opt + " (" + val + ")");
            return;
        }
        if (!val.equals("1")) {
            this._confirmEOFs = true;
            this.reply("200 EOF confirmation is ON");
            return;
        }
        if (!val.equals("0")) {
            this._confirmEOFs = false;
            this.reply("200 EOF confirmation is OFF");
            return;
        }
        this.reply("501 Unrecognized option value: " + val);
    }

    private void opts_cksm(String algo) {
        if (algo == null) {
            this.reply("501 CKSM option command requires algorithm type");
            return;
        }
        try {
            this._optCheckSumFactory = !algo.equalsIgnoreCase("NONE") ? ChecksumFactory.getFactory((ChecksumType)ChecksumType.getChecksumType((String)algo)) : null;
            this.reply("200 OK");
        }
        catch (IllegalArgumentException e) {
            this.reply("504 Unsupported checksum type: " + algo);
        }
        catch (NoSuchAlgorithmException e) {
            this.reply("504 Unsupported checksum type: " + algo);
        }
    }

    private void opts_mlst(String facts) {
        HashSet<Fact> newFacts = new HashSet<Fact>();
        for (String s : facts.split(";")) {
            Fact fact = Fact.find(s);
            if (fact == null) continue;
            newFacts.add(fact);
        }
        this._currentFacts = newFacts;
        if (this._currentFacts.isEmpty()) {
            this.reply("200 MLST");
        } else {
            StringBuilder s = new StringBuilder("200 MLST ");
            for (Fact fact : this._currentFacts) {
                s.append(fact.getName()).append(';');
            }
            this.reply(s.toString());
        }
    }

    public void ac_opts(String arg) {
        String[] st = arg.split("\\s+");
        if (st.length == 2 && st[0].equalsIgnoreCase("RETR")) {
            this.opts_retr(st[1]);
        } else if (st.length == 3 && st[0].equalsIgnoreCase("STOR")) {
            this.opts_stor(st[1], st[2]);
        } else if (st.length == 2 && st[0].equalsIgnoreCase("CKSM")) {
            this.opts_cksm(st[1]);
        } else if (st.length == 1 && st[0].equalsIgnoreCase("MLST")) {
            this.opts_mlst("");
        } else if (st.length == 2 && st[0].equalsIgnoreCase("MLST")) {
            this.opts_mlst(st[1]);
        } else {
            this.reply("501 Unrecognized option: " + st[0] + " (" + arg + ")");
        }
    }

    public void ac_dele(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        FsPath path = this.absolutePath(arg);
        try {
            this._pnfs.deletePnfsEntry(path.toString(), EnumSet.of(FileType.REGULAR, FileType.LINK));
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
            return;
        }
        catch (CacheException e) {
            this._logger.error("DELE got CacheException: {}", (Object)e.getMessage());
            this.reply("550 Permission denied, reason: " + (Object)((Object)e));
            return;
        }
        this.sendRemoveInfoToBilling(path);
        this.reply("200 file deleted");
    }

    public abstract void ac_auth(String var1);

    public abstract void ac_adat(String var1);

    public void ac_mic(String arg) throws CommandExitException {
        this.secure_command(arg, "mic");
    }

    public void ac_enc(String arg) throws CommandExitException {
        this.secure_command(arg, "enc");
    }

    public void ac_conf(String arg) throws CommandExitException {
        this.secure_command(arg, "conf");
    }

    public abstract void secure_command(String var1, String var2) throws CommandExitException;

    public void ac_ccc(String arg) {
        this.reply("533 CCC must be protected");
    }

    public abstract void ac_user(String var1);

    public abstract void ac_pass(String var1);

    public void ac_pbsz(String arg) {
        this.reply("200 OK");
    }

    public void ac_prot(String arg) {
        if (!arg.equals("C")) {
            this.reply("534 Will accept only Clear protection level");
        } else {
            this.reply("200 OK");
        }
    }

    private FsPath absolutePath(String path) {
        FsPath relativePath = new FsPath(this._cwd);
        relativePath.add(path);
        return new FsPath(new FsPath[]{this._pathRoot, relativePath});
    }

    public void ac_rmd(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        if (arg.equals("")) {
            this.reply(this.err("RMD", arg));
            return;
        }
        try {
            FsPath path = this.absolutePath(arg);
            this._pnfs.deletePnfsEntry(path.toString(), EnumSet.of(FileType.DIR));
            this.reply("200 OK");
        }
        catch (FileNotFoundCacheException e) {
            this.reply("550 File not found");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException ce) {
            this.reply("550 Permission denied, reason: " + (Object)((Object)ce));
        }
    }

    public void ac_mkd(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        if (arg.equals("")) {
            this.reply(this.err("MKD", arg));
            return;
        }
        try {
            FsPath path = this.absolutePath(arg);
            this._pnfs.createPnfsDirectory(path.toString());
            this.reply("200 OK");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            this.reply("553 Permission denied, reason: " + (Object)((Object)e));
        }
    }

    public void ac_help(String arg) {
        this.reply("214 No help available");
    }

    public void ac_syst(String arg) {
        this.reply("215 UNIX Type: L8 Version: FTPDoor");
    }

    public void ac_type(String arg) {
        this.reply("200 Type set to I");
    }

    public void ac_noop(String arg) {
        this.reply(this.ok("NOOP"));
    }

    public void ac_allo(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        this._allo = 0L;
        Matcher matcher = ALLO_PATTERN.matcher(arg);
        if (!matcher.matches()) {
            this.reply("501 Invalid argument");
            return;
        }
        try {
            this._allo = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException e) {
            this.reply("501 Invalid argument");
            return;
        }
        this.reply(this.ok("ALLO"));
    }

    public void ac_pwd(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        if (!arg.equals("")) {
            this.reply(this.err("PWD", arg));
            return;
        }
        this.reply("257 \"" + this._cwd + "\" is current directory");
    }

    public void ac_cwd(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        try {
            FsPath newcwd = this.absolutePath(arg);
            this.checkIsDirectory(newcwd);
            this._cwd = this._pathRoot.relativize(newcwd).toString();
            this.reply("250 CWD command succcessful. New CWD is <" + this._cwd + ">");
        }
        catch (NotDirCacheException e) {
            this.reply("550 Not a directory: " + arg);
        }
        catch (FileNotFoundCacheException e) {
            this.reply("550 File not found");
        }
        catch (CacheException e) {
            this.reply("451 CWD failed: " + e.getMessage());
            this._logger.error("Error in CWD: {}", (Throwable)e);
        }
    }

    public void ac_cdup(String arg) throws FTPCommandException {
        this.ac_cwd("..");
    }

    private InetSocketAddress getAddressOf(String[] s) {
        try {
            byte[] address = new byte[4];
            for (int i = 0; i < 4; ++i) {
                address[i] = (byte)Integer.parseInt(s[i]);
            }
            int port = Integer.parseInt(s[4]) * 256 + Integer.parseInt(s[5]);
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Bug detected (UnknownHostException should only be thrown if address has wrong length): " + e.toString());
        }
    }

    private void setActive(InetSocketAddress address) {
        this._mode = Mode.ACTIVE;
        this._clientDataAddress = address;
        this.closePassiveModeServerSocket();
    }

    private InetSocketAddress setPassive() throws FTPCommandException {
        try {
            if (this._passiveModeServerSocket == null) {
                this._logger.info("Opening server socket for passive mode");
                this._passiveModeServerSocket = ServerSocketChannel.open();
                this._passiveModePortRange.bind(this._passiveModeServerSocket.socket(), this._engine.getLocalAddress());
                this._mode = Mode.PASSIVE;
            }
            return (InetSocketAddress)this._passiveModeServerSocket.socket().getLocalSocketAddress();
        }
        catch (IOException e) {
            this._mode = Mode.ACTIVE;
            this.closePassiveModeServerSocket();
            throw new FTPCommandException(500, "Cannot enter passive mode: " + e);
        }
    }

    public void ac_port(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        String[] st = arg.split(",");
        if (st.length != 6) {
            this.reply(this.err("PORT", arg));
            return;
        }
        this.setActive(this.getAddressOf(st));
        this.reply(this.ok("PORT"));
    }

    public void ac_pasv(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        this.closePassiveModeServerSocket();
        InetSocketAddress address = this.setPassive();
        int port = address.getPort();
        byte[] hostb = address.getAddress().getAddress();
        int[] host = new int[4];
        for (int i = 0; i < 4; ++i) {
            host[i] = hostb[i] & 0xFF;
        }
        this.reply("227 OK (" + host[0] + "," + host[1] + "," + host[2] + "," + host[3] + "," + port / 256 + "," + port % 256 + ")");
    }

    public void ac_mode(String arg) {
        if (arg.equalsIgnoreCase("S")) {
            this._xferMode = "S";
            this.reply("200 Will use Stream mode");
        } else if (arg.equalsIgnoreCase("E")) {
            this._xferMode = "E";
            this.reply("200 Will use Extended Block mode");
        } else if (arg.equalsIgnoreCase("X")) {
            this._xferMode = "X";
            this.reply("200 Will use GridFTP 2 eXtended block mode");
        } else {
            this.reply("200 Unsupported transfer mode");
        }
    }

    public void ac_site(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        if (arg.equals("")) {
            this.reply("500 must supply the site specific command");
            return;
        }
        String[] args = arg.split(" ");
        if (args[0].equalsIgnoreCase("BUFSIZE")) {
            if (args.length != 2) {
                this.reply("500 command must be in the form 'SITE BUFSIZE <number>'");
                return;
            }
            this.ac_sbuf(args[1]);
        } else if (args[0].equalsIgnoreCase("CHKSUM")) {
            if (args.length != 2) {
                this.reply("500 command must be in the form 'SITE CHKSUM <value>'");
                return;
            }
            this.doCheckSum("adler32", args[1]);
        } else if (args[0].equalsIgnoreCase("CHMOD")) {
            if (args.length != 3) {
                this.reply("500 command must be in the form 'SITE CHMOD <octal perms> <file/dir>'");
                return;
            }
            this.doChmod(args[1], args[2]);
        } else {
            this.reply("500 Unknown SITE command");
            return;
        }
    }

    public void ac_cksm(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        String[] st = arg.split("\\s+");
        if (st.length != 4) {
            this.reply("500 Unsupported CKSM command operands");
            return;
        }
        String algo = st[0];
        String offset = st[1];
        String length = st[2];
        String path = st[3];
        long offsetL = 0L;
        long lengthL = -1L;
        try {
            offsetL = Long.parseLong(offset);
        }
        catch (NumberFormatException ex) {
            this.reply("501 Invalid offset format:" + ex);
            return;
        }
        try {
            lengthL = Long.parseLong(length);
        }
        catch (NumberFormatException ex) {
            this.reply("501 Invalid length format:" + ex);
            return;
        }
        try {
            this.doCksm(algo, path, offsetL, lengthL);
        }
        catch (FTPCommandException e) {
            this.reply(String.valueOf(e.getCode()) + " " + e.getReply());
        }
    }

    public void doCksm(String algo, String path, long offsetL, long lengthL) throws FTPCommandException {
        if (lengthL != -1L) {
            throw new FTPCommandException(504, "Unsupported checksum over partial file length");
        }
        if (offsetL != 0L) {
            throw new FTPCommandException(504, "Unsupported checksum over partial file offset");
        }
        try {
            ChecksumFactory cf = ChecksumFactory.getFactory((ChecksumType)ChecksumType.getChecksumType((String)algo));
            FileAttributes attributes = this._pnfs.getFileAttributes(this.absolutePath(path).toString(), EnumSet.of(FileAttribute.CHECKSUM));
            Checksum checksum = cf.find(attributes.getChecksums());
            if (checksum == null) {
                throw new FTPCommandException(504, "Checksum is not available, dynamic checksum calculation is not supported");
            }
            this.reply("213 " + checksum.getValue());
        }
        catch (CacheException ce) {
            throw new FTPCommandException(550, "Error retrieving " + path + ": " + ce.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new FTPCommandException(504, "Unsupported checksum type:" + e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FTPCommandException(504, "Unsupported checksum type:" + e);
        }
    }

    public void ac_scks(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        String[] st = arg.split("\\s+");
        if (st.length != 2) {
            this.reply("505 Unsupported SCKS command operands");
            return;
        }
        this.doCheckSum(st[0], st[1]);
    }

    public void doCheckSum(String type, String value) {
        try {
            this._checkSumFactory = ChecksumFactory.getFactory((ChecksumType)ChecksumType.getChecksumType((String)type));
            this._checkSum = this._checkSumFactory.create(value);
            this.reply("213 OK");
        }
        catch (NoSuchAlgorithmException e) {
            this._checkSumFactory = null;
            this._checkSum = null;
            this.reply("504 Unsupported checksum type:" + type);
        }
        catch (IllegalArgumentException e) {
            this._checkSumFactory = null;
            this._checkSum = null;
            this.reply("504 Unsupported checksum type:" + type);
        }
    }

    public void doChmod(String permstring, String path) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        if (path.equals("")) {
            this.reply(this.err("SITE CHMOD", path));
            return;
        }
        try {
            int newperms = Integer.parseInt(permstring, 8);
            FileAttributes attributes = this._pnfs.getFileAttributes(this.absolutePath(path).toString(), EnumSet.of(FileAttribute.PNFSID, FileAttribute.TYPE, FileAttribute.OWNER, FileAttribute.OWNER_GROUP));
            PnfsId myPnfsId = attributes.getPnfsId();
            boolean isADir = attributes.getFileType() == FileType.DIR;
            boolean isASymLink = attributes.getFileType() == FileType.LINK;
            int myUid = attributes.getOwner();
            int myGid = attributes.getGroup();
            if (isASymLink) {
                this.reply("502 chmod of symbolic links is not yet supported.");
                return;
            }
            FileMetaData newMetaData = new FileMetaData(isADir, myUid, myGid, newperms);
            this._pnfs.pnfsSetFileMetaData(myPnfsId, newMetaData);
            this.reply("200 OK");
        }
        catch (NumberFormatException ex) {
            this.reply("501 permissions argument must be an octal integer");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException ce) {
            this.reply("550 Permission denied, reason: " + (Object)((Object)ce));
        }
    }

    public void ac_sbuf(String arg) {
        int bufsize;
        if (arg.equals("")) {
            this.reply("500 must supply a buffer size");
            return;
        }
        try {
            bufsize = Integer.parseInt(arg);
        }
        catch (NumberFormatException ex) {
            this.reply("500 bufsize argument must be integer");
            return;
        }
        if (bufsize < 1) {
            this.reply("500 bufsize must be positive.  Probably large, but at least positive");
            return;
        }
        this._bufSize = bufsize;
        this.reply("200 bufsize set to " + arg);
    }

    public void ac_eret(String arg) {
        String[] st = arg.split("\\s+");
        if (st.length < 2) {
            this.reply(this.err("ERET", arg));
            return;
        }
        String extended_retrieve_mode = st[0];
        String cmd = "eret_" + extended_retrieve_mode.toLowerCase();
        Object[] args = new Object[]{arg};
        if (this._methodDict.containsKey(cmd)) {
            Method m = this._methodDict.get(cmd);
            try {
                this._logger.info("Error return invoking: {}({})", (Object)m.getName(), (Object)arg);
                m.invoke((Object)this, args);
            }
            catch (IllegalAccessException e) {
                this.reply("500 " + e.toString());
                this._skipBytes = 0L;
            }
            catch (InvocationTargetException e) {
                this.reply("500 " + e.toString());
                this._skipBytes = 0L;
            }
        } else {
            this.reply("504 ERET is not implemented for retrieve mode: " + extended_retrieve_mode);
        }
    }

    public void ac_esto(String arg) {
        String[] st = arg.split("\\s+");
        if (st.length < 2) {
            this.reply(this.err("ESTO", arg));
            return;
        }
        String extended_store_mode = st[0];
        String cmd = "esto_" + extended_store_mode.toLowerCase();
        Object[] args = new Object[]{arg};
        if (this._methodDict.containsKey(cmd)) {
            Method m = this._methodDict.get(cmd);
            try {
                this._logger.info("Esto invoking: {} ({})", (Object)m.getName(), (Object)arg);
                m.invoke((Object)this, args);
            }
            catch (IllegalAccessException e) {
                this.reply("500 " + e.toString());
                this._skipBytes = 0L;
            }
            catch (InvocationTargetException e) {
                this.reply("500 " + e.toString());
                this._skipBytes = 0L;
            }
        } else {
            this.reply("504 ESTO is not implemented for store mode: " + extended_store_mode);
        }
    }

    public void ac_esto_a(String arg) throws FTPCommandException {
        long asm_offset;
        String[] st = arg.split("\\s+");
        if (st.length != 3) {
            this.reply(this.err("ESTO", arg));
            return;
        }
        String extended_store_mode = st[0];
        if (!extended_store_mode.equalsIgnoreCase("a")) {
            this.reply("504 ESTO is not implemented for store mode: " + extended_store_mode);
            return;
        }
        String offset = st[1];
        String filename = st[2];
        try {
            asm_offset = Long.parseLong(offset);
        }
        catch (NumberFormatException e) {
            String err = "501 ESTO Adjusted Store Mode: invalid offset " + offset;
            this._logger.error(err);
            this.reply(err);
            return;
        }
        if (asm_offset != 0L) {
            this.reply("504 ESTO Adjusted Store Mode does not work with nonzero offset: " + offset);
            return;
        }
        this._logger.info("Performing esto in \"a\" mode with offset = {}", (Object)offset);
        this.ac_stor(filename);
    }

    public void ac_eret_p(String arg) throws FTPCommandException {
        String[] st = arg.split("\\s+");
        if (st.length != 4) {
            this.reply(this.err("ERET", arg));
            return;
        }
        String extended_retrieve_mode = st[0];
        if (!extended_retrieve_mode.equalsIgnoreCase("p")) {
            this.reply("504 ERET is not implemented for retrieve mode: " + extended_retrieve_mode);
            return;
        }
        String offset = st[1];
        String size = st[2];
        String filename = st[3];
        try {
            this.prm_offset = Long.parseLong(offset);
        }
        catch (NumberFormatException e) {
            String err = "501 ERET Partial Retrieve Mode: invalid offset " + offset;
            this._logger.error(err);
            this.reply(err);
            return;
        }
        try {
            this.prm_size = Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            String err = "501 ERET Partial Retrieve Mode: invalid size " + offset;
            this._logger.error(err);
            this.reply(err);
            return;
        }
        this._logger.info("Performing eret in \"p\" mode with offset = {} size = {}", (Object)offset, (Object)size);
        this.ac_retr(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_retr(String arg) throws FTPCommandException {
        try {
            if (this._skipBytes > 0L) {
                this.reply("504 RESTART not implemented");
                return;
            }
            this.retrieve(arg, this.prm_offset, this.prm_size, this._mode, this._xferMode, this._parallel, this._clientDataAddress, this._bufSize, false, 1);
        }
        finally {
            this.prm_offset = -1L;
            this.prm_size = -1L;
        }
    }

    protected synchronized Transfer setTransfer(FtpTransfer transfer) {
        this._transfer = transfer;
        this.notifyAll();
        return transfer;
    }

    protected synchronized void joinTransfer() throws InterruptedException {
        while (this._transfer != null) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieve(String file, long offset, long size, Mode mode, String xferMode, int parallel, InetSocketAddress client, int bufSize, boolean reply127, int version) throws FTPCommandException {
        this.checkLoggedIn();
        if (file.equals("")) {
            throw new FTPCommandException(501, "Missing path");
        }
        if (xferMode.equals("E") && mode == Mode.PASSIVE) {
            throw new FTPCommandException(500, "Cannot do passive retrieve in E mode");
        }
        if (xferMode.equals("X") && mode == Mode.PASSIVE && this._isProxyRequiredOnPassive) {
            throw new FTPCommandException(504, "Cannot use passive X mode");
        }
        if (this._checkSumFactory != null || this._checkSum != null) {
            throw new FTPCommandException(503, "Expecting STOR ESTO PUT commands");
        }
        FtpTransfer transfer = new FtpTransfer(this.absolutePath(file), offset, size, mode, xferMode, parallel, client, bufSize, reply127, version);
        try {
            this._logger.info("retrieve user={}", (Object)this.getUser());
            this._logger.info("retrieve addr={}", (Object)this._engine.getInetAddress());
            transfer.readNameSpaceEntry();
            transfer.createTransactionLog();
            transfer.checkAndDeriveOffsetAndSize();
            boolean retry = false;
            this.enableInterrupt();
            try {
                transfer.createAdapter();
                transfer.selectPoolAndStartMover(this._ioQueueName, this._readRetryPolicy);
                return;
            }
            finally {
                this.disableInterrupt();
            }
        }
        catch (PermissionDeniedCacheException e) {
            transfer.abort(550, "Permission denied");
            return;
        }
        catch (CacheException e) {
            switch (e.getRc()) {
                case 10001: {
                    transfer.abort(550, "File not found");
                    return;
                }
                case 10006: {
                    transfer.abort(451, "Internal timeout", (Exception)((Object)e));
                    return;
                }
                case 10010: {
                    transfer.abort(550, "Not a directory");
                    return;
                }
                default: {
                    transfer.abort(451, "Operation failed: " + e.getMessage(), (Exception)((Object)e));
                    return;
                }
            }
        }
        catch (FTPCommandException e) {
            transfer.abort(e.getCode(), e.getReply());
            return;
        }
        catch (InterruptedException e) {
            transfer.abort(451, "Operation cancelled");
            return;
        }
        catch (IOException e) {
            transfer.abort(451, "Operation failed: " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            this._logger.error("Retrieve failed", (Throwable)e);
            transfer.abort(451, "Transient internal failure");
            return;
        }
        finally {
            this._allo = 0L;
        }
    }

    public abstract void startTlog(FTPTransactionLog var1, String var2, String var3);

    public void ac_stor(String arg) throws FTPCommandException {
        if (this._clientDataAddress == null) {
            this.reply("504 Host somehow not set");
            return;
        }
        if (this._skipBytes > 0L) {
            this.reply("504 RESTART not implemented for STORE");
            return;
        }
        this.store(arg, this._mode, this._xferMode, this._parallel, this._clientDataAddress, this._bufSize, false, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void store(String file, Mode mode, String xferMode, int parallel, InetSocketAddress client, int bufSize, boolean reply127, int version) throws FTPCommandException {
        this.checkLoggedIn();
        this.checkWritable();
        if (file.equals("")) {
            throw new FTPCommandException(501, "STOR command not understood");
        }
        if (xferMode.equals("E") && mode == Mode.ACTIVE) {
            throw new FTPCommandException(504, "Cannot store in active E mode");
        }
        if (xferMode.equals("X") && mode == Mode.PASSIVE && this._isProxyRequiredOnPassive) {
            throw new FTPCommandException(504, "Cannot use passive X mode");
        }
        FtpTransfer transfer = new FtpTransfer(this.absolutePath(file), 0L, 0L, mode, xferMode, parallel, client, bufSize, reply127, version);
        try {
            this._logger.info("store receiving with mode {}", (Object)xferMode);
            transfer.createNameSpaceEntry();
            transfer.createTransactionLog();
            transfer.setChecksum(this._checkSum);
            this.enableInterrupt();
            try {
                transfer.createAdapter();
                transfer.selectPoolAndStartMover(this._ioQueueName, this._writeRetryPolicy);
                return;
            }
            finally {
                this.disableInterrupt();
            }
        }
        catch (InterruptedException e) {
            transfer.abort(451, "Operation cancelled");
            return;
        }
        catch (IOException e) {
            transfer.abort(451, "Operation failed: " + e.getMessage());
            return;
        }
        catch (PermissionDeniedCacheException e) {
            transfer.abort(550, "Permission denied");
            return;
        }
        catch (CacheException e) {
            switch (e.getRc()) {
                case 10001: {
                    transfer.abort(550, "File not found");
                    return;
                }
                case 10008: {
                    transfer.abort(550, "File exists");
                    return;
                }
                case 10006: {
                    transfer.abort(451, "Internal timeout", (Exception)((Object)e));
                    return;
                }
                case 10010: {
                    transfer.abort(501, "Not a directory");
                    return;
                }
                default: {
                    transfer.abort(451, "Operation failed: " + e.getMessage(), (Exception)((Object)e));
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            this._logger.error("Store failed", (Throwable)e);
            transfer.abort(451, "Transient internal failure");
            return;
        }
        finally {
            this._checkSumFactory = null;
            this._checkSum = null;
            this._allo = 0L;
        }
    }

    public void ac_size(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        if (arg.equals("")) {
            this.reply(this.err("SIZE", ""));
            return;
        }
        FsPath path = this.absolutePath(arg);
        long filelength = 0L;
        try {
            FileAttributes attributes = this._pnfs.getFileAttributes(path.toString(), EnumSet.of(FileAttribute.SIZE));
            filelength = attributes.getSize();
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
            return;
        }
        catch (CacheException ce) {
            this.reply("550 Permission denied, reason: " + (Object)((Object)ce));
            return;
        }
        this.reply("213 " + filelength);
    }

    public void ac_mdtm(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        if (arg.equals("")) {
            this.reply(this.err("MDTM", ""));
            return;
        }
        try {
            FsPath path = this.absolutePath(arg);
            FileAttributes attributes = this._pnfs.getFileAttributes(path.toString(), EnumSet.of(FileAttribute.MODIFICATION_TIME));
            long modification_time = attributes.getModificationTime();
            String time_val = this.TIMESTAMP_FORMAT.format(new Date(modification_time));
            this.reply("213 " + time_val);
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            switch (e.getRc()) {
                case 10001: {
                    this.reply("550 File not found");
                    break;
                }
                case 10006: {
                    this.reply("451 Internal timeout");
                    this._logger.warn("Timeout in MDTM: {}", (Throwable)e);
                    break;
                }
                default: {
                    this.reply("451 Internal failure: " + e.getMessage());
                    this._logger.error("Error in MDTM: {}", (Throwable)e);
                }
            }
        }
    }

    private void openDataSocket() throws IOException {
        if (this._mode == Mode.PASSIVE) {
            this._dataSocket = this._passiveModeServerSocket.accept().socket();
        } else {
            this._dataSocket = new Socket();
            this._dataSocket.connect(this._clientDataAddress);
        }
    }

    private void closeDataSocket() {
        Socket socket = this._dataSocket;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                this._logger.warn("Got I/O exception closing socket: {}", (Object)e.getMessage());
            }
            this._dataSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_list(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        Args args = new Args((CharSequence)arg);
        boolean listLong = args.options().isEmpty() || args.hasOption("l");
        arg = args.argc() == 0 ? "" : args.argv(0);
        FsPath path = this.absolutePath(arg);
        try {
            int total;
            this.enableInterrupt();
            this.reply("150 Opening ASCII data connection for file list", false);
            try {
                this.openDataSocket();
            }
            catch (IOException e) {
                this.reply("425 Cannot open connection");
                this.disableInterrupt();
                return;
            }
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this._dataSocket.getOutputStream()), "US-ASCII"));
                Object printer = listLong ? new LongListPrinter(writer) : new ShortListPrinter(writer);
                try {
                    total = this._listSource.printDirectory(null, (DirectoryListPrinter)printer, path, null, Ranges.all());
                }
                catch (NotDirCacheException e) {
                    this._listSource.printFile(null, (DirectoryListPrinter)printer, path);
                    total = 1;
                }
                catch (FileNotFoundCacheException e) {
                    total = this._listSource.printDirectory(null, (DirectoryListPrinter)printer, path.getParent(), new Glob(path.getName()), Ranges.all());
                }
                writer.close();
            }
            finally {
                this.closeDataSocket();
            }
            this.reply("226 " + total + " files");
        }
        catch (InterruptedException e) {
            this.reply("451 Operation cancelled");
        }
        catch (FileNotFoundCacheException e) {
            this.reply("550 File not found");
        }
        catch (NotDirCacheException e) {
            this.reply("550 Not a directory");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in LIST: {}", (Object)e.getMessage());
        }
        catch (EOFException e) {
            this.reply("426 Connection closed; transfer aborted");
        }
        catch (IOException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in LIST: {}", (Object)e.getMessage());
        }
        finally {
            this.disableInterrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_nlst(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        if (arg.equals("")) {
            arg = ".";
        }
        try {
            int total;
            this.enableInterrupt();
            FsPath path = this.absolutePath(arg);
            Matcher m = GLOB_PATTERN.matcher(path.getName());
            boolean pathIsPattern = m.find();
            if (!pathIsPattern) {
                this.checkIsDirectory(path);
            }
            this.reply("150 Opening ASCII data connection for file list", false);
            try {
                this.openDataSocket();
            }
            catch (IOException e) {
                this.reply("425 Cannot open connection");
                this.disableInterrupt();
                return;
            }
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this._dataSocket.getOutputStream()), "US-ASCII"));
                ShortListPrinter printer = new ShortListPrinter(writer);
                total = pathIsPattern ? this._listSource.printDirectory(null, (DirectoryListPrinter)printer, path.getParent(), new Glob(path.getName()), Ranges.all()) : this._listSource.printDirectory(null, (DirectoryListPrinter)printer, path, null, Ranges.all());
                writer.close();
            }
            finally {
                this.closeDataSocket();
            }
            this.reply("226 " + total + " files");
        }
        catch (InterruptedException e) {
            this.reply("451 Operation cancelled");
        }
        catch (FileNotFoundCacheException e) {
            this.reply("550 Directory not found");
        }
        catch (NotDirCacheException e) {
            this.reply("550 Not a directory");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in NLST: {}", (Object)e.getMessage());
        }
        catch (EOFException e) {
            this.reply("426 Connection closed; transfer aborted");
        }
        catch (IOException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in NLST: {}", (Object)e.getMessage());
        }
        finally {
            this.disableInterrupt();
        }
    }

    public void ac_mlst(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        try {
            FsPath path = this.absolutePath(arg);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print("250- Listing " + arg + "\r\n");
            pw.print(' ');
            this._listSource.printFile(null, (DirectoryListPrinter)new MlstFactPrinter(pw), path);
            pw.print("250 End");
            this.reply(sw.toString());
        }
        catch (InterruptedException e) {
            this.reply("451 Operation cancelled");
        }
        catch (FileNotFoundCacheException e) {
            this.reply("550 File not found");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in MLST: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_mlsd(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        try {
            int total;
            this.enableInterrupt();
            FsPath path = arg.length() == 0 ? this.absolutePath(".") : this.absolutePath(arg);
            this.checkIsDirectory(path);
            this.reply("150 Openening ASCII mode data connection for MLSD", false);
            try {
                this.openDataSocket();
            }
            catch (IOException e) {
                this.reply("425 Cannot open connection");
                this.disableInterrupt();
                return;
            }
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this._dataSocket.getOutputStream()), "UTF-8"));
                total = this._listSource.printDirectory(null, (DirectoryListPrinter)new MlsdFactPrinter(writer), path, null, Ranges.all());
                writer.close();
            }
            finally {
                this.closeDataSocket();
            }
            this.reply("226 MLSD completed for " + total + " files");
        }
        catch (InterruptedException e) {
            this.reply("451 Operation cancelled");
        }
        catch (FileNotFoundCacheException e) {
            this.reply("501 Directory not found");
        }
        catch (NotDirCacheException e) {
            this.reply("501 Not a directory");
        }
        catch (PermissionDeniedCacheException e) {
            this.reply("550 Permission denied");
        }
        catch (CacheException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in MLSD: {}", (Object)e.getMessage());
        }
        catch (EOFException e) {
            this.reply("426 Connection closed; transfer aborted");
        }
        catch (IOException e) {
            this.reply("451 Local error in processing");
            this._logger.warn("Error in MLSD: {}", (Object)e.getMessage());
        }
        finally {
            this.disableInterrupt();
        }
    }

    public void ac_rnfr(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        try {
            this.enableInterrupt();
            this._filepath = null;
            if (Strings.isNullOrEmpty((String)arg)) {
                throw new FTPCommandException(500, "Missing file name for RNFR");
            }
            FsPath path = this.absolutePath(arg);
            this._pnfs.getPnfsIdByPath(path.toString());
            this._filepath = path;
            this.reply("350 File exists, ready for destination name RNTO");
        }
        catch (InterruptedException e) {
            throw new FTPCommandException(451, "Operation cancelled");
        }
        catch (CacheException e) {
            throw new FTPCommandException(550, "File not found");
        }
        finally {
            this.disableInterrupt();
        }
    }

    public void ac_rnto(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        try {
            this.enableInterrupt();
            if (this._filepath == null) {
                throw new FTPCommandException(503, "RNTO must be preceeded by RNFR");
            }
            if (Strings.isNullOrEmpty((String)arg)) {
                throw new FTPCommandException(500, "missing destination name for RNTO");
            }
            FsPath newName = this.absolutePath(arg);
            this._pnfs.renameEntry(this._filepath.toString(), newName.toString(), true);
            this.reply("250 File renamed");
        }
        catch (InterruptedException e) {
            throw new FTPCommandException(451, "Operation cancelled");
        }
        catch (CacheException e) {
            throw new FTPCommandException(550, "Permission denied");
        }
        finally {
            this._filepath = null;
            this.disableInterrupt();
        }
    }

    public void ac_dcau(String arg) {
        if (arg.equalsIgnoreCase("N")) {
            this.reply("200 data channel authtication switched off");
        } else {
            this.reply("202 data channel authtication not sopported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_quit(String arg) throws CommandExitException {
        this.reply("221 Goodbye");
        try {
            this.enableInterrupt();
            this.joinTransfer();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.disableInterrupt();
        }
        throw new CommandExitException("", 0);
    }

    public void ac_bye(String arg) throws CommandExitException {
        this.ac_quit(arg);
    }

    public void ac_abor(String arg) throws FTPCommandException {
        this.checkLoggedIn();
        FtpTransfer transfer = this._transfer;
        if (transfer != null) {
            transfer.abort(426, "Transfer aborted");
        }
        this.closeDataSocket();
        this.reply("226 Abort successful");
    }

    public String err(String cmd, String arg) {
        String msg = "500 '" + cmd;
        if (arg.length() > 0) {
            msg = msg + " " + arg;
        }
        msg = msg + "': command not understood";
        return msg;
    }

    public String ok(String cmd) {
        return "200 " + cmd + " command successful";
    }

    private void checkIsDirectory(FsPath path) throws CacheException {
        FileAttributes attributes = this._pnfs.getFileAttributes(path.toString(), EnumSet.of(FileAttribute.SIMPLE_TYPE));
        if (attributes.getFileType() != FileType.DIR) {
            throw new NotDirCacheException("Not a directory");
        }
    }

    protected void enableInterrupt() throws InterruptedException {
        this._commandQueue.enableInterrupt();
    }

    protected void disableInterrupt() {
        this._commandQueue.disableInterrupt();
    }

    protected Map<String, String> parseGetPutParameters(String s) throws FTPCommandException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Matcher matcher = _parameterPattern.matcher(s);
        while (matcher.lookingAt()) {
            String keyword = matcher.group(1);
            String value = matcher.group(2);
            if (_valuePatterns.containsKey(keyword)) {
                Pattern valuePattern = _valuePatterns.get(keyword);
                if (valuePattern == null && value != null || valuePattern != null && !valuePattern.matcher(value != null ? value : "").matches()) {
                    String msg = "Illegal or unexpected value for " + keyword + "=" + value;
                    throw new FTPCommandException(501, msg);
                }
                parameters.put(keyword, value);
            }
            matcher.region(matcher.end(), matcher.regionEnd());
        }
        if (matcher.regionStart() != matcher.regionEnd()) {
            String msg = "Cannot parse '" + s.substring(matcher.regionStart()) + "'";
            throw new FTPCommandException(501, msg);
        }
        return parameters;
    }

    protected void reply127PORT(InetSocketAddress address) {
        int port = address.getPort();
        byte[] host = address.getAddress().getAddress();
        this.reply(String.format("127 PORT (%d,%d,%d,%d,%d,%d)", host[0] & 0xFF, host[1] & 0xFF, host[2] & 0xFF, host[3] & 0xFF, port / 256, port % 256), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ac_get(String arg) {
        try {
            boolean reply127 = false;
            if (this._skipBytes > 0L) {
                throw new FTPCommandException(501, "RESTART not implemented");
            }
            Map<String, String> parameters = this.parseGetPutParameters(arg);
            if (parameters.containsKey("pasv") && parameters.containsKey("port")) {
                throw new FTPCommandException(501, "Cannot use both 'pasv' and 'port'");
            }
            if (!parameters.containsKey("path")) {
                throw new FTPCommandException(501, "Missing path");
            }
            if (parameters.containsKey("mode")) {
                this._xferMode = parameters.get("mode").toUpperCase();
            }
            if (parameters.containsKey("pasv")) {
                reply127 = true;
                this.setPassive();
            }
            if (parameters.containsKey("port")) {
                this.setActive(this.getAddressOf(parameters.get("port").split(",")));
            }
            this.retrieve(parameters.get("path"), this.prm_offset, this.prm_size, this._mode, this._xferMode, this._parallel, this._clientDataAddress, this._bufSize, reply127, 2);
        }
        catch (FTPCommandException e) {
            this.reply(String.valueOf(e.getCode()) + " " + e.getReply());
        }
        finally {
            this.prm_offset = -1L;
            this.prm_size = -1L;
        }
    }

    public void ac_put(String arg) {
        boolean reply127 = false;
        try {
            Map<String, String> parameters = this.parseGetPutParameters(arg);
            if (parameters.containsKey("pasv") && parameters.containsKey("port")) {
                throw new FTPCommandException(501, "Cannot use both 'pasv' and 'port'");
            }
            if (!parameters.containsKey("path")) {
                throw new FTPCommandException(501, "Missing path");
            }
            if (parameters.containsKey("mode")) {
                this._xferMode = parameters.get("mode").toUpperCase();
            }
            if (parameters.containsKey("pasv")) {
                reply127 = true;
                this.setPassive();
            }
            if (parameters.containsKey("port")) {
                this.setActive(this.getAddressOf(parameters.get("port").split(",")));
            }
            this.store(parameters.get("path"), this._mode, this._xferMode, this._parallel, this._clientDataAddress, this._bufSize, reply127, 2);
        }
        catch (FTPCommandException e) {
            this.reply(String.valueOf(e.getCode()) + " " + e.getReply());
        }
    }

    private void sendRemoveInfoToBilling(FsPath path) {
        try {
            DoorRequestInfoMessage infoRemove = new DoorRequestInfoMessage(this.getNucleus().getCellName() + "@" + this.getNucleus().getCellDomainName(), "remove");
            infoRemove.setSubject(this._subject);
            infoRemove.setPath(path.toString());
            infoRemove.setClient(this._clientDataAddress.getAddress().getHostAddress());
            this._billingStub.send((Serializable)infoRemove);
        }
        catch (NoRouteToCellException e) {
            this._logger.error("Can't send remove message to billing database: {}", (Object)e.getMessage());
        }
    }

    static {
        _valuePatterns.put("mode", Pattern.compile("[Ee]|[Ss]|[Xx]"));
        _valuePatterns.put("pasv", null);
        _valuePatterns.put("cksum", Pattern.compile("NONE"));
        _valuePatterns.put("path", Pattern.compile(".+"));
        _valuePatterns.put("port", Pattern.compile("(\\d+)(,(\\d+)){5}"));
    }

    private class MlstFactPrinter
    extends FactPrinter {
        public MlstFactPrinter(PrintWriter writer) {
            super(writer);
        }

        @Override
        protected void printName(FsPath dir, DirectoryEntry entry) {
            this._out.print(AbstractFtpDoorV1.this._pathRoot.relativize(new FsPath(dir, entry.getName())));
        }
    }

    private class MlsdFactPrinter
    extends FactPrinter {
        public MlsdFactPrinter(PrintWriter writer) {
            super(writer);
        }

        @Override
        protected void printName(FsPath dir, DirectoryEntry entry) {
            this._out.print(entry.getName());
        }
    }

    private abstract class FactPrinter
    implements DirectoryListPrinter {
        private static final int MODE_MASK = 4095;
        protected final PrintWriter _out;
        private final PermissionHandler _pdp = new ChainedPermissionHandler(new PermissionHandler[]{new ACLPermissionHandler(), new PosixPermissionHandler()});

        public FactPrinter(PrintWriter writer) {
            this._out = writer;
        }

        public Set<FileAttribute> getRequiredAttributes() {
            EnumSet<FileAttribute> attributes = EnumSet.noneOf(FileAttribute.class);
            for (Fact fact : AbstractFtpDoorV1.this._currentFacts) {
                switch (fact) {
                    case SIZE: {
                        attributes.add(FileAttribute.SIMPLE_TYPE);
                        attributes.add(FileAttribute.SIZE);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case MODIFY: {
                        attributes.add(FileAttribute.MODIFICATION_TIME);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case TYPE: {
                        attributes.add(FileAttribute.SIMPLE_TYPE);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case PERM: {
                        attributes.add(FileAttribute.SIMPLE_TYPE);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case UNIQUE: {
                        attributes.add(FileAttribute.PNFSID);
                        break;
                    }
                    case OWNER: {
                        attributes.add(FileAttribute.OWNER);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case GROUP: {
                        attributes.add(FileAttribute.OWNER_GROUP);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                        break;
                    }
                    case MODE: {
                        attributes.add(FileAttribute.MODE);
                        attributes.addAll(this._pdp.getRequiredAttributes());
                    }
                }
            }
            return attributes;
        }

        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
            if (!AbstractFtpDoorV1.this._currentFacts.isEmpty()) {
                FileAttributes attr = entry.getFileAttributes();
                for (Fact fact : AbstractFtpDoorV1.this._currentFacts) {
                    switch (fact) {
                        case SIZE: {
                            AccessType access;
                            if (attr.getFileType() == FileType.DIR || (access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.SIZE))) != AccessType.ACCESS_ALLOWED) break;
                            this.printSizeFact(attr);
                            break;
                        }
                        case MODIFY: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.MODIFICATION_TIME));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printModifyFact(attr);
                            break;
                        }
                        case TYPE: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.TYPE));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printTypeFact(attr);
                            break;
                        }
                        case UNIQUE: {
                            this.printUniqueFact(attr);
                            break;
                        }
                        case PERM: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.MODE, FileAttribute.ACL));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printPermFact(dirAttr, attr);
                            break;
                        }
                        case OWNER: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.OWNER));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printOwnerFact(attr);
                            break;
                        }
                        case GROUP: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.OWNER_GROUP));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printGroupFact(attr);
                            break;
                        }
                        case MODE: {
                            AccessType access = this._pdp.canGetAttributes(AbstractFtpDoorV1.this._subject, dirAttr, attr, EnumSet.of(FileAttribute.MODE));
                            if (access != AccessType.ACCESS_ALLOWED) break;
                            this.printModeFact(attr);
                        }
                    }
                }
            }
            this._out.print(' ');
            this.printName(dir, entry);
            this._out.print("\r\n");
        }

        private void printFact(Fact fact, Object value) {
            this._out.print(fact.getName());
            this._out.print('=');
            this._out.print(value);
            this._out.print(';');
        }

        private void printModifyFact(FileAttributes attr) {
            long time = attr.getModificationTime();
            this.printFact(Fact.MODIFY, AbstractFtpDoorV1.this.TIMESTAMP_FORMAT.format(new Date(time)));
        }

        private void printSizeFact(FileAttributes attr) {
            this.printFact(Fact.SIZE, attr.getSize());
        }

        private void printOwnerFact(FileAttributes attr) {
            this.printFact(Fact.OWNER, attr.getOwner());
        }

        private void printGroupFact(FileAttributes attr) {
            this.printFact(Fact.GROUP, attr.getGroup());
        }

        private void printModeFact(FileAttributes attr) {
            this.printFact(Fact.MODE, Integer.toOctalString(attr.getMode() & 0xFFF));
        }

        private void printTypeFact(FileAttributes attr) {
            switch (attr.getFileType()) {
                case DIR: {
                    this.printFact(Fact.TYPE, "dir");
                    break;
                }
                case REGULAR: {
                    this.printFact(Fact.TYPE, "file");
                    break;
                }
                case LINK: {
                    this.printFact(Fact.TYPE, "OS.UNIX=slink");
                }
            }
        }

        private void printUniqueFact(FileAttributes attr) {
            this.printFact(Fact.UNIQUE, attr.getPnfsId());
        }

        private void printPermFact(FileAttributes parentAttr, FileAttributes attr) {
            StringBuilder s = new StringBuilder();
            if (attr.getFileType() == FileType.DIR) {
                if (this._pdp.canCreateFile(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('c');
                }
                if (this._pdp.canDeleteDir(AbstractFtpDoorV1.this._subject, parentAttr, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('d');
                }
                s.append('e');
                if (this._pdp.canListDir(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('l');
                }
                if (this._pdp.canCreateSubDir(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('m');
                }
            } else {
                if (this._pdp.canDeleteFile(AbstractFtpDoorV1.this._subject, parentAttr, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('d');
                }
                if (this._pdp.canReadFile(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED) {
                    s.append('r');
                }
            }
            this.printFact(Fact.PERM, s);
        }

        protected abstract void printName(FsPath var1, DirectoryEntry var2);
    }

    class LongListPrinter
    implements DirectoryListPrinter {
        private final String _userName;
        private final PrintWriter _out;
        private final PermissionHandler _pdp = new ChainedPermissionHandler(new PermissionHandler[]{new ACLPermissionHandler(), new PosixPermissionHandler()});

        public LongListPrinter(PrintWriter writer) {
            this._out = writer;
            this._userName = Subjects.getUserName((Subject)AbstractFtpDoorV1.this._subject);
        }

        public Set<FileAttribute> getRequiredAttributes() {
            EnumSet<FileAttribute> attributes = EnumSet.of(FileAttribute.SIMPLE_TYPE, FileAttribute.MODIFICATION_TIME, FileAttribute.SIZE);
            attributes.addAll(this._pdp.getRequiredAttributes());
            return attributes;
        }

        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
            StringBuilder mode = new StringBuilder();
            FileAttributes attr = entry.getFileAttributes();
            if (attr.getFileType() == FileType.DIR) {
                boolean canListDir = this._pdp.canListDir(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED;
                boolean canLookup = this._pdp.canLookup(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED;
                boolean canCreateFile = this._pdp.canCreateFile(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED;
                boolean canCreateDir = this._pdp.canCreateSubDir(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED;
                mode.append('d');
                mode.append(canListDir ? (char)'r' : '-');
                mode.append(canCreateFile || canCreateDir ? (char)'w' : '-');
                mode.append((char)(canLookup || canListDir || canCreateFile || canCreateDir ? 120 : 45));
                mode.append("------");
            } else {
                boolean canReadFile = this._pdp.canReadFile(AbstractFtpDoorV1.this._subject, attr) == AccessType.ACCESS_ALLOWED;
                mode.append('-');
                mode.append(canReadFile ? (char)'r' : '-');
                mode.append('-');
                mode.append('-');
                mode.append("------");
            }
            long modified = attr.getModificationTime();
            long age = System.currentTimeMillis() - modified;
            String format = age > 15724800000L ? "%1$s  1 %2$-10s %3$-10s %4$12d %5$tb %5$2te %5$5tY %6$s" : "%1$s  1 %2$-10s %3$-10s %4$12d %5$tb %5$2te %5$5tR %6$s";
            this._out.format(format, mode, this._userName, this._userName, attr.getSize(), modified, entry.getName());
            this._out.append("\r\n");
        }
    }

    static class ShortListPrinter
    implements DirectoryListPrinter {
        private final PrintWriter _out;

        public ShortListPrinter(PrintWriter writer) {
            this._out = writer;
        }

        public Set<FileAttribute> getRequiredAttributes() {
            return EnumSet.noneOf(FileAttribute.class);
        }

        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
            this._out.append(entry.getName()).append("\r\n");
        }
    }

    class CommandQueue {
        private final Queue<String> _commands = new LinkedList<String>();
        private Thread _thread;
        private boolean _stopped = false;
        private boolean _running = false;

        CommandQueue() {
        }

        public synchronized void add(String command) {
            if (!this._stopped) {
                this._commands.add(command);
                if (!this._running) {
                    final CDC cdc = new CDC();
                    this._running = true;
                    _executor.submit((Runnable)new FireAndForgetTask(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            CDC old = new CDC();
                            try {
                                cdc.restore();
                                String command = CommandQueue.this.getOrDone();
                                while (command != null) {
                                    try {
                                        AbstractFtpDoorV1.this.execute(command);
                                    }
                                    catch (RuntimeException e) {
                                        AbstractFtpDoorV1.this._logger.error("Bug detected", (Throwable)e);
                                    }
                                    command = CommandQueue.this.getOrDone();
                                }
                            }
                            finally {
                                old.restore();
                            }
                        }
                    }));
                }
            }
        }

        private synchronized String getOrDone() {
            if (this._stopped || this._commands.isEmpty()) {
                this._running = false;
                this.notifyAll();
                return null;
            }
            return this._commands.remove();
        }

        public synchronized void stop() throws InterruptedException {
            if (!this._stopped) {
                this._stopped = true;
                if (this._thread != null) {
                    this._thread.interrupt();
                }
                if (this._running) {
                    this.wait();
                }
            }
        }

        synchronized void enableInterrupt() throws InterruptedException {
            if (this._stopped) {
                throw new InterruptedException();
            }
            this._thread = Thread.currentThread();
        }

        synchronized void disableInterrupt() {
            this._thread = null;
        }
    }

    private class PerfMarkerTask
    extends TimerTask
    implements CellMessageAnswerable {
        private final GFtpPerfMarkersBlock _perfMarkersBlock = new GFtpPerfMarkersBlock(1);
        private final long _timeout;
        private final String _pool;
        private final int _moverId;
        private final CDC _cdc;
        private boolean _stopped = false;

        public PerfMarkerTask(String pool, int moverId, long timeout) {
            this._pool = pool;
            this._moverId = moverId;
            this._timeout = timeout;
            this._cdc = new CDC();
            this.sendMarker();
        }

        public synchronized void stop() {
            this.cancel();
            this._stopped = true;
        }

        public synchronized void stop(GFtpProtocolInfo info) {
            this.setProgressInfo(info.getBytesTransferred(), System.currentTimeMillis());
            this.sendMarker();
            this.stop();
        }

        protected synchronized void sendMarker() {
            if (!this._stopped) {
                AbstractFtpDoorV1.this.reply(this._perfMarkersBlock.markers(0).getReply(), false);
            }
        }

        protected synchronized void setProgressInfo(long bytes, long timeStamp) {
            GFtpPerfMarker marker = this._perfMarkersBlock.markers(0);
            timeStamp = Math.max(timeStamp, marker.getTimeStamp());
            marker.setBytesWithTime(bytes, timeStamp);
        }

        @Override
        public synchronized void run() {
            this._cdc.restore();
            CellMessage msg = new CellMessage(new CellPath(this._pool), (Object)("mover ls -binary " + this._moverId));
            AbstractFtpDoorV1.this.sendMessage(msg, this, this._timeout);
        }

        public synchronized void exceptionArrived(CellMessage request, Exception exception) {
            if (exception instanceof NoRouteToCellException) {
                this.sendMarker();
            } else {
                AbstractFtpDoorV1.this._logger.error("PerfMarkerEngine got exception {}", (Object)exception.getMessage());
            }
        }

        public synchronized void answerTimedOut(CellMessage request) {
            this.sendMarker();
        }

        public synchronized void answerArrived(CellMessage req, CellMessage answer) {
            Object msg = answer.getMessageObject();
            if (msg instanceof IoJobInfo) {
                IoJobInfo ioJobInfo = (IoJobInfo)msg;
                String status = ioJobInfo.getStatus();
                if (status == null) {
                    this.sendMarker();
                } else if (status.equals("A") || status.equals("RUNNING")) {
                    this.setProgressInfo(ioJobInfo.getBytesTransferred(), ioJobInfo.getLastTransferred());
                    this.sendMarker();
                } else if (!status.equals("K") && !status.equals("R")) {
                    if (status.equals("W") || status.equals("QUEUED")) {
                        this.sendMarker();
                    } else {
                        AbstractFtpDoorV1.this._logger.error("Performance marker engine received unexcepted status from mover: {}", (Object)status);
                    }
                }
            } else if (msg instanceof Exception) {
                AbstractFtpDoorV1.this._logger.warn("Performance marker engine: {}", (Object)((Exception)msg).getMessage());
            } else if (msg instanceof String) {
                AbstractFtpDoorV1.this._logger.info("Performance marker engine: {}", msg);
            } else {
                AbstractFtpDoorV1.this._logger.error("Performance marker engine: {}", (Object)msg.getClass().getName());
            }
        }
    }

    public class AdminCommandListener {
        public String hh_get_door_info = "[-binary]";

        public Object ac_get_door_info(Args args) {
            IoDoorInfo doorInfo = new IoDoorInfo(AbstractFtpDoorV1.this.getCellName(), AbstractFtpDoorV1.this.getCellDomainName());
            long[] uids = AbstractFtpDoorV1.this._subject != null ? Subjects.getUids((Subject)AbstractFtpDoorV1.this._subject) : new long[]{};
            doorInfo.setOwner(uids.length == 0 ? "0" : Long.toString(uids[0]));
            doorInfo.setProcess("0");
            FtpTransfer transfer = AbstractFtpDoorV1.this._transfer;
            if (transfer != null) {
                IoDoorEntry[] entries = new IoDoorEntry[]{transfer.getIoDoorEntry()};
                doorInfo.setIoDoorEntries(entries);
                doorInfo.setProtocol("GFtp", String.valueOf(transfer.getVersion()));
            } else {
                IoDoorEntry[] entries = new IoDoorEntry[]{};
                doorInfo.setIoDoorEntries(entries);
                doorInfo.setProtocol("GFtp", "1");
            }
            if (args.hasOption("binary")) {
                return doorInfo;
            }
            return doorInfo.toString();
        }
    }

    protected class FtpTransfer
    extends Transfer {
        private final Mode _mode;
        private final String _xferMode;
        private final int _parallel;
        private final InetSocketAddress _client;
        private final int _bufSize;
        private final boolean _reply127;
        private final int _version;
        private long _offset;
        private long _size;
        protected FTPTransactionLog _tLog;
        protected ProxyAdapter _adapter;
        protected PerfMarkerTask _perfMarkerTask;
        protected boolean _aborted;
        protected boolean _completed;

        public FtpTransfer(FsPath path, long offset, long size, Mode mode, String xferMode, int parallel, InetSocketAddress client, int bufSize, boolean reply127, int version) {
            super(AbstractFtpDoorV1.this._pnfs, AbstractFtpDoorV1.this._subject, path);
            this._aborted = false;
            this._completed = false;
            this.setDomainName(AbstractFtpDoorV1.this.getCellDomainName());
            this.setCellName(AbstractFtpDoorV1.this.getCellName());
            this.setClientAddress((InetSocketAddress)AbstractFtpDoorV1.this._engine.getSocket().getRemoteSocketAddress());
            this.setCheckStagePermission(this._checkStagePermission);
            this.setOverwriteAllowed(AbstractFtpDoorV1.this._overwrite);
            this.setPoolManagerStub(AbstractFtpDoorV1.this._poolManagerStub);
            this.setPoolStub(AbstractFtpDoorV1.this._poolStub);
            this.setBillingStub(AbstractFtpDoorV1.this._billingStub);
            this.setAllocation(AbstractFtpDoorV1.this._allo);
            this._offset = offset;
            this._size = size;
            this._mode = mode;
            this._xferMode = xferMode;
            this._parallel = parallel;
            this._client = client;
            this._bufSize = bufSize;
            this._reply127 = reply127;
            this._version = version;
            AbstractFtpDoorV1.this.setTransfer(this);
        }

        public int getVersion() {
            return this._version;
        }

        private synchronized void createAdapter() throws IOException {
            switch (this._mode) {
                case PASSIVE: {
                    this._adapter = new SocketAdapter(AbstractFtpDoorV1.this, AbstractFtpDoorV1.this._passiveModeServerSocket);
                    break;
                }
                case ACTIVE: {
                    if (!AbstractFtpDoorV1.this._isProxyRequiredOnActive) break;
                    AbstractFtpDoorV1.this._logger.info("Creating adapter for active mode");
                    this._adapter = new ActiveAdapter(AbstractFtpDoorV1.this._passiveModePortRange, this._client.getAddress().getHostAddress(), this._client.getPort());
                }
            }
            if (this._adapter != null) {
                this._adapter.setMaxBlockSize(AbstractFtpDoorV1.this._maxBlockSize);
                this._adapter.setModeE(this._xferMode.equals("E"));
                if (this.isWrite()) {
                    this._adapter.setDirClientToPool();
                } else {
                    this._adapter.setDirPoolToClient();
                }
            }
        }

        public synchronized void checkAndDeriveOffsetAndSize() throws FTPCommandException {
            long fileSize = this.getStorageInfo().getFileSize();
            if (this._offset == -1L) {
                this._offset = 0L;
            }
            if (this._size == -1L) {
                this._size = fileSize;
            }
            if (this._offset < 0L) {
                throw new FTPCommandException(500, "prm offset is " + this._offset);
            }
            if (this._size < 0L) {
                throw new FTPCommandException(500, "prm_size is " + this._size);
            }
            if (this._offset + this._size > fileSize) {
                throw new FTPCommandException(500, "invalid prm_offset=" + this._offset + " and prm_size " + this._size + " for file of size " + fileSize);
            }
        }

        protected synchronized ProtocolInfo getProtocolInfoForPoolManager() {
            return new GFtpProtocolInfo("GFtp", this._version, 0, this._client.getAddress().getHostAddress(), this._client.getPort(), this._parallel, this._parallel, this._parallel, this._bufSize, 0L, 0L);
        }

        protected synchronized ProtocolInfo getProtocolInfoForPool() {
            boolean usePassivePool = !AbstractFtpDoorV1.this._isProxyRequiredOnPassive && this._reply127;
            GFtpProtocolInfo protocolInfo = this._adapter != null ? new GFtpProtocolInfo("GFtp", this._version, 0, AbstractFtpDoorV1.this._local_host, this._adapter.getPoolListenerPort(), this._parallel, this._parallel, this._parallel, this._bufSize, this._offset, this._size) : new GFtpProtocolInfo("GFtp", this._version, 0, this._client.getAddress().getHostAddress(), this._client.getPort(), this._parallel, this._parallel, this._parallel, this._bufSize, this._offset, this._size);
            protocolInfo.setDoorCellName(this.getCellName());
            protocolInfo.setDoorCellDomainName(AbstractFtpDoorV1.this.getCellDomainName());
            protocolInfo.setClientAddress(this._client.getAddress().getHostAddress());
            protocolInfo.setPassive(usePassivePool);
            protocolInfo.setMode(this._xferMode);
            if (AbstractFtpDoorV1.this._optCheckSumFactory != null) {
                protocolInfo.setChecksumType(AbstractFtpDoorV1.this._optCheckSumFactory.getType().getName());
            }
            if (AbstractFtpDoorV1.this._checkSumFactory != null) {
                protocolInfo.setChecksumType(AbstractFtpDoorV1.this._checkSumFactory.getType().getName());
            }
            return protocolInfo;
        }

        public void createTransactionLog() {
            if (AbstractFtpDoorV1.this._tLogRoot != null) {
                AbstractFtpDoorV1.this._logger.info("Door will log ftp transactions to {}", (Object)AbstractFtpDoorV1.this._tLogRoot);
                this._tLog = new FTPTransactionLog(AbstractFtpDoorV1.this._tLogRoot);
                AbstractFtpDoorV1.this.startTlog(this._tLog, this._path.toString(), this.isWrite() ? "write" : "read");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChecksum(Checksum checksum) throws CacheException {
            if (checksum != null) {
                this.setStatus("PnfsManager: Setting checksum");
                try {
                    this._pnfs.setChecksum(this.getPnfsId(), checksum);
                }
                finally {
                    this.setStatus(null);
                }
            }
        }

        protected synchronized void startTransfer() {
            if (this._adapter != null) {
                this._adapter.start();
            }
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId() + ": " + (this.isWrite() ? "Receiving" : "Sending"));
            AbstractFtpDoorV1.this.reply("150 Opening BINARY data connection for " + this._path, false);
            if (this.isWrite() && this._xferMode.equals("E") && AbstractFtpDoorV1.this._performanceMarkerPeriod > 0L) {
                long period = AbstractFtpDoorV1.this._performanceMarkerPeriod * 1000L;
                long timeout = period / 2L;
                this._perfMarkerTask = new PerfMarkerTask(this.getPool(), this.getMoverId(), timeout);
                _timer.schedule((TimerTask)this._perfMarkerTask, period, period);
            }
        }

        public synchronized void startMover(String queue, long timeout) throws CacheException, InterruptedException {
            super.startMover(queue, timeout);
            this.setStatus("Mover " + this.getPool() + "/" + this.getMoverId());
            if (this._version == 1) {
                this.startTransfer();
            }
        }

        public synchronized void transferStarted(CellMessage envelope, GFtpTransferStartedMessage message) {
            try {
                if (this._aborted || this._completed) {
                    return;
                }
                if (this._version != 2) {
                    AbstractFtpDoorV1.this._logger.error("Received unexpected GFtpTransferStartedMessage for {} from {}", (Object)message.getPnfsId(), (Object)envelope.getSourceAddress());
                    return;
                }
                if (!message.getPnfsId().equals(this.getPnfsId().getId())) {
                    AbstractFtpDoorV1.this._logger.error("GFtpTransferStartedMessage has wrong ID, expected {} but got {}", (Object)this.getPnfsId(), (Object)message.getPnfsId());
                    throw new FTPCommandException(451, "Transient internal failure");
                }
                if (message.getPassive() && !this._reply127) {
                    AbstractFtpDoorV1.this._logger.error("Pool {} unexpectedly volunteered to be passive", (Object)envelope.getSourceAddress());
                    throw new FTPCommandException(451, "Transient internal failure");
                }
                if (this._mode == Mode.PASSIVE && !message.getPassive() && this._xferMode.equals("X")) {
                    throw new FTPCommandException(504, "Cannot use passive X mode");
                }
                if (message.getPassive()) {
                    assert (this._reply127);
                    assert (this._adapter != null);
                    AbstractFtpDoorV1.this.reply127PORT(message.getPoolAddress());
                    AbstractFtpDoorV1.this._logger.info("Closing adapter");
                    this._adapter.close();
                    this._adapter = null;
                } else if (this._reply127) {
                    AbstractFtpDoorV1.this.reply127PORT(new InetSocketAddress(AbstractFtpDoorV1.this._engine.getLocalAddress(), this._adapter.getClientListenerPort()));
                }
                this.startTransfer();
            }
            catch (FTPCommandException e) {
                this.abort(e.getCode(), e.getReply());
            }
            catch (RuntimeException e) {
                this.abort(426, "Transient internal error", e);
            }
        }

        public void finished(CacheException error) {
            super.finished(error);
            this.transferCompleted(error);
        }

        protected synchronized void transferCompleted(CacheException error) {
            try {
                if (this._aborted) {
                    return;
                }
                if (this._completed) {
                    throw new RuntimeException("DoorTransferFinished message received more than once");
                }
                if (error != null) {
                    throw error;
                }
                if (this._adapter != null) {
                    AbstractFtpDoorV1.this._logger.info("Waiting for adapter to finish.");
                    this._adapter.join(300000L);
                    if (this._adapter.isAlive()) {
                        throw new FTPCommandException(426, "FTP proxy did not shut down");
                    }
                    if (this._adapter.hasError()) {
                        throw new FTPCommandException(426, "FTP proxy failed: " + this._adapter.getError());
                    }
                    AbstractFtpDoorV1.this._logger.debug("Closing adapter");
                    this._adapter.close();
                    this._adapter = null;
                }
                if (this._perfMarkerTask != null) {
                    this._perfMarkerTask.stop((GFtpProtocolInfo)this.getProtocolInfo());
                }
                StorageInfo storageInfo = this.getStorageInfo();
                if (this._tLog != null) {
                    this._tLog.middle(storageInfo.getFileSize());
                    this._tLog.success();
                    this._tLog = null;
                }
                this.notifyBilling(0, "");
                AbstractFtpDoorV1.this.reply("226 Transfer complete.");
                this._completed = true;
                AbstractFtpDoorV1.this.setTransfer(null);
            }
            catch (CacheException e) {
                this.abort(426, e.getMessage());
            }
            catch (FTPCommandException e) {
                this.abort(e.getCode(), e.getReply());
            }
            catch (InterruptedException e) {
                this.abort(426, "FTP proxy was interrupted", e);
            }
            catch (RuntimeException e) {
                this.abort(426, "Transient internal error", e);
            }
        }

        public void abort(int replyCode, String msg) {
            this.abort(replyCode, msg, null);
        }

        public synchronized void abort(int replyCode, String replyMsg, Exception exception) {
            if (this._aborted) {
                return;
            }
            if (this._completed) {
                AbstractFtpDoorV1.this._logger.error("Cannot abort transfer that already completed: {} {}", (Object)replyCode, (Object)replyMsg);
                return;
            }
            if (this._perfMarkerTask != null) {
                this._perfMarkerTask.stop();
            }
            if (this._adapter != null) {
                this._adapter.close();
                this._adapter = null;
            }
            this.killMover(1000L);
            if (this.isWrite()) {
                if (AbstractFtpDoorV1.this._removeFileOnIncompleteTransfer) {
                    AbstractFtpDoorV1.this._logger.warn("Removing incomplete file {}: {}", (Object)this.getPnfsId(), (Object)this._path);
                    this.deleteNameSpaceEntry();
                } else {
                    AbstractFtpDoorV1.this._logger.warn("Incomplete file was not removed: {}", (Object)this._path);
                }
            }
            String msg = String.valueOf(replyCode) + " " + replyMsg;
            this.notifyBilling(replyCode, replyMsg);
            if (this._tLog != null) {
                this._tLog.error(msg);
                this._tLog = null;
            }
            if (exception == null) {
                AbstractFtpDoorV1.this._logger.error("Transfer error: {}", (Object)msg);
            } else {
                AbstractFtpDoorV1.this._logger.error("Transfer error: {} ({})", (Object)msg, (Object)exception.getMessage());
                AbstractFtpDoorV1.this._logger.debug(exception.toString(), (Throwable)exception);
            }
            AbstractFtpDoorV1.this.reply(msg);
            this._aborted = true;
            AbstractFtpDoorV1.this.setTransfer(null);
        }
    }

    protected static enum Fact {
        SIZE("Size"),
        MODIFY("Modify"),
        TYPE("Type"),
        UNIQUE("Unique"),
        PERM("Perm"),
        OWNER("UNIX.owner"),
        GROUP("UNIX.group"),
        MODE("UNIX.mode");

        private final String _name;

        private Fact(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public static Fact find(String s) {
            for (Fact fact : Fact.values()) {
                if (!s.equalsIgnoreCase(fact.getName())) continue;
                return fact;
            }
            return null;
        }
    }

    protected static enum Mode {
        PASSIVE,
        ACTIVE;

    }
}

