/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.security;

import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.glite.authz.common.security.PEMFileReader;

public class PKIKeyManager
implements X509KeyManager {
    private X509KeyManager keyManager_ = null;

    public PKIKeyManager(String certfile, String keyfile, String password) throws IOException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        KeyStore keystore = this.createKeyStore(certfile, keyfile, password);
        this.keyManager_ = this.createX509KeyManager(keystore, password);
    }

    public PKIKeyManager(KeyStore keystore, String password) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        this.keyManager_ = this.createX509KeyManager(keystore, password);
    }

    protected KeyStore createKeyStore(String certfile, String keyfile, String password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        PEMFileReader reader = new PEMFileReader();
        PrivateKey pkey = reader.readPrivateKey(keyfile, password);
        Certificate[] certs = reader.readCertificates(certfile);
        char[] passwd = password.toCharArray();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null, passwd);
        keystore.setKeyEntry("keycreds", pkey, passwd, certs);
        return keystore;
    }

    protected X509KeyManager createX509KeyManager(KeyStore keystore, String password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password.toCharArray());
        X509KeyManager keyManager = (X509KeyManager)kmfactory.getKeyManagers()[0];
        return keyManager;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.keyManager_.chooseClientAlias(keyType, issuers, socket);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.keyManager_.chooseServerAlias(keyType, issuers, socket);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager_.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager_.getClientAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager_.getPrivateKey(alias);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager_.getServerAliases(keyType, issuers);
    }
}

