/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSServerInfo;
import org.glite.voms.contact.VOMSServerMap;

public class VOMSESFileParser {
    private static final Logger log;
    private static final String splitSyntax = "\\x22[^\\x22]\\x22";
    private static final List vomsesPaths;

    private VOMSESFileParser() {
    }

    private String fixQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String[] splitLine(String string) {
        String[] stringArray = string.split(splitSyntax);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.fixQuotes(stringArray[i]);
        }
        return stringArray;
    }

    private VOMSServerMap parseDir(File file) throws IOException {
        File[] fileArray = file.listFiles();
        VOMSServerMap vOMSServerMap = new VOMSServerMap();
        log.debug((Object)("Parsing vomses dir:" + file));
        for (int i = 0; i < fileArray.length; ++i) {
            vOMSServerMap.merge(this.parse(fileArray[i]));
        }
        return vOMSServerMap;
    }

    VOMSServerMap parse(String string) throws IOException {
        return this.parse(new File(string));
    }

    private VOMSServerMap parse(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = null;
        VOMSServerMap vOMSServerMap = new VOMSServerMap();
        if (file.isDirectory()) {
            return this.parseDir(file);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error((Object)("Error opening vomses file '" + file.getAbsolutePath() + "': " + fileNotFoundException.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            }
            throw fileNotFoundException;
        }
        log.debug((Object)("Parsing vomses file: " + file.getAbsolutePath()));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#") || string.matches("\\s*$")) continue;
            String[] stringArray = this.splitLine(string.trim());
            if (stringArray.length < 5 || stringArray.length > 6) {
                throw new VOMSException("Syntax error on vomses file!");
            }
            vOMSServerMap.add(VOMSServerInfo.fromStringArray(stringArray));
        }
        return vOMSServerMap;
    }

    public VOMSServerMap buildServerMap() throws IOException {
        Object object;
        Iterator iterator = vomsesPaths.iterator();
        if (log.isDebugEnabled()) {
            object = StringUtils.join(vomsesPaths.iterator(), (String)",");
            log.debug((Object)("Known vomses files: " + (String)object));
        }
        object = new VOMSServerMap();
        while (iterator.hasNext()) {
            ((VOMSServerMap)object).merge(this.parse((File)iterator.next()));
        }
        return object;
    }

    public static VOMSESFileParser instance() {
        return new VOMSESFileParser();
    }

    static {
        File file;
        File file2;
        Object object;
        log = Logger.getLogger(VOMSESFileParser.class);
        String string = System.getProperty("GLITE_LOCATION", null);
        String string2 = System.getProperty("VOMSES_LOCATION", null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File file3 = new File(File.separator + "etc" + File.separator + "vomses");
        if (file3.exists()) {
            arrayList.add(file3);
        }
        if (string != null && ((File)(object = new File(string + File.separator + "etc" + File.separator + "vomses"))).exists()) {
            arrayList.add(object);
        }
        if (string2 != null) {
            object = string2.split(":");
            for (int i = 0; i < ((String[])object).length; ++i) {
                file2 = new File((String)object[i] + File.separator + "vomses");
                if (!file2.exists()) continue;
                arrayList.add(file2);
            }
        }
        if (((File)(object = new File(System.getProperty("user.home") + File.separator + ".globus" + File.separator + "vomses"))).exists()) {
            arrayList.add(object);
        }
        if ((file = new File(System.getProperty("user.home") + File.separator + ".glite" + File.separator + "vomses")).exists()) {
            arrayList.add(file);
        }
        file2 = new File(System.getProperty("user.home") + File.separator + ".voms" + File.separator + "vomses");
        log.debug((Object)("Tried file: " + file2.getAbsolutePath()));
        log.debug((Object)("file exists ? " + file2.exists()));
        if (file2.exists()) {
            arrayList.add(file2);
        }
        vomsesPaths = arrayList;
    }
}

