/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ObjectDigestInfo
implements DEREncodable {
    DEREnumerated digestedObjectType;
    DERObjectIdentifier otherObjectTypeID;
    AlgorithmIdentifier digestAlgorithm;
    DERBitString objectDigest;

    public ObjectDigestInfo(ASN1Sequence aSN1Sequence) {
        this.digestedObjectType = DEREnumerated.getInstance((Object)((DERTaggedObject)aSN1Sequence.getObjectAt(0)));
        int n = 0;
        if (aSN1Sequence.size() == 4) {
            this.otherObjectTypeID = DERObjectIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(1));
            ++n;
        }
        this.digestAlgorithm = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(1 + n));
        this.objectDigest = new DERBitString(aSN1Sequence.getObjectAt(2 + n));
    }

    public DEREnumerated getDigestedObjectType() {
        return this.digestedObjectType;
    }

    public DERObjectIdentifier getOtherObjectTypeID() {
        return this.otherObjectTypeID;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DERBitString getObjectDigest() {
        return this.objectDigest;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)this.digestedObjectType);
        if (this.otherObjectTypeID != null) {
            aSN1EncodableVector.add((DEREncodable)this.otherObjectTypeID);
        }
        aSN1EncodableVector.add((DEREncodable)this.digestAlgorithm);
        aSN1EncodableVector.add((DEREncodable)this.objectDigest);
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

