/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.ObjectDigestInfo;
import org.glite.voms.ac.Util;

public class Holder
implements DEREncodable {
    IssuerSerial baseCertificateID = null;
    GeneralNames entityName = null;
    ObjectDigestInfo objectDigestInfo = null;

    public Holder(X509Certificate x509Certificate) {
        this(x509Certificate.getIssuerX500Principal(), x509Certificate.getSerialNumber());
    }

    public Holder(X500Principal x500Principal, BigInteger bigInteger) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)Util.x500nameToGeneralNames(x500Principal));
        aSN1EncodableVector.add((DEREncodable)new DERInteger(bigInteger));
        this.baseCertificateID = new IssuerSerial((ASN1Sequence)new DERSequence((DEREncodableVector)aSN1EncodableVector));
    }

    public Holder(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (!(dERObject instanceof ASN1TaggedObject)) {
                throw new IllegalArgumentException("Holder element not tagged");
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.baseCertificateID = new IssuerSerial((ASN1Sequence)aSN1TaggedObject.getObject());
                    continue block5;
                }
                case 1: {
                    this.entityName = GeneralNames.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                    continue block5;
                }
                case 2: {
                    this.objectDigestInfo = new ObjectDigestInfo((ASN1Sequence)aSN1TaggedObject.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown tag number " + aSN1TaggedObject.getTagNo());
        }
    }

    public GeneralNames getIssuer() {
        if (this.baseCertificateID != null) {
            return this.baseCertificateID.getIssuer();
        }
        if (this.entityName != null) {
            return this.entityName;
        }
        return null;
    }

    protected static boolean matchesDN(X500Principal x500Principal, GeneralNames generalNames) {
        Enumeration enumeration = ((ASN1Sequence)generalNames.getDERObject()).getObjects();
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = GeneralName.getInstance(enumeration.nextElement());
            if (generalName.getTagNo() != 4) continue;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)generalName.getName());
                X500Principal x500Principal2 = new X500Principal(byteArrayOutputStream.toByteArray());
                if (!x500Principal2.equals(x500Principal)) continue;
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public boolean isHolder(X509Certificate x509Certificate) {
        if (this.baseCertificateID != null && this.baseCertificateID.getSerial().getValue().equals(x509Certificate.getSerialNumber())) {
            if (Holder.matchesDN(x509Certificate.getIssuerX500Principal(), this.baseCertificateID.getIssuer())) {
                return true;
            }
            if (Holder.matchesDN(x509Certificate.getSubjectX500Principal(), this.baseCertificateID.getIssuer())) {
                return true;
            }
        }
        return this.entityName != null && Holder.matchesDN(x509Certificate.getSubjectX500Principal(), this.entityName);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.baseCertificateID != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.baseCertificateID));
        }
        if (this.entityName != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.entityName));
        }
        if (this.objectDigestInfo != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)this.objectDigestInfo));
        }
        return new DERSequence((DEREncodableVector)aSN1EncodableVector);
    }
}

