/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class PKIUtils {
    private static final Pattern emailPattern = Pattern.compile("/emailaddress", 2);
    private static final Pattern uidPattern = Pattern.compile("/USERID");
    private static final Pattern basename_pattern = Pattern.compile("(.*)\\.[^\\.]*");
    private static final String SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    private static final String AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    private static final String PROXYCERTINFO = "1.3.6.1.5.5.7.1.14";
    private static final String PROXYCERTINFO_OLD = "1.3.6.1.4.1.3536.1.222";
    private static final String BASIC_CONSTRAINTS_IDENTIFIER = "2.5.29.19";
    private static final CertificateFactory factory;
    private static final int CERT = 1;
    private static final int CRL = 2;
    private static final int keyCertSign = 5;
    private static final int digitalSignature = 0;
    private static final Logger logger;

    public static String getHash(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            logger.debug((Object)("Getting hash of: " + x509Certificate.getSubjectDN().getName()));
            return PKIUtils.getHash(x509Certificate.getSubjectX500Principal());
        }
        throw new IllegalArgumentException("Null certificate passed to getHash()");
    }

    public static String getHash(X509CRL x509CRL) {
        if (x509CRL != null) {
            return PKIUtils.getHash(x509CRL.getIssuerX500Principal());
        }
        throw new IllegalArgumentException("Null CRL passed to getHash()");
    }

    public static String getHash(X509Principal x509Principal) {
        if (x509Principal != null) {
            byte[] byArray = x509Principal.getEncoded();
            return PKIUtils.getHash(byArray);
        }
        throw new IllegalArgumentException("Null name passed to getHash()");
    }

    public static String getHash(X500Principal x500Principal) {
        if (x500Principal != null) {
            logger.debug((Object)("Examining: " + x500Principal.getName()));
            byte[] byArray = x500Principal.getEncoded();
            logger.debug((Object)("Hash is: " + PKIUtils.getHash(byArray)));
            return PKIUtils.getHash(byArray);
        }
        throw new IllegalArgumentException("Null name passed to getHash()");
    }

    public static String getHash(byte[] byArray) {
        if (byArray != null) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.fatal((Object)("NO MD5! " + noSuchAlgorithmException.getMessage()), (Throwable)noSuchAlgorithmException);
                throw new IllegalStateException("NO MD5! " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.rewind();
            String string = "00000000" + Integer.toHexString(byteBuffer.getInt());
            return string.substring(string.length() - 8);
        }
        throw new IllegalArgumentException("Null certificate passed to getHash()");
    }

    public static String getOpenSSLFormatPrincipal(Principal principal) {
        return PKIUtils.getOpenSSLFormatPrincipal(principal, false);
    }

    public static String getOpenSSLFormatPrincipal(Principal principal, boolean bl) {
        X509Name x509Name = new X509Name(principal.getName());
        Vector vector = x509Name.getOIDs();
        Vector vector2 = x509Name.getValues();
        ListIterator listIterator = vector.listIterator();
        ListIterator listIterator2 = vector2.listIterator();
        String string = "";
        String string2 = "";
        while (listIterator.hasNext()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)listIterator.next();
            String string3 = (String)listIterator2.next();
            string2 = dERObjectIdentifier.equals((Object)X509Name.C) ? "/C=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.CN) ? "/CN=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.DC) ? "/DC=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.E) ? "/Email=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.EmailAddress) ? "/Email=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.L) ? "/L=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.O) ? "/O=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.OU) ? "/OU=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.ST) ? "/ST=" + string3 : (dERObjectIdentifier.equals((Object)X509Name.UID) ? "/UID=" + string3 : "/" + dERObjectIdentifier.toString() + "=" + string3)))))))));
            if (bl) {
                string = string2 + string;
                continue;
            }
            string = string + string2;
        }
        logger.debug((Object)("SSLFormat: " + string));
        return string;
    }

    public static String Normalize(String string) {
        String string2 = emailPattern.matcher(string).replaceAll("/Email");
        return uidPattern.matcher(string2).replaceAll("/UID");
    }

    public static boolean DNCompare(String string, String string2) {
        return PKIUtils.Normalize(string).equals(PKIUtils.Normalize(string2));
    }

    public static String getBaseName(File file) {
        Matcher matcher = basename_pattern.matcher(file.getName());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return file.getName();
    }

    public static boolean selfIssued(X509Certificate x509Certificate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking self issued for: " + x509Certificate.getSubjectDN().getName()));
        }
        boolean bl = PKIUtils.checkIssued(x509Certificate, x509Certificate);
        logger.debug((Object)("SelfIssued Result " + bl));
        return bl;
    }

    private static BigInteger getAuthorityCertificateSerialNumber(AuthorityKeyIdentifier authorityKeyIdentifier) {
        DERObject dERObject = authorityKeyIdentifier.getDERObject();
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)dERObject);
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            DERObject dERObject2;
            DERObject dERObject3 = (DERObject)aSN1Sequence.getObjectAt(i);
            if (!(dERObject3 instanceof ASN1TaggedObject) || ((ASN1TaggedObject)dERObject3).getTagNo() != 2 || !((dERObject2 = ((ASN1TaggedObject)dERObject3).getObject()) instanceof DERInteger)) continue;
            return ((DERInteger)dERObject2).getValue();
        }
        return null;
    }

    private static GeneralNames getAuthorityCertIssuer(AuthorityKeyIdentifier authorityKeyIdentifier) {
        DERObject dERObject = authorityKeyIdentifier.getDERObject();
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)dERObject);
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            DERObject dERObject2 = (DERObject)aSN1Sequence.getObjectAt(i);
            if (!(dERObject2 instanceof ASN1TaggedObject) || ((ASN1TaggedObject)dERObject2).getTagNo() != 1) continue;
            return GeneralNames.getInstance((ASN1TaggedObject)((DERTaggedObject)dERObject2), (boolean)false);
        }
        return null;
    }

    private static GeneralName[] getNames(GeneralNames generalNames) {
        DERObject dERObject = generalNames.getDERObject();
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERObject;
        int n = aSN1Sequence.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(GeneralName.getInstance((Object)aSN1Sequence.getObjectAt(i)));
        }
        return arrayList.toArray(new GeneralName[0]);
    }

    public static boolean checkIssued(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate2.getIssuerX500Principal();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Is: " + x509Certificate2.getSubjectDN().getName() + " issued by " + x509Certificate.getSubjectDN().getName() + "?"));
            logger.debug((Object)("Is: " + x500Principal2.getName() + " issued by " + x500Principal.getName() + "?"));
            logger.debug((Object)"[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[");
        }
        if (x500Principal.equals(x500Principal2)) {
            Object object;
            logger.debug((Object)"================================");
            logger.debug((Object)"issuersSubject = issuedIssuer");
            boolean bl = false;
            AuthorityKeyIdentifier authorityKeyIdentifier = null;
            try {
                authorityKeyIdentifier = PKIUtils.getAKID(x509Certificate2);
                if (authorityKeyIdentifier != null) {
                    object = authorityKeyIdentifier.toString();
                }
                bl = false;
            }
            catch (Exception exception) {
                logger.warn((Object)("CA: " + x500Principal.getName() + " needs to skip akid checks due to incorrectly formatted Authority Key Identifier Extension"));
                bl = true;
            }
            if (!bl && authorityKeyIdentifier != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("akid = " + authorityKeyIdentifier));
                }
                logger.debug((Object)"Authority Key Identifier extension found in issued certificate.");
                logger.debug((Object)"Entered.");
                object = PKIUtils.getSKID(x509Certificate);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sid = " + object));
                }
                if (object != null) {
                    Object object2;
                    logger.debug((Object)"subject Key Identifier extension found in issuer certificate.");
                    logger.debug((Object)"comparing skid to akid");
                    byte[] byArray = object.getKeyIdentifier();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"skid");
                        object2 = new StringBuilder();
                        for (int i = 0; i < byArray.length; ++i) {
                            ((StringBuilder)object2).append(Integer.toHexString(byArray[i]));
                            ((StringBuilder)object2).append(' ');
                        }
                        logger.debug((Object)((StringBuilder)object2).toString());
                    }
                    object2 = authorityKeyIdentifier.getKeyIdentifier();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"akid");
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            stringBuilder.append(Integer.toHexString((int)object2[i]));
                            stringBuilder.append(' ');
                        }
                        logger.debug((Object)stringBuilder.toString());
                    }
                    logger.debug((Object)"skid/akid checking.");
                    if (!Arrays.equals(byArray, (byte[])object2)) {
                        return false;
                    }
                    logger.debug((Object)"skid/akid check passed.");
                }
            }
            logger.debug((Object)"]]]]]]]]]]]]]]]]]]]]]]]]");
            object = x509Certificate.getKeyUsage();
            if (!PKIUtils.isCA(x509Certificate) && (object != null && object[0] == false || !PKIUtils.isProxy(x509Certificate2))) {
                return false;
            }
            logger.debug((Object)"CHECK ISSUED PASSED");
            return true;
        }
        logger.debug((Object)"Check Issued failed.");
        return false;
    }

    public static boolean isCA(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Examining " + x509Certificate.getSubjectDN().getName()));
            logger.debug((Object)("Hash: " + PKIUtils.getHash(x509Certificate)));
        }
        boolean[] blArray = x509Certificate.getKeyUsage();
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.15");
        if (logger.isDebugEnabled()) {
            if (byArray != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Real value : ");
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(Integer.toHexString(byArray[i]));
                    stringBuilder.append(' ');
                }
                logger.debug((Object)stringBuilder.toString());
                DERObject dERObject = null;
                try {
                    dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
                    logger.debug((Object)("Class = " + dERObject.getClass()));
                    dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dERObject).getOctets())).readObject();
                    logger.debug((Object)("Class = " + dERObject.getClass()));
                    DERBitString dERBitString = (DERBitString)dERObject;
                    logger.debug((Object)("pad bits  : " + dERBitString.getPadBits()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (blArray != null) {
                for (int i = 0; i < blArray.length; ++i) {
                    logger.debug((Object)("Keyusage[" + i + "] = " + blArray[i]));
                }
            }
        }
        if (blArray != null && !blArray[5]) {
            logger.error((Object)"keyUsage extension present, but CertSign bit not active.");
            return false;
        }
        int n = x509Certificate.getBasicConstraints();
        if (n == -1) {
            logger.debug((Object)"Is CA");
            return false;
        }
        logger.debug((Object)"Is not CA");
        return true;
    }

    public static boolean isProxy(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Check for proxyness: " + x509Certificate.getSubjectDN().getName()));
        }
        byte[] byArray = x509Certificate.getExtensionValue(PROXYCERTINFO);
        byte[] byArray2 = x509Certificate.getExtensionValue(PROXYCERTINFO_OLD);
        if (byArray != null || byArray2 != null) {
            logger.debug((Object)"Proxyness confirmed.");
            return true;
        }
        String string = x509Certificate.getSubjectX500Principal().getName();
        String string2 = x509Certificate.getIssuerX500Principal().getName();
        logger.debug((Object)"ENDNAME CHECK?");
        if (string.endsWith(string2)) {
            logger.debug((Object)"ENDNAME CHECK OK");
            String string3 = string.replaceFirst(string2, "");
            logger.debug((Object)("TO CHECK: " + string3));
            if (string3.equals("CN=proxy,") || string3.equals("CN=limited proxy,")) {
                logger.debug((Object)"Proxyness confirmed.");
                return true;
            }
        }
        return false;
    }

    public static AuthorityKeyIdentifier getAKID(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            byte[] byArray = x509Certificate.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            boolean bl = false;
            if (byArray != null) {
                DEROctetString dEROctetString = new DEROctetString(byArray);
                byte[] byArray2 = dEROctetString.getOctets();
                DERObject dERObject = null;
                try {
                    dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray2)).readObject();
                    dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dERObject).getOctets())).readObject();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Erroneous encoding in Authority Key Identifier " + classCastException.getMessage(), classCastException);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("While extracting Authority Key Identifier " + exception.getMessage(), exception);
                }
                return new AuthorityKeyIdentifier(ASN1Sequence.getInstance((Object)dERObject));
            }
        }
        return null;
    }

    public static SubjectKeyIdentifier getSKID(X509Certificate x509Certificate) {
        byte[] byArray;
        if (x509Certificate != null && (byArray = x509Certificate.getExtensionValue(SUBJECT_KEY_IDENTIFIER)) != null) {
            DERObject dERObject = null;
            try {
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dERObject).getOctets())).readObject();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("While extracting Subject Key Identifier " + exception.getMessage(), exception);
            }
            return SubjectKeyIdentifier.getInstance((Object)dERObject);
        }
        return null;
    }

    public static BasicConstraints getBasicConstraints(X509Certificate x509Certificate) {
        byte[] byArray;
        if (x509Certificate != null && (byArray = x509Certificate.getExtensionValue(BASIC_CONSTRAINTS_IDENTIFIER)) != null) {
            DERObject dERObject = null;
            try {
                dERObject = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("While extracting Subject Key Identifier " + exception.getMessage());
            }
            return new BasicConstraints(ASN1Sequence.getInstance((Object)dERObject));
        }
        return null;
    }

    public static PrivateKey loadPrivateKey(String string, PasswordFinder passwordFinder) {
        return PKIUtils.loadPrivateKey(new File(string), passwordFinder);
    }

    public static PrivateKey loadPrivateKey(File file, PasswordFinder passwordFinder) {
        PEMReader pEMReader = null;
        try {
            pEMReader = new PEMReader((Reader)new FileReader(file), passwordFinder);
            logger.debug((Object)("pem = " + pEMReader));
            Object object = null;
            do {
                object = pEMReader.readObject();
                logger.debug((Object)("File is: " + file.getAbsolutePath()));
                logger.debug((Object)("Object read is: " + object));
                logger.debug((Object)("Object class is: " + object.getClass().getCanonicalName()));
            } while (!(object instanceof KeyPair) && !(object instanceof JCERSAPrivateKey) && object != null);
            if (object != null) {
                if (object instanceof KeyPair) {
                    KeyPair keyPair = (KeyPair)object;
                    logger.debug((Object)("key = " + keyPair));
                    return keyPair.getPrivate();
                }
                if (object instanceof JCERSAPrivateKey) {
                    logger.debug((Object)("key = " + object));
                    return (PrivateKey)object;
                }
                if (object instanceof PrivateKey) {
                    return (PrivateKey)object;
                }
                return null;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Not a PEM format file " + file.getName(), iOException);
        }
    }

    public static X509Certificate[] loadCertificates(String string) throws CertificateException {
        return PKIUtils.loadCertificates(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] loadCertificates(File file) throws CertificateException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Cannot find file " + file.getName());
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = PKIUtils.loadCertificates(bufferedInputStream);
        }
        catch (IOException iOException) {
            x509CertificateArray = null;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                logger.error((Object)("While closing: " + file.getName() + " " + iOException.getMessage()));
            }
        }
        return x509CertificateArray;
    }

    private static X509Certificate[] loadCertificates(BufferedInputStream bufferedInputStream) throws CertificateException, IOException {
        int n;
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        while ((n = PKIUtils.skipToCertBeginning(bufferedInputStream)) != -1) {
            if (n != 1) continue;
            arrayList.add(factory.generateCertificate(bufferedInputStream));
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[]{};
        return arrayList.toArray(x509CertificateArray);
    }

    public static X509CRL loadCRL(String string) throws CRLException {
        return PKIUtils.loadCRL(new File(string));
    }

    public static X509CRL loadCRL(File file) throws CRLException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Cannot find file " + file.getName());
        }
        X509CRL x509CRL = null;
        try {
            x509CRL = PKIUtils.loadCRL(bufferedInputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot load CRL from file: " + file.getName() + " cause: " + iOException.getMessage());
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)("While closing: " + file.getName() + " " + iOException.getMessage()));
            }
        }
        return x509CRL;
    }

    private static X509CRL loadCRL(BufferedInputStream bufferedInputStream) throws CRLException, IOException {
        X509CRL x509CRL = null;
        if (PKIUtils.skipToCertBeginning(bufferedInputStream) == 2) {
            x509CRL = (X509CRL)factory.generateCRL(bufferedInputStream);
        }
        return x509CRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(File file) throws IOException, CertificateException, CRLException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        int n = PKIUtils.skipToCertBeginning(bufferedInputStream);
        try {
            switch (n) {
                case 2: {
                    X509CRL x509CRL = PKIUtils.loadCRL(bufferedInputStream);
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                    X509CRL x509CRL2 = x509CRL;
                    return x509CRL2;
                }
                case 1: {
                    Vector<X509Certificate> vector = new Vector<X509Certificate>(Arrays.asList(PKIUtils.loadCertificates(bufferedInputStream)));
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                    Vector<X509Certificate> vector2 = vector;
                    return vector2;
                }
            }
            return null;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public static int skipToCertBeginning(BufferedInputStream bufferedInputStream) throws IOException {
        int n = 1000;
        byte[] byArray = new byte[n];
        bufferedInputStream.mark(n + 2);
        while (bufferedInputStream.available() > 0) {
            int n2 = bufferedInputStream.read(byArray);
            String string = new String(byArray, 0, n2);
            int n3 = string.indexOf("----BEGIN CERTIFICATE");
            int n4 = string.indexOf("----BEGIN X509 CRL");
            if (n3 == -1 && n4 == -1) {
                bufferedInputStream.reset();
                bufferedInputStream.skip(n - 100);
                bufferedInputStream.mark(n + 2);
                continue;
            }
            if (n3 != -1) {
                while (string.charAt(n3 - 1) == '-' && n3 > 0 && --n3 != 0) {
                }
                bufferedInputStream.reset();
                bufferedInputStream.skip(n3);
                bufferedInputStream.mark(10000);
                return 1;
            }
            while (string.charAt(n4 - 1) == '-' && n4 > 0 && --n4 != 0) {
            }
            bufferedInputStream.reset();
            bufferedInputStream.skip(n4);
            bufferedInputStream.mark(10000);
            return 2;
        }
        return -1;
    }

    static {
        logger = Logger.getLogger(PKIUtils.class);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            factory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new ExceptionInInitializerError("Cannot find BouncyCastle provider: " + noSuchProviderException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new ExceptionInInitializerError("X.509 Certificates unsupported. " + certificateException.getMessage());
        }
    }
}

