/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml.converters;

import hep.aida.ref.xml.binary.AidaWBXMLConverter;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import hep.aida.ref.xml.converters.ToZipHandler;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.AttributesImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class AsciiToZipHandler
extends ToZipHandler
implements ContentHandler,
EntityResolver {
    void convert(String in, String out, boolean binary) throws IOException, ParserConfigurationException, SAXException {
        super.convert(out, binary);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(this);
        parser.setEntityResolver(this);
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        });
        parser.parse(in);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.dtdName = "aida";
        this.dtdSystemId = systemId;
        return null;
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        int tag = AidaWBXMLLookup.getTag(name);
        if (tag < 0) {
            throw new SAXException("Closing Unknown tag '" + name + "'");
        }
        if (AidaWBXMLLookup.isTagEmpty(tag)) {
            return;
        }
        this.endElement(tag);
    }

    public void startElement(String uri, String localName, String tagName, org.xml.sax.Attributes attr) throws SAXException {
        int tag = AidaWBXMLLookup.getTag(tagName);
        if (tag < 0) {
            throw new SAXException("Unknown tag '" + tagName + "'");
        }
        String attName = null;
        String value = null;
        try {
            AttributesImpl atts = new AttributesImpl();
            block17: for (int i = 0; i < attr.getLength(); ++i) {
                attName = attr.getQName(i);
                value = attr.getValue(i);
                int attID = AidaWBXMLLookup.getAttribute(attName);
                if (attID == -1) {
                    throw new SAXException("Unknown attribute '" + attName + "' in tag '" + tagName + "'");
                }
                int type = -1;
                if (attID == -2) {
                    try {
                        Double.parseDouble(value);
                        type = 3;
                    }
                    catch (NumberFormatException e1) {
                        try {
                            Integer.parseInt(value);
                            type = 5;
                        }
                        catch (NumberFormatException e2) {
                            type = 8;
                        }
                    }
                } else {
                    type = AidaWBXMLLookup.getAttributeType(attID);
                }
                if (type == -1) {
                    throw new SAXException("Unknown type for attribute '" + attName + "' in tag '" + tagName + "'");
                }
                switch (type) {
                    case 0: {
                        if (attID == -2) {
                            attID = 4;
                        }
                        atts.set(attID, AidaWBXMLConverter.toBoolean(tag, attID, value));
                        continue block17;
                    }
                    case 1: {
                        if (attID == -2) {
                            attID = 5;
                        }
                        atts.set(attID, Byte.parseByte(value));
                        continue block17;
                    }
                    case 2: {
                        if (attID == -2) {
                            attID = 6;
                        }
                        atts.set(attID, value.charAt(0));
                        continue block17;
                    }
                    case 3: {
                        if (attID == -2) {
                            attID = 7;
                        }
                        atts.set(attID, AidaWBXMLConverter.toDouble(tag, attID, value));
                        continue block17;
                    }
                    case 4: {
                        if (attID == -2) {
                            attID = 8;
                        }
                        atts.set(attID, AidaWBXMLConverter.toFloat(tag, attID, value));
                        continue block17;
                    }
                    case 5: {
                        if (attID == -2) {
                            attID = 9;
                        }
                        atts.set(attID, AidaWBXMLConverter.toInt(tag, attID, value));
                        continue block17;
                    }
                    case 6: {
                        if (attID == -2) {
                            attID = 10;
                        }
                        atts.set(attID, Long.parseLong(value));
                        continue block17;
                    }
                    case 7: {
                        if (attID == -2) {
                            attID = 11;
                        }
                        atts.set(attID, Short.parseShort(value));
                        continue block17;
                    }
                    case 8: {
                        if (attID == -2) {
                            attID = 12;
                        }
                        atts.set(attID, value);
                        continue block17;
                    }
                    default: {
                        throw new SAXException("Type '" + type + "' not handled for attribute '" + attName + "' in tag '" + tagName + "'");
                    }
                }
            }
            boolean empty = AidaWBXMLLookup.isTagEmpty(tag);
            this.startElement(tag, (Attributes)atts, empty);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Exception for tag '" + tagName + "', attribute '" + attName + "' value '" + value + "'", e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

