/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.ContentTypeUtils;
import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Initable;
import com.bradmcevoy.http.MiltonUtils;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.StaticResource;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticResourceFactory
implements ResourceFactory,
Initable {
    private static final Logger log = LoggerFactory.getLogger(StaticResourceFactory.class);
    private ApplicationConfig config;
    private File root;
    private String contextPath;

    public StaticResourceFactory() {
    }

    public StaticResourceFactory(ApplicationConfig config) {
        this.config = config;
    }

    public StaticResourceFactory(String context, File root) {
        this.root = root;
        this.contextPath = context;
        log.debug("root: " + root.getAbsolutePath() + " - context:" + context);
    }

    @Override
    public void init(ApplicationConfig config, HttpManager manager) {
        this.config = config;
    }

    public Resource getResource(String host, String url) {
        File file;
        if (this.root != null) {
            log.debug("url: " + url);
            String s = this.stripContext(url);
            log.debug("url: " + s);
            file = new File(this.root, s);
        } else {
            if (this.config == null) {
                throw new RuntimeException("ResourceFactory was not configured. ApplicationConfig is null");
            }
            if (this.config.servletContext == null) {
                throw new NullPointerException("config.servletContext is null");
            }
            String path = "WEB-INF/static" + url;
            path = this.config.servletContext.getRealPath(path);
            file = new File(path);
        }
        if (file.exists() && !file.isDirectory()) {
            String contentType = this.config != null ? MiltonUtils.getContentType(this.config.servletContext, file.getName()) : ContentTypeUtils.findContentTypes((File)file);
            return new StaticResource(file, url, contentType);
        }
        return null;
    }

    private String stripContext(String url) {
        if (this.contextPath != null && this.contextPath.length() > 0) {
            url = url.replaceFirst('/' + this.contextPath, "");
            log.debug("stripped context: " + url);
            return url;
        }
        return url;
    }

    @Override
    public void destroy(HttpManager manager) {
    }

    public String getSupportedLevels() {
        return "1,2";
    }
}

