/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.AuthenticationHandler;
import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.ResourceFactoryFactory;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.ServletHttpManager;
import com.bradmcevoy.http.ServletRequest;
import com.bradmcevoy.http.ServletResponse;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonServlet
implements Servlet {
    private Logger log = LoggerFactory.getLogger(MiltonServlet.class);
    private static final ThreadLocal<HttpServletRequest> originalRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> originalResponse = new ThreadLocal();
    private static final ThreadLocal<ServletConfig> tlServletConfig = new ThreadLocal();
    private ServletConfig config;
    protected ServletHttpManager httpManager;

    public static HttpServletRequest request() {
        return originalRequest.get();
    }

    public static HttpServletResponse response() {
        return originalResponse.get();
    }

    public static ServletConfig servletConfig() {
        return tlServletConfig.get();
    }

    public static void forward(String url) {
        try {
            MiltonServlet.request().getRequestDispatcher(url).forward((javax.servlet.ServletRequest)originalRequest.get(), (javax.servlet.ServletResponse)originalResponse.get());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.config = config;
            List<String> authHandlers = this.loadAuthHandlersIfAny(config.getInitParameter("authentication.handler.classes"));
            String resourceFactoryFactoryClassName = config.getInitParameter("resource.factory.factory.class");
            if (resourceFactoryFactoryClassName != null && resourceFactoryFactoryClassName.length() > 0) {
                this.initFromFactoryFactory(resourceFactoryFactoryClassName, authHandlers);
            } else {
                String resourceFactoryClassName = config.getInitParameter("resource.factory.class");
                String responseHandlerClassName = config.getInitParameter("response.handler.class");
                this.init(resourceFactoryClassName, responseHandlerClassName, authHandlers);
            }
            this.httpManager.init(new ApplicationConfig(config), this.httpManager);
        }
        catch (ServletException ex) {
            this.log.error("Exception starting milton servlet", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    protected void init(String resourceFactoryClassName, String responseHandlerClassName, List<String> authHandlers) throws ServletException {
        this.log.debug("resourceFactoryClassName: " + resourceFactoryClassName);
        ResourceFactory rf = (ResourceFactory)this.instantiate(resourceFactoryClassName);
        WebDavResponseHandler responseHandler = responseHandlerClassName == null ? null : (WebDavResponseHandler)this.instantiate(responseHandlerClassName);
        this.init(rf, responseHandler, authHandlers);
    }

    protected void initFromFactoryFactory(String resourceFactoryFactoryClassName, List<String> authHandlers) throws ServletException {
        this.log.debug("resourceFactoryFactoryClassName: " + resourceFactoryFactoryClassName);
        ResourceFactoryFactory rff = (ResourceFactoryFactory)this.instantiate(resourceFactoryFactoryClassName);
        rff.init();
        ResourceFactory rf = rff.createResourceFactory();
        WebDavResponseHandler responseHandler = rff.createResponseHandler();
        this.init(rf, responseHandler, authHandlers);
    }

    protected void init(ResourceFactory rf, WebDavResponseHandler responseHandler, List<String> authHandlers) throws ServletException {
        AuthenticationService authService;
        if (authHandlers == null) {
            authService = new AuthenticationService();
        } else {
            ArrayList<AuthenticationHandler> list = new ArrayList<AuthenticationHandler>();
            for (String authHandlerClassName : authHandlers) {
                Object o = this.instantiate(authHandlerClassName);
                if (o instanceof AuthenticationHandler) {
                    AuthenticationHandler auth = (AuthenticationHandler)o;
                    list.add(auth);
                    continue;
                }
                throw new ServletException("Class: " + authHandlerClassName + " is not a: " + AuthenticationHandler.class.getCanonicalName());
            }
            authService = new AuthenticationService(list);
        }
        this.log.debug("Configured authentication handlers: " + authService.getAuthenticationHandlers().size());
        if (authService.getAuthenticationHandlers().size() > 0) {
            for (AuthenticationHandler hnd : authService.getAuthenticationHandlers()) {
                this.log.debug(" - " + hnd.getClass().getCanonicalName());
            }
        } else {
            this.log.warn("No authentication handlers are configured! Any requests requiring authorisation will fail.");
        }
        this.httpManager = responseHandler == null ? new ServletHttpManager(rf, authService) : new ServletHttpManager(rf, responseHandler, authService);
    }

    protected <T> T instantiate(String className) throws ServletException {
        try {
            Class<?> c = Class.forName(className);
            Object rf = c.newInstance();
            return (T)rf;
        }
        catch (Throwable ex) {
            throw new ServletException("Failed to instantiate: " + className, ex);
        }
    }

    public void destroy() {
        this.log.debug("destroy");
        if (this.httpManager == null) {
            return;
        }
        this.httpManager.destroy(this.httpManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            MiltonServlet.setThreadlocals(req, resp);
            tlServletConfig.set(this.config);
            ServletRequest request = new ServletRequest(req);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process((Request)request, (Response)response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            tlServletConfig.remove();
            servletResponse.getOutputStream().flush();
            servletResponse.flushBuffer();
        }
    }

    public static void clearThreadlocals() {
        originalRequest.remove();
        originalResponse.remove();
    }

    public static void setThreadlocals(HttpServletRequest req, HttpServletResponse resp) {
        originalRequest.set(req);
        originalResponse.set(resp);
    }

    public String getServletInfo() {
        return "MiltonServlet";
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    private List<String> loadAuthHandlersIfAny(String initParameter) {
        if (initParameter == null) {
            return null;
        }
        String[] arr = initParameter.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : arr) {
            if ((s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list;
    }
}

