/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import org.parboiled.MatcherContext;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharIgnoreCaseMatcher
extends AbstractMatcher {
    public final char charLow;
    public final char charUp;

    public CharIgnoreCaseMatcher(char character) {
        super('\'' + StringUtils.escape(Character.toLowerCase(character)) + '/' + StringUtils.escape(Character.toUpperCase(character)) + '\'');
        this.charLow = Character.toLowerCase(character);
        this.charUp = Character.toUpperCase(character);
    }

    public boolean match(MatcherContext context) {
        char c = context.getCurrentChar();
        if (c != this.charLow && c != this.charUp) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkArgNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

