/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.util.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dcache.acl.util.net.Inet4AddressMatcher;
import org.dcache.acl.util.net.Inet6AddressMatcher;

public class InetAddressMatcher {
    public static boolean matches(String netmask, InetAddress inetAddress) throws UnknownHostException {
        if (netmask == null || netmask.length() == 0) {
            throw new IllegalArgumentException("netmask is " + (netmask == null ? "NULL" : "Empty"));
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("inetAddress is NULL.");
        }
        if (inetAddress instanceof Inet4Address) {
            return Inet4AddressMatcher.matches(netmask, (Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return Inet6AddressMatcher.matches(netmask, (Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("Unsupported type of inetAddress: " + inetAddress);
    }

    public static boolean matches(String netmask, String host) throws UnknownHostException {
        return InetAddressMatcher.matches(netmask, InetAddress.getByName(host));
    }
}

