/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.util.net;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet4AddressMatcher {
    private static final char ADDRESS_SEPARATOR = '/';
    private static final char MASK_SEPARATOR = '.';
    private int _address;
    private int _netmask;

    public Inet4AddressMatcher(String netmask, InetAddress address) throws UnknownHostException {
        this._netmask = new BigInteger(netmask, 16).intValue();
        this._address = Inet4AddressMatcher.address2int(address);
    }

    public Inet4AddressMatcher(String hostname) throws UnknownHostException {
        int pos = hostname.indexOf(47);
        if (pos == -1) {
            this._address = Inet4AddressMatcher.address2int(hostname);
            this._netmask = -1;
        } else {
            this._address = Inet4AddressMatcher.address2int(hostname.substring(0, pos));
            String maskPart = hostname.substring(pos + 1);
            if (maskPart.indexOf(46) == -1) {
                this._netmask = -1 << 32 - Integer.parseInt(maskPart);
                if (Integer.parseInt(maskPart) == 0) {
                    this._netmask = 0;
                }
            } else {
                this._netmask = Inet4AddressMatcher.address2int(maskPart);
            }
        }
    }

    public static int address2int(InetAddress address) {
        return new BigInteger(address.getAddress()).intValue();
    }

    public static int address2int(String address) throws UnknownHostException {
        return new BigInteger(InetAddress.getByName(address).getAddress()).intValue();
    }

    public boolean matches(InetAddress address) {
        int matchAddress = Inet4AddressMatcher.address2int(address);
        return matchAddress == (this._address & this._netmask);
    }

    public static boolean matches(String netmask, InetAddress inetAddress) throws UnknownHostException {
        Inet4AddressMatcher addressmatcher = new Inet4AddressMatcher(netmask, inetAddress);
        return addressmatcher.matches(inetAddress);
    }

    public static boolean matches(String netmask, String address) throws UnknownHostException {
        return Inet4AddressMatcher.matches(netmask, Inet4Address.getByName(address));
    }
}

