/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTools {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + FileTools.class.getName()));
    public static int FILTER_FILES = 1;
    public static int FILTER_FOLDERS = 2;
    public static int FILTER_ALL = 3;
    private static FileTools _SINGLETON = new FileTools();

    private FileTools() {
    }

    public static FileTools getInstance() {
        return _SINGLETON;
    }

    public static void getFileSubList(File f, List<String> list, int nMode, boolean bSubFolders, boolean bFirst, FilenameFilter filter) {
        try {
            boolean bFolders;
            boolean bFiles = nMode % 2 == 1;
            boolean bl = bFolders = nMode / 2 == 1;
            if (f.isDirectory()) {
                if (!bFirst && bFolders) {
                    list.add(f.getPath());
                }
                if (bFirst || bSubFolders) {
                    String[] entries = filter == null || bFiles ? f.list() : f.list(filter);
                    int maxlen = entries == null ? 0 : entries.length;
                    for (int i = 0; i < maxlen; ++i) {
                        FileTools.getFileSubList(new File(f, entries[i]), list, nMode, bSubFolders, false, filter);
                    }
                }
            } else if (f.isFile() && bFiles) {
                list.add(f.getPath());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static boolean checkFile(File aFile, boolean dir, boolean exist, boolean write) throws NullPointerException, FileNotFoundException, IOException {
        String name;
        String string = name = dir ? "Directory" : "File";
        if (aFile == null) {
            throw new NullPointerException(name + " should not be null.");
        }
        boolean fileExists = aFile.exists();
        if (exist && !fileExists) {
            throw new FileNotFoundException(name + " does not exist: " + aFile);
        }
        if (fileExists) {
            boolean fileIsDirectory = aFile.isDirectory();
            if (!dir && fileIsDirectory) {
                throw new IOException("Should not be a directory: " + aFile);
            }
            if (dir && !fileIsDirectory) {
                throw new IOException("Should not be a file: " + aFile);
            }
            if (!aFile.canRead()) {
                throw new IOException(name + " cannot be read: " + aFile);
            }
            if (write && !aFile.canWrite()) {
                throw new IOException(name + " cannot be written: " + aFile);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new FileReader(aFile));
            while ((line = input.readLine()) != null) {
                contents.append(line).append("\n");
            }
            String string = contents.toString();
            return string;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws IOException {
        logger.debug("Store contents to file " + aFile);
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static void checkReadFile(File aFile) throws NullPointerException, FileNotFoundException, IOException {
        if (aFile == null) {
            throw new NullPointerException("File should not be NULL.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + aFile);
        }
        if (aFile.isDirectory()) {
            throw new IOException("Should not be a directory: " + aFile);
        }
        if (!aFile.canRead()) {
            throw new IOException("File cannot be read: " + aFile);
        }
    }
}

