/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.unix;

public enum AMUnix {
    READ(4, 'r'),
    WRITE(2, 'w'),
    EXECUTE(1, 'x');

    private final int _value;
    private final char _abbreviation;

    private AMUnix(int value, char abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
    }

    public int getValue() {
        return this._value;
    }

    public char getAbbreviation() {
        return this._abbreviation;
    }

    public boolean matches(int accessMask) {
        return (this._value & accessMask) == this._value;
    }

    public static String toUnixString(int accessMask) {
        if (accessMask == 0) {
            return "---";
        }
        StringBuilder sb = new StringBuilder();
        for (AMUnix accessMsk : AMUnix.values()) {
            if (!accessMsk.matches(accessMask)) continue;
            sb.append(accessMsk.getAbbreviation());
        }
        return sb.toString();
    }

    public static String toString(int accessMask) {
        StringBuilder sb = new StringBuilder();
        if (accessMask != 0) {
            for (AMUnix accessMsk : AMUnix.values()) {
                if (accessMsk.matches(accessMask)) {
                    sb.append(accessMsk.getAbbreviation());
                    continue;
                }
                sb.append("-");
            }
        } else {
            sb.append("---");
        }
        return sb.toString();
    }
}

