/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.unix;

import org.dcache.acl.unix.ACEUnix;
import org.dcache.acl.unix.AMUnix;
import org.dcache.acl.unix.AceTag;

public class ACLUnix {
    public static final int NUM_ACES = 3;
    public static final int OWNER_INDEX = 0;
    public static final int GROUP_OWNER_INDEX = 1;
    public static final int OTHER_INDEX = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String SEPARATOR = ":";
    private String _rsId;
    private boolean _isDir;
    ACEUnix accessAceOwner = new ACEUnix(AceTag.USER_OBJ.getValue(), 1);
    ACEUnix accessAceOwnerGroup = new ACEUnix(AceTag.GROUP_OBJ.getValue());
    ACEUnix accessAceOther = new ACEUnix(AceTag.OTHER_OBJ.getValue());
    ACEUnix defaultAceOwner;
    ACEUnix defaultAceOwnerGroup;
    ACEUnix defaultAceOther;

    public ACLUnix(String rsId, boolean isDir) {
        this._rsId = rsId;
        this._isDir = isDir;
        if (this._isDir) {
            this.defaultAceOwner = new ACEUnix(AceTag.DEFAULT.getValue() | AceTag.USER_OBJ.getValue());
            this.defaultAceOwnerGroup = new ACEUnix(AceTag.DEFAULT.getValue() | AceTag.GROUP_OBJ.getValue());
            this.defaultAceOther = new ACEUnix(AceTag.DEFAULT.getValue() | AceTag.OTHER_OBJ.getValue());
        }
    }

    public ACLUnix(String rsId, boolean isDir, int[] accessMasks, int[] defaultMasks) {
        this(rsId, isDir);
        this.accessAceOwner.setAccessMsk(accessMasks[0]);
        this.accessAceOwnerGroup.setAccessMsk(accessMasks[1]);
        this.accessAceOther.setAccessMsk(accessMasks[2]);
        if (this._isDir) {
            this.defaultAceOwner.setAccessMsk(defaultMasks[0]);
            this.defaultAceOwnerGroup.setAccessMsk(defaultMasks[1]);
            this.defaultAceOther.setAccessMsk(defaultMasks[2]);
        }
    }

    public String getRsId() {
        return this._rsId;
    }

    public boolean isDir() {
        return this._isDir;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Unix ACL:");
        sb.append(LINE_SEPARATOR);
        sb.append("rsId = ").append(this._rsId).append(", isDir = ").append(this._isDir);
        sb.append(LINE_SEPARATOR);
        sb.append(this.accessAceOwner.toString());
        sb.append(", ").append(this.accessAceOwnerGroup.toString());
        sb.append(", ").append(this.accessAceOther.toString());
        sb.append(LINE_SEPARATOR);
        if (this._isDir) {
            sb.append(this.defaultAceOwner.toString());
            sb.append(", ").append(this.defaultAceOwnerGroup.toString());
            sb.append(", ").append(this.defaultAceOther.toString());
        }
        return sb.toString();
    }

    public String toFullString() {
        return this.toString(true);
    }

    public String toUnixString() {
        return this.toString(false);
    }

    private String toString(boolean detailed) {
        StringBuilder sb = new StringBuilder();
        if (detailed) {
            sb.append(this._rsId).append(SEPARATOR);
        }
        int dir_abbreviation = 100;
        if (this._isDir) {
            sb.append('d');
        } else {
            sb.append("-");
        }
        sb.append(AMUnix.toString(this.accessAceOwner.getAccessMsk()));
        sb.append(AMUnix.toString(this.accessAceOwnerGroup.getAccessMsk()));
        sb.append(AMUnix.toString(this.accessAceOther.getAccessMsk()));
        if (detailed && this._isDir && (this.defaultAceOwner.getAccessMsk() != 0 || this.defaultAceOwnerGroup.getAccessMsk() != 0 || this.defaultAceOther.getAccessMsk() != 0)) {
            sb.append(SEPARATOR).append('d');
            sb.append(AMUnix.toString(this.defaultAceOwner.getAccessMsk()));
            sb.append(AMUnix.toString(this.defaultAceOwnerGroup.getAccessMsk()));
            sb.append(AMUnix.toString(this.defaultAceOther.getAccessMsk()));
        }
        return sb.toString();
    }
}

