/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.matcher;

import org.dcache.acl.Permission;
import org.dcache.acl.enums.AccessAttribute;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.Action;
import org.dcache.acl.enums.FileAttribute;
import org.dcache.acl.enums.OpenType;
import org.dcache.acl.matcher.AclMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclNFSv4Matcher
extends AclMatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + AclNFSv4Matcher.class.getName()));
    private static AclNFSv4Matcher _SINGLETON = new AclNFSv4Matcher();

    private AclNFSv4Matcher() {
    }

    public static AclNFSv4Matcher instance() {
        return _SINGLETON;
    }

    public static void refresh() {
        _SINGLETON = new AclNFSv4Matcher();
    }

    public static Boolean isAllowed(Permission perm1, Permission perm2, Action action, Boolean isDir) {
        Boolean allowed;
        switch (action) {
            case RENAME: {
                Boolean allowed_destination;
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, action: " + (Object)((Object)action));
                }
                allowed = AclNFSv4Matcher.isAllowed(perm1.getDefMsk(), perm1.getAllowMsk(), AccessMask.DELETE_CHILD.getValue());
                if (allowed != null && !allowed.equals(Boolean.TRUE) || (allowed_destination = AclNFSv4Matcher.isAllowed(perm2.getDefMsk(), perm2.getAllowMsk(), isDir != false ? AccessMask.ADD_SUBDIRECTORY.getValue() : AccessMask.ADD_FILE.getValue())) != null && !allowed_destination.equals(Boolean.FALSE)) break;
                allowed = allowed_destination;
                break;
            }
            case REMOVE: {
                allowed = AclNFSv4Matcher.isAllowed(perm1.getDefMsk(), perm1.getAllowMsk(), AccessMask.DELETE_CHILD.getValue());
                Boolean allowed2 = AclNFSv4Matcher.isAllowed(perm2.getDefMsk(), perm2.getAllowMsk(), AccessMask.DELETE.getValue());
                if (Boolean.TRUE.equals(allowed) || Boolean.TRUE.equals(allowed2)) {
                    allowed = Boolean.TRUE;
                    break;
                }
                if (Boolean.FALSE.equals(allowed) || Boolean.FALSE.equals(allowed2)) {
                    allowed = Boolean.FALSE;
                    break;
                }
                allowed = AclNFSv4Matcher.isAllowed(perm1.getDefMsk(), perm1.getAllowMsk(), AccessMask.ADD_FILE.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal usage, action: " + (Object)((Object)action));
            }
        }
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(action, null, isDir, allowed);
        }
        return allowed;
    }

    public static Boolean isAllowed(Permission perm, Action action, OpenType opentype) {
        Boolean allowed;
        Boolean isDir;
        if (action != Action.OPEN) {
            throw new IllegalArgumentException("Illegal usage, action: " + (Object)((Object)action));
        }
        if (opentype == null) {
            throw new IllegalArgumentException("opentype is NULL, action: " + (Object)((Object)Action.OPEN));
        }
        int accessMask = 0;
        int defMask = perm.getDefMsk();
        int allowMask = perm.getAllowMsk();
        switch (opentype) {
            case OPEN4_CREATE: {
                isDir = Boolean.TRUE;
                accessMask = AccessMask.ADD_FILE.getValue();
                break;
            }
            case OPEN4_NOCREATE: {
                isDir = Boolean.FALSE;
                allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, AccessMask.READ_DATA.getValue());
                if (allowed != null) {
                    if (logger.isDebugEnabled()) {
                        AclNFSv4Matcher.logResult(action, opentype.toString(), isDir, allowed);
                    }
                    return allowed;
                }
                accessMask = AccessMask.EXECUTE.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal open type: " + (Object)((Object)opentype));
            }
        }
        allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, accessMask);
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(action, opentype.toString(), isDir, allowed);
        }
        return allowed;
    }

    public static Boolean isAllowed(Permission perm, Action action) {
        Boolean allowed;
        int accessMask;
        int defMask = perm.getDefMsk();
        int allowMask = perm.getAllowMsk();
        switch (action) {
            case LINK: {
                accessMask = AccessMask.ADD_FILE.getValue();
                break;
            }
            case LOOKUP: 
            case LOOKUPP: {
                accessMask = AccessMask.EXECUTE.getValue();
                break;
            }
            case READ: {
                allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, AccessMask.READ_DATA.getValue());
                if (allowed != null) {
                    if (logger.isDebugEnabled()) {
                        AclNFSv4Matcher.logResult(action, null, null, allowed);
                    }
                    return allowed;
                }
                accessMask = AccessMask.EXECUTE.getValue();
                break;
            }
            case READDIR: {
                accessMask = AccessMask.LIST_DIRECTORY.getValue();
                break;
            }
            case READLINK: {
                accessMask = AccessMask.EXECUTE.getValue();
                break;
            }
            case WRITE: {
                accessMask = AccessMask.WRITE_DATA.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal usage, action: " + (Object)((Object)action));
            }
        }
        allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, accessMask);
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(action, null, null, allowed);
        }
        return allowed;
    }

    public static Boolean isAllowed(Permission perm, Action action, Boolean isDir) throws IllegalArgumentException {
        int accessMask;
        int defMask = perm.getDefMsk();
        int allowMask = perm.getAllowMsk();
        switch (action) {
            case CREATE: {
                accessMask = isDir != false ? AccessMask.ADD_SUBDIRECTORY.getValue() : AccessMask.ADD_FILE.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal usage, action: " + (Object)((Object)action));
            }
        }
        Boolean allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, accessMask);
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(action, null, isDir, allowed);
        }
        return allowed;
    }

    public static Boolean isAllowed(int defMask, int allowMask, AccessAttribute attribute, Boolean isDir) {
        Boolean allowed = null;
        int accessMask = 0;
        switch (attribute) {
            case ACCESS4_READ: {
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, attribute: " + (Object)((Object)attribute));
                }
                if (isDir.equals(Boolean.FALSE)) {
                    allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, AccessMask.READ_DATA.getValue());
                    if (allowed != null) {
                        if (logger.isDebugEnabled()) {
                            AclNFSv4Matcher.logResult(Action.ACCESS, attribute.toString(), isDir, allowed);
                        }
                        return allowed;
                    }
                    accessMask = AccessMask.EXECUTE.getValue();
                    break;
                }
                accessMask = AccessMask.LIST_DIRECTORY.getValue();
                break;
            }
            case ACCESS4_LOOKUP: {
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, attribute: " + (Object)((Object)attribute));
                }
                if (!isDir.booleanValue()) break;
                accessMask = AccessMask.LIST_DIRECTORY.getValue();
                break;
            }
            case ACCESS4_MODIFY: {
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, attribute: " + (Object)((Object)attribute));
                }
                if (!isDir.booleanValue()) break;
                accessMask = AccessMask.ADD_SUBDIRECTORY.getValue();
                break;
            }
            case ACCESS4_EXTEND: {
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, attribute: " + (Object)((Object)attribute));
                }
                accessMask = isDir != false ? AccessMask.ADD_FILE.getValue() : AccessMask.WRITE_DATA.getValue();
                break;
            }
            case ACCESS4_DELETE: {
                accessMask = AccessMask.DELETE.getValue();
                break;
            }
            case ACCESS4_EXECUTE: {
                if (isDir == null) {
                    throw new IllegalArgumentException("Argument isDir is NULL, attribute: " + (Object)((Object)attribute));
                }
                if (!isDir.equals(Boolean.FALSE)) break;
                accessMask = AccessMask.EXECUTE.getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported access attribute: " + (Object)((Object)attribute));
            }
        }
        if (accessMask != 0) {
            allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, accessMask);
        }
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(Action.ACCESS, attribute.toString(), isDir, allowed);
        }
        return allowed;
    }

    public static Boolean isAllowed(Permission perm, Action action, FileAttribute attribute) {
        int accessMask;
        int defMask = perm.getDefMsk();
        int allowMask = perm.getAllowMsk();
        block0 : switch (action) {
            case GETATTR: {
                accessMask = FileAttribute.FATTR4_ACL == attribute ? AccessMask.READ_ACL.getValue() : AccessMask.READ_ATTRIBUTES.getValue();
                break;
            }
            case SETATTR: {
                switch (attribute) {
                    case FATTR4_SIZE: {
                        accessMask = AccessMask.WRITE_DATA.getValue();
                        break block0;
                    }
                    case FATTR4_ACL: 
                    case FATTR4_MODE: {
                        accessMask = AccessMask.WRITE_ACL.getValue();
                        break block0;
                    }
                    case FATTR4_OWNER: 
                    case FATTR4_OWNER_GROUP: {
                        accessMask = AccessMask.WRITE_OWNER.getValue();
                        break block0;
                    }
                    case FATTR4_ARCHIVE: 
                    case FATTR4_HIDDEN: 
                    case FATTR4_MIMETYPE: 
                    case FATTR4_SYSTEM: 
                    case FATTR4_TIME_ACCESS_SET: 
                    case FATTR4_TIME_BACKUP: 
                    case FATTR4_TIME_CREATE: 
                    case FATTR4_TIME_MODIFY_SET: 
                    case FATTR4_SUPPORTED_ATTRS: {
                        accessMask = AccessMask.WRITE_ATTRIBUTES.getValue();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported file attribute: " + (Object)((Object)attribute));
            }
            default: {
                throw new IllegalArgumentException("Usage failure. Invalid action: " + (Object)((Object)action));
            }
        }
        Boolean allowed = AclNFSv4Matcher.isAllowed(defMask, allowMask, accessMask);
        if (logger.isDebugEnabled()) {
            AclNFSv4Matcher.logResult(action, attribute.toString(), null, allowed);
        }
        return allowed;
    }

    private static void logResult(Action action, String attributes, Boolean isDir, Boolean allowed) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)action);
        if (isDir != null) {
            sb.append(isDir != false ? ":DIR" : ":FILE");
        }
        if (attributes != null) {
            sb.append(":").append(attributes);
        }
        sb.append(" - ").append(allowed == null ? "UNDEFINED" : (allowed != false ? "ALLOWED" : "DENIED"));
        logger.debug("AclNFSv4Matcher Results: " + sb.toString());
    }
}

