/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.mapper;

import java.util.ArrayList;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.acl.ACL;
import org.dcache.acl.Permission;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.RsType;
import org.dcache.acl.enums.Who;
import org.dcache.acl.unix.ACLUnix;
import org.dcache.acl.unix.AMUnix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclUnixMapper {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + AclUnixMapper.class.getName()));
    private static AclUnixMapper _SINGLETON = new AclUnixMapper();

    private AclUnixMapper() {
    }

    public static AclUnixMapper instance() {
        return _SINGLETON;
    }

    public static ACLUnix map(ACL acl) {
        List<ACE> aces;
        RsType rsType = acl.getRsType();
        List<ACE> accessACEs = aces = acl.getList();
        int[] defaultMasks = null;
        if (rsType == RsType.DIR) {
            accessACEs = new ArrayList<ACE>();
            ArrayList<ACE> defaultACEs = new ArrayList<ACE>();
            AclUnixMapper.splitACEs(aces, accessACEs, defaultACEs);
            defaultMasks = AclUnixMapper.getMasks(defaultACEs);
        }
        int[] accessMasks = AclUnixMapper.getMasks(accessACEs);
        ACLUnix aclUnix = new ACLUnix(acl.getRsId(), RsType.DIR.equals((Object)rsType), accessMasks, defaultMasks);
        return aclUnix;
    }

    private static int[] getMasks(List<ACE> aces) {
        int[] masks = new int[3];
        Permission permOwner = new Permission();
        Permission permGroup = new Permission();
        Permission permEveryone = new Permission();
        block5: for (ACE ace : aces) {
            Who who = ace.getWho();
            boolean allowed = AceType.ACCESS_ALLOWED_ACE_TYPE == ace.getType();
            switch (who) {
                case OWNER: {
                    AclUnixMapper.applyMask(permOwner, ace.getAccessMsk(), allowed);
                    continue block5;
                }
                case OWNER_GROUP: {
                    AclUnixMapper.applyMask(permGroup, ace.getAccessMsk(), allowed);
                    continue block5;
                }
                case EVERYONE: {
                    int msk = AclUnixMapper.applyMask(permEveryone, ace.getAccessMsk(), allowed);
                    if (msk == 0) continue block5;
                    AclUnixMapper.applyMask(permOwner, msk, allowed);
                    AclUnixMapper.applyMask(permGroup, msk, allowed);
                    continue block5;
                }
            }
            logger.info("Unsupported who: " + (Object)((Object)who));
        }
        masks[0] = AclUnixMapper.perm2accessMask(permOwner);
        masks[1] = AclUnixMapper.perm2accessMask(permGroup);
        masks[2] = AclUnixMapper.perm2accessMask(permEveryone);
        return masks;
    }

    private static int applyMask(Permission perm, int access_msk, boolean allowed) {
        int msk = access_msk & ~perm.getDefMsk();
        if (msk != 0) {
            perm.appendDefMsk(msk);
            if (allowed) {
                perm.appendAllowMsk(msk);
            }
        }
        return msk;
    }

    private static int perm2accessMask(Permission perm) {
        int allow_msk = perm.getAllowMsk();
        int mask = 0;
        if (AccessMask.READ_DATA.matches(allow_msk) || AccessMask.LIST_DIRECTORY.matches(allow_msk)) {
            mask |= AMUnix.READ.getValue();
        }
        if (AccessMask.WRITE_DATA.matches(allow_msk) || AccessMask.ADD_FILE.matches(allow_msk) || AccessMask.APPEND_DATA.matches(allow_msk) || AccessMask.ADD_SUBDIRECTORY.matches(allow_msk) || AccessMask.DELETE_CHILD.matches(allow_msk)) {
            mask |= AMUnix.WRITE.getValue();
        }
        if (AccessMask.EXECUTE.matches(allow_msk)) {
            mask |= AMUnix.EXECUTE.getValue();
        }
        return mask;
    }

    private static void splitACEs(List<ACE> aces, List<ACE> effectiveACEs, List<ACE> inheritedACEs) {
        for (ACE ace : aces) {
            int flags = ace.getFlags();
            if (!AceFlags.INHERIT_ONLY_ACE.matches(flags)) {
                effectiveACEs.add(ace);
            }
            if (!AceFlags.DIRECTORY_INHERIT_ACE.matches(flags) && !AceFlags.FILE_INHERIT_ACE.matches(flags)) continue;
            inheritedACEs.add(ace);
        }
    }
}

