/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.handler.singleton;

import java.util.Properties;
import org.dcache.acl.ACL;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.AclConfig;
import org.dcache.acl.handler.DefaultACLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + AclHandler.class.getName()));
    private static DefaultACLHandler _aclHandler;
    private static AclConfig _aclConfig;
    private static AclHandler _SINGLETON;

    private AclHandler() {
        try {
            if (_aclConfig != null) {
                _aclHandler = new DefaultACLHandler(_aclConfig);
            }
        }
        catch (ACLException e) {
            logger.error("Initialize ACL handler failed, reason: " + e.getMessage());
        }
    }

    public static AclHandler instance() {
        return _SINGLETON;
    }

    public static void refresh() {
        _SINGLETON = new AclHandler();
    }

    public static ACL getACL(String rsId) throws ACLException {
        if (_aclHandler == null) {
            throw new ACLException("aclHandler is NULL");
        }
        return _aclHandler.getACL(rsId);
    }

    public static int removeACL(String rsId) throws ACLException {
        if (_aclHandler == null) {
            throw new ACLException("aclHandler is NULL");
        }
        return _aclHandler.removeACL(rsId);
    }

    public static boolean setACL(ACL acl) throws ACLException {
        if (_aclHandler == null) {
            throw new ACLException("aclHandler is NULL");
        }
        return _aclHandler.setACL(acl);
    }

    public static void close() throws ACLException {
        if (_aclHandler != null) {
            _aclHandler.close();
        }
    }

    public void setProperties(Properties properties) throws ACLException {
        AclHandler.setAclConfig(properties);
    }

    public static void setAclConfig(Properties aclProps) throws ACLException {
        _aclConfig = new AclConfig(aclProps);
        AclHandler.refresh();
    }

    public static void setAclConfig(String configFile) throws ACLException {
        _aclConfig = new AclConfig(configFile);
        AclHandler.refresh();
    }

    public static void setAclConfig(AclConfig aclConfig) {
        _aclConfig = aclConfig;
        AclHandler.refresh();
    }

    public static AclConfig getAclConfig() {
        return _aclConfig;
    }

    static {
        _SINGLETON = new AclHandler();
    }
}

