/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.handler;

import com.jolbox.bonecp.BoneCPDataSource;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.Config;

class THandler {
    protected Config _config;
    protected DataSource _ds_pooled;

    public THandler(Config config) throws ACLException {
        this.initialize(config);
    }

    protected void initialize(Config config) throws ACLException {
        this._config = config;
        this._ds_pooled = this.getDataSource();
    }

    private DataSource getDataSource() throws ACLException {
        if (this._ds_pooled == null) {
            try {
                Driver d = (Driver)Class.forName(this._config.getDriver()).newInstance();
                String url = this._config.getUrl();
                if (!d.acceptsURL(url)) {
                    throw new ACLException("Get DataSource", "Driver not accept the URL: " + url);
                }
                BoneCPDataSource ds = new BoneCPDataSource();
                ds.setJdbcUrl(url);
                ds.setUsername(this._config.getUser());
                ds.setPassword(this._config.getPswd());
                ds.setIdleConnectionTestPeriodInMinutes(60L);
                ds.setIdleMaxAgeInMinutes(240L);
                ds.setMaxConnectionsPerPartition(30);
                ds.setMaxConnectionsPerPartition(10);
                ds.setPartitionCount(3);
                ds.setAcquireIncrement(5);
                ds.setStatementsCacheSize(100);
                ds.setReleaseHelperThreads(3);
                this._ds_pooled = ds;
                this.initPreparedStatements();
            }
            catch (InstantiationException e) {
                throw new ACLException("Get DataSource", e);
            }
            catch (IllegalAccessException e) {
                throw new ACLException("Get DataSource", e);
            }
            catch (ClassNotFoundException e) {
                throw new ACLException("Get DataSource", e);
            }
            catch (SQLException e) {
                throw new ACLException("Get DataSource", e);
            }
        }
        return this._ds_pooled;
    }

    protected void initPreparedStatements() {
    }

    public Config getConfig() {
        return this._config;
    }

    public void setConfig(Config config) {
        this._config = config;
    }

    public DataSource getDs_pooled() {
        return this._ds_pooled;
    }

    public void setDs_pooled(DataSource ds_pooled) {
        this._ds_pooled = ds_pooled;
    }

    public void close() throws ACLException {
        try {
            ((BoneCPDataSource)this._ds_pooled).close();
        }
        catch (Exception e) {
            throw new ACLException("Close ACL Handler", e);
        }
    }
}

