/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.Config;
import org.dcache.acl.handler.THandler;
import org.dcache.commons.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPathHandler
extends THandler {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + FPathHandler.class.getName()));
    private static final String FILE_SEPARATOR = System.getProperty("file.separator", "/");
    private static final String ROOT_ID = "000000000000000000000000000000000000";
    private static final String COL_NAME = "iname";
    private static final String COL_PARENT = "iparent";
    private static final String COL_ID = "ipnfsid";
    private static final String TABLE_DIRS = "t_dirs";
    private static final String SQLP_SELECT_ID = "SELECT ipnfsid FROM t_dirs WHERE iparent = ? AND iname = ?";

    public FPathHandler() throws ACLException {
        super(new Config(System.getProperty("fpath.configuration", "fpath.properties")));
    }

    public FPathHandler(Config config) throws ACLException {
        super(config);
    }

    private String getID(String parentID, String name) throws ACLException {
        String string;
        if (logger.isDebugEnabled()) {
            logger.debug("Getting ID: [parentID = " + parentID + ", name = " + name + "]");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String id = null;
        try {
            conn = this._ds_pooled.getConnection();
            pstmt = conn.prepareStatement(SQLP_SELECT_ID);
            pstmt.setString(1, parentID);
            pstmt.setString(2, name);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (id != null) {
                    throw new ACLException("Get ID", "Not a unique ID: [parentID = " + parentID + ", name = " + name + "]");
                }
                id = rs.getString(1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Getted ID: " + id);
            }
            string = id;
        }
        catch (SQLException e) {
            try {
                throw new ACLException("Get ID", "SQLException", e);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(rs);
                SqlHelper.tryToClose(pstmt);
                SqlHelper.tryToClose((Connection)conn);
                throw throwable;
            }
        }
        SqlHelper.tryToClose((ResultSet)rs);
        SqlHelper.tryToClose((PreparedStatement)pstmt);
        SqlHelper.tryToClose((Connection)conn);
        return string;
    }

    public String getID(String path) throws IllegalArgumentException, ACLException {
        String[] split = path.split(FILE_SEPARATOR);
        if (split == null) {
            throw new IllegalArgumentException("path can't be splitted: " + path);
        }
        int len = split.length;
        if (len < 1) {
            throw new IllegalArgumentException("Count tags invalid in path: " + path);
        }
        String id = null;
        String parentID = ROOT_ID;
        for (String name : split) {
            if (name.length() == 0) continue;
            parentID = id = this.getID(parentID, name);
        }
        return id;
    }
}

