/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.handler;

import java.util.ArrayList;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.acl.ACL;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.AclConfig;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.RsType;
import org.dcache.acl.handler.DefaultACLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclFsHandler
extends DefaultACLHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization.logger.org.dcache.authorization." + AclFsHandler.class.getName()));

    public AclFsHandler() throws ACLException {
    }

    public AclFsHandler(String configFile) throws ACLException {
        super(configFile);
    }

    public AclFsHandler(AclConfig aclConfig) throws ACLException {
        super(aclConfig);
    }

    public boolean inheritACL(ACL parentACL, String childID, boolean isChildDir) throws ACLException {
        List<ACE> aces = this.getDefaultACEs(parentACL, isChildDir);
        return aces.size() == 0 ? true : this.setACL(new ACL(childID, isChildDir ? RsType.DIR : RsType.FILE, aces));
    }

    public List<ACE> getDefaultACEs(ACL parentACL, boolean isChildDir) throws ACLException {
        try {
            ArrayList<ACE> aces = new ArrayList<ACE>();
            String parentID = parentACL.getRsId();
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug("Get default ACEs for " + (isChildDir ? "directory" : "file") + " from parent: " + parentID);
                startTime = System.currentTimeMillis();
            }
            int order = 0;
            int parentFlags = 0;
            List<ACE> parentAces = parentACL.getList();
            for (ACE ace : parentAces) {
                boolean addACE = false;
                parentFlags = ace.getFlags();
                int flags = 0;
                if (isChildDir) {
                    if (AceFlags.FILE_INHERIT_ACE.matches(parentFlags)) {
                        flags = AceFlags.FILE_INHERIT_ACE.getValue();
                    }
                    if (AceFlags.DIRECTORY_INHERIT_ACE.matches(parentFlags)) {
                        flags |= AceFlags.DIRECTORY_INHERIT_ACE.getValue();
                    }
                    if (addACE = flags != 0) {
                        if (AceFlags.IDENTIFIER_GROUP.matches(parentFlags)) {
                            flags |= AceFlags.IDENTIFIER_GROUP.getValue();
                        }
                    } else if (AceFlags.INHERIT_ONLY_ACE.matches(parentFlags)) {
                        logger.warn("Unsupported AceFlags.INHERIT_ONLY_ACE flag in ace: ace.order = " + order + ", ace.rsID = " + parentID);
                    }
                } else {
                    addACE = AceFlags.FILE_INHERIT_ACE.matches(parentFlags);
                    if (addACE) {
                        if (AceFlags.IDENTIFIER_GROUP.matches(parentFlags)) {
                            flags |= AceFlags.IDENTIFIER_GROUP.getValue();
                        }
                    } else if (AceFlags.INHERIT_ONLY_ACE.matches(parentFlags) && !AceFlags.DIRECTORY_INHERIT_ACE.matches(parentFlags)) {
                        logger.warn("Unsupported AceFlags.INHERIT_ONLY_ACE flag in ace: ace.order = " + order + ", ace.rsID = " + parentID);
                    }
                }
                if (addACE) {
                    logger.debug("AclFsHandler::getDefaultACEs in if(addACE), i.e. ACE will be added ");
                    aces.add(new ACE(ace.getType(), flags, ace.getAccessMsk(), ace.getWho(), ace.getWhoID(), ace.getAddressMsk()));
                }
                ++order;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("TIMING: Get default ACEs in " + (System.currentTimeMillis() - startTime) + " msec");
            }
            return aces;
        }
        catch (Exception e) {
            throw new ACLException("Get default ACEs", e);
        }
    }
}

