/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

public enum AccessType {
    ACCESS_ALLOWED(0),
    ACCESS_DENIED(1),
    ACCESS_UNDEFINED(2);

    private final int _value;

    private AccessType(int value) {
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    public boolean equals(int value) {
        return this._value == value;
    }

    public static AccessType valueOf(int value) throws IllegalArgumentException {
        for (AccessType type : AccessType.values()) {
            if (type._value != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Illegal value of Access Type): " + value);
    }

    public static AccessType valueOf(Boolean value) {
        if (value == null) {
            return ACCESS_UNDEFINED;
        }
        return value != false ? ACCESS_ALLOWED : ACCESS_DENIED;
    }

    public static AccessType valueOf(boolean value) {
        return value ? ACCESS_ALLOWED : ACCESS_DENIED;
    }

    public AccessType and(AccessType other) {
        if (this == ACCESS_ALLOWED && other == ACCESS_ALLOWED) {
            return ACCESS_ALLOWED;
        }
        if (this == ACCESS_DENIED || other == ACCESS_DENIED) {
            return ACCESS_DENIED;
        }
        return ACCESS_UNDEFINED;
    }
}

