/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.InvalidPropertyException;
import org.dcache.acl.config.MissingPropertyException;
import org.dcache.acl.config.PropertyException;
import org.dcache.acl.util.io.FileTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger _logger = LoggerFactory.getLogger((String)("logger.org.dcache.authorization." + Config.class.getName()));
    protected static final String SEPARATOR_COMMA = ", ";
    protected static final String CONN_DRIVER = "aclConnDriver";
    protected static final String CONN_URL = "aclConnUrl";
    protected static final String CONN_USER = "aclConnUser";
    protected static final String CONN_PSWD = "aclConnPswd";
    private static final String DEFLT_USER = "";
    private static final String DEFLT_PSWD = "";
    protected String _pswd;
    protected String _driver;
    protected String _url;
    protected String _user;
    protected String _cfile;
    protected Properties _props;

    public Config(String filename) throws ACLException {
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("Configuration file is undefined.");
        }
        this._cfile = filename;
        this.initProperties();
    }

    public Config(Properties props) throws ACLException {
        if (props == null) {
            throw new IllegalArgumentException("Set of properties is undefined.");
        }
        this._props = props;
        this.initProperties();
    }

    protected void initProperties() throws ACLException {
        try {
            this._driver = this.getProperties().getProperty(CONN_DRIVER);
            if (this._driver == null || this._driver.length() == 0) {
                throw new MissingPropertyException(CONN_DRIVER, this._cfile);
            }
            this._url = this.getProperties().getProperty(CONN_URL);
            if (this._url == null || this._url.length() == 0) {
                throw new MissingPropertyException(CONN_URL, this._cfile);
            }
            this._user = this.getProperties().getProperty(CONN_USER, "");
            this._pswd = this.getProperties().getProperty(CONN_PSWD, "");
        }
        catch (PropertyException e) {
            throw new ACLException("Initialize Config", "PropertyException", e);
        }
        catch (IOException e) {
            throw new ACLException("Initialize Config", "IOException", e);
        }
        catch (Exception e) {
            throw new ACLException("Initialize Config", e);
        }
        finally {
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.toString());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CONN_DRIVER).append(" = ").append(this._driver).append(SEPARATOR_COMMA);
        sb.append(CONN_URL).append(" = ").append(this._url).append(SEPARATOR_COMMA);
        sb.append(CONN_USER).append(" = ").append(this._user).append(SEPARATOR_COMMA);
        sb.append(CONN_PSWD).append(" = ").append(this._pswd == null ? null : "<hidden>");
        return sb.toString();
    }

    protected Boolean getBoolProperty(String key, Boolean deflt) throws IOException, PropertyException {
        String value = this.getProperties().getProperty(key);
        try {
            return value == null ? deflt : Config.str2Bool(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyException(key, value, this._cfile);
        }
    }

    public static Boolean str2Bool(String str) throws IllegalArgumentException {
        if (Boolean.TRUE.toString().equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid argument:" + str);
    }

    protected Integer getIntProperty(String key, Integer deflt) throws IOException, PropertyException {
        String value = this.getProperties().getProperty(key);
        try {
            return value == null ? deflt : Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            _logger.error("NumberFormatException: " + e.getMessage());
            throw new InvalidPropertyException(key, value, this._cfile);
        }
    }

    protected String getFileProperty(String key) throws IOException, PropertyException {
        String value = this.getProperties().getProperty(key);
        if (value == null || value.length() == 0) {
            throw new MissingPropertyException(key, this._cfile);
        }
        try {
            FileTools.checkReadFile(new File(value));
        }
        catch (IOException e) {
            _logger.error("IOException: " + e.getMessage());
            throw new InvalidPropertyException(key, value, this._cfile);
        }
        return value;
    }

    protected String getProperty(String key) throws IOException, PropertyException {
        String value = this.getProperties().getProperty(key);
        if (value == null || value.length() == 0) {
            throw new MissingPropertyException(key, this._cfile);
        }
        return value;
    }

    public Properties getProperties() throws IOException {
        if (this._props == null) {
            File aFile = new File(this._cfile);
            FileTools.checkReadFile(aFile);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Loading configuration file: " + aFile);
            }
            this._props = new Properties();
            this._props.load(new FileInputStream(aFile));
        }
        return this._props;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public String getConfigFile() {
        return this._cfile;
    }

    public void setConfigFile(String cfile) {
        this._cfile = cfile;
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setPswd(String pswd) {
        this._pswd = pswd;
    }

    public String getPswd() {
        return this._pswd;
    }
}

