/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.config;

import java.io.IOException;
import java.util.Properties;
import org.dcache.acl.ACLException;
import org.dcache.acl.config.Config;
import org.dcache.acl.config.PropertyException;

public class AclConfig
extends Config {
    private static final String ACL_CONFIG = "acl.configuration";
    private static final String ACL_ENABLED = "aclEnabled";
    private static final String ACL_CACHE_SIZE = "aclCacheSize";
    private static final String ACL_TABLE = "aclTable";
    private static final Boolean DEFLT_ACL_ENABLED = Boolean.TRUE;
    private static final Integer DEFLT_CACHE_SIZE = new Integer(0);
    private static final String DEFLT_ACL_TABLE = "t_acl";
    private Boolean _isAclEnabled;
    private Integer _cacheSize;
    private String _aclTable;

    public AclConfig() throws ACLException {
        this(System.getProperty(ACL_CONFIG, "acl.properties"));
    }

    public AclConfig(String filename) throws ACLException {
        super(filename);
    }

    public AclConfig(Properties props) throws ACLException {
        super(props);
    }

    @Override
    protected void initProperties() throws ACLException {
        try {
            this._isAclEnabled = this.getBoolProperty(ACL_ENABLED, DEFLT_ACL_ENABLED);
            this._cacheSize = this.getIntProperty(ACL_CACHE_SIZE, DEFLT_CACHE_SIZE);
            this._aclTable = this.getProperties().getProperty(ACL_TABLE, DEFLT_ACL_TABLE);
            super.initProperties();
        }
        catch (PropertyException e) {
            throw new ACLException("Initialize ACLConfig", "PropertyException", e);
        }
        catch (IOException e) {
            throw new ACLException("Initialize ACLConfig", "IOException", e);
        }
        catch (Exception e) {
            throw new ACLException("Initialize ACLConfig", e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", ").append(ACL_ENABLED).append(" = ").append(this._isAclEnabled);
        sb.append(", ").append(ACL_CACHE_SIZE).append(" = ").append(this._cacheSize);
        sb.append(", ").append(ACL_TABLE).append(" = ").append(this._aclTable);
        return sb.toString();
    }

    public boolean isAclEnabled() {
        return this._isAclEnabled == null ? DEFLT_ACL_ENABLED : this._isAclEnabled;
    }

    public void setAclEnabled(Boolean aclEnabled) {
        this._isAclEnabled = aclEnabled;
    }

    public Integer getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this._cacheSize = cacheSize;
    }

    public String getACLTable() {
        return this._aclTable;
    }

    public void setACLTable(String aclTable) {
        this._aclTable = aclTable;
    }
}

