/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.topology;

import dmg.cells.network.CellDomainNode;
import dmg.util.Args;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellNameService;
import org.dcache.cells.CellNameServiceRegistry;
import org.dcache.services.topology.AbstractCellsTopology;
import org.dcache.services.topology.CellsTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsCellsTopology
extends AbstractCellsTopology
implements CellsTopology,
CellCommandListener,
ExceptionListener {
    private static final Logger _log = LoggerFactory.getLogger(JmsCellsTopology.class);
    private Executor _executor;
    private ConnectionFactory _connectionFactory;
    private Connection _connection;
    private Session _sendSession;
    private Session _receiveSession;
    private MessageConsumer _cnsConsumer;
    private CellNameServiceRegistry _registry;
    private volatile Map<String, CellDomainNode> _currentMap = new ConcurrentHashMap<String, CellDomainNode>();
    private volatile Map<String, CellDomainNode> _nextMap = new ConcurrentHashMap<String, CellDomainNode>();
    public final String hh_update = "# initiates background update";

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connectionFactory = factory;
    }

    public void setExecutor(Executor executor) {
        this._executor = executor;
    }

    public void setCellNameServiceRegistry(CellNameServiceRegistry registry) {
        this._registry = registry;
    }

    public void start() throws JMSException {
        this._connection = this._connectionFactory.createConnection();
        this._connection.setExceptionListener((ExceptionListener)this);
        this._sendSession = this._connection.createSession(false, 1);
        this._receiveSession = this._connection.createSession(false, 3);
        this._cnsConsumer = this._receiveSession.createConsumer((Destination)this._receiveSession.createTopic("cells.cns.registration"));
        this._cnsConsumer.setMessageListener((MessageListener)this._registry);
        try {
            CellNameService.requestUpdate(this._sendSession);
        }
        catch (JMSException e) {
            _log.debug("Failed to request CNS update: {}", (Object)e.getMessage());
        }
        this._connection.start();
    }

    public void stop() throws JMSException {
        this._connection.close();
    }

    public void onException(JMSException exception) {
        _log.error("Fatal JMS connection failure: {}", (Object)exception.getMessage());
        new Thread("topo-recover"){

            @Override
            public void run() {
                while (true) {
                    try {
                        JmsCellsTopology.this.stop();
                    }
                    catch (JMSException e) {
                        _log.error("Failed to shut down JMS connection: {}", (Object)e.getMessage());
                    }
                    try {
                        JmsCellsTopology.this.start();
                        return;
                    }
                    catch (JMSException e) {
                        _log.error("Failed to shut down JMS connection: {}", (Object)e.getMessage());
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private void addDomain(final String domain) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Map map = JmsCellsTopology.this.buildTopologyMap(domain);
                    JmsCellsTopology.this._currentMap.putAll(map);
                    JmsCellsTopology.this._nextMap.putAll(map);
                }
                catch (InterruptedException e) {
                    _log.info("Topology construction was interrupted");
                }
            }
        });
    }

    public synchronized void update() throws JMSException {
        this._currentMap = this._nextMap;
        this._nextMap = new ConcurrentHashMap<String, CellDomainNode>();
        for (String domain : this._registry.getDomains()) {
            this.addDomain(domain);
        }
    }

    public CellDomainNode[] getInfoMap() {
        return this._currentMap.values().toArray(new CellDomainNode[0]);
    }

    public String ac_update(Args args) throws JMSException {
        CellNameService.requestUpdate(this._sendSession);
        for (String domain : this._registry.getDomains()) {
            this.addDomain(domain);
        }
        return "Background update started";
    }
}

