/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellExceptionMessage;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.util.Args;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.dcache.cells.AbstractCell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSTunnel
extends AbstractCell
implements CellTunnel,
ExceptionListener {
    private static final Logger _logMessages = LoggerFactory.getLogger((String)"logger.org.dcache.cells.messages");
    private static final Logger _log = LoggerFactory.getLogger(JMSTunnel.class);
    public static final long CNS_TIMEOUT = 20000L;
    public static final long CNS_REGISTRATION_PERIOD = 120000L;
    public static final long CACHE_TIME = 120000L;
    public static final long MESSAGE_TTL = 300000L;
    private final Set<String> _localExports = new HashSet<String>();
    private final Map<String, Set<String>> _domains = new HashMap<String, Set<String>>();
    private Timer _timer;
    private final CellNucleus _nucleus;
    private final ConnectionFactory _factory;
    private Connection _connection;
    private CnsClient _cns;
    private Receiver _receiver;
    private Sender _sender;
    public static final String hh_ls = "[-x]";

    public JMSTunnel(String name, ConnectionFactory factory) throws InterruptedException, ExecutionException {
        super(name, "System", new Args((CharSequence)""));
        this._factory = factory;
        this._nucleus = this.getNucleus();
        this.doInit();
    }

    protected void init() throws JMSException {
        this._timer = new Timer(this.getCellName() + " Timeout Timer", true);
        this.addCellEventListener();
        this._nucleus.routeAdd(new CellRoute(null, this.getCellName(), 4));
        this._connection = this._factory.createConnection();
        this._connection.setExceptionListener((ExceptionListener)this);
        this._cns = new CnsClient(this.getNucleus(), this._connection);
        this._sender = new Sender(this._connection);
        this._receiver = new Receiver(this._connection);
        this._receiver.addConsumer(this.getCellDomainName());
        this._connection.start();
    }

    public void shutdown() throws InterruptedException {
        this.kill();
        this.getNucleus().join(this.getCellName(), 1000L);
    }

    public void onException(JMSException exception) {
        _log.error("Fatal failure in JMS connection: {}", (Throwable)exception);
        this.getNucleus().kill("System");
    }

    protected String getDomainQueue(String domain) {
        return "cells.domain." + domain.replaceAll("_", "__").replaceAll("-", "_");
    }

    public synchronized void cleanUp() {
        if (this._timer != null) {
            this._timer.cancel();
        }
        try {
            if (this._cns != null) {
                this._cns.unregister();
            }
        }
        catch (JMSException e) {
            _log.warn("Failed to unregister from cell name service: {}", (Object)e.getMessage());
        }
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (JMSException e) {
            _log.warn("Failed to close JMS connection: {}", (Object)e.getMessage());
        }
    }

    public synchronized void getInfo(PrintWriter pw) {
        pw.println("Cell name  : " + this.getCellName());
        pw.println("-> JMS     : " + this._sender.getMessageCount());
        pw.println("-> Domain  : " + this._receiver.getMessageCount());
        pw.println("Our routing knowledge:");
        pw.append(" Local: ").println(this._localExports);
        for (Map.Entry<String, Set<String>> entry : this._domains.entrySet()) {
            pw.append(' ').append(entry.getKey()).append(": ").println(entry.getValue());
        }
        pw.println("Our JMS consumers:");
        for (String string : this._receiver.getConsumers()) {
            pw.append(' ').println(this.getDomainQueue(string));
        }
        pw.println("CNS cache:");
        for (Map.Entry entry : this._sender.getCnsCache().entrySet()) {
            pw.println(String.format(" %-20s %s", entry.getKey(), ((CacheEntry)entry.getValue()).domain));
        }
        pw.println("JMS:");
        try {
            ConnectionMetaData data = this._connection.getMetaData();
            pw.append(" Protocol version: ").println(data.getJMSVersion());
            pw.append(" Provider name: ").println(data.getJMSProviderName());
            pw.append(" Provider version: ").println(data.getProviderVersion());
        }
        catch (JMSException e) {
            _log.error("Failed to query JMS meta data: {}", (Object)e.getMessage());
            pw.println(" Information unavailable");
        }
    }

    public synchronized CellTunnelInfo getCellTunnelInfo() {
        return new CellTunnelInfo(this.getCellName(), this._nucleus.getCellDomainInfo(), null);
    }

    private void returnToSender(CellMessage msg, NoRouteToCellException e) {
        try {
            if (!(msg instanceof CellExceptionMessage)) {
                _log.info("Cannot deliver {}", (Object)msg);
                CellPath retAddr = (CellPath)msg.getSourcePath().clone();
                retAddr.revert();
                CellExceptionMessage ret = new CellExceptionMessage(retAddr, (Object)e);
                ret.setLastUOID(msg.getUOID());
                this.sendMessage((CellMessage)ret);
            }
        }
        catch (NoRouteToCellException f) {
            _log.warn("Unable to deliver message and unable to return it to sender: {}", (Object)msg);
        }
    }

    public synchronized void messageArrived(CellMessage msg) {
        Object obj = msg.getMessageObject();
        if (!(obj instanceof String[])) {
            return;
        }
        String[] info = (String[])obj;
        if (info.length > 0) {
            _log.info("Routing info arrived for domain: {}", (Object)info[0]);
            String domain = info[0];
            HashSet<String> newCells = new HashSet<String>();
            for (int i = 1; i < info.length; ++i) {
                newCells.add(info[i]);
            }
            this.updateRoutingInfo(domain, newCells);
        }
    }

    public synchronized void messageArrived(MessageEvent me) {
        if (me instanceof RoutedMessageEvent) {
            CellMessage envelope = me.getMessage();
            try {
                this._sender.send(envelope);
            }
            catch (JMSException e) {
                _log.error("Failed to send message: {}", (Object)e.getMessage());
                this.returnToSender(envelope, new NoRouteToCellException(envelope.getUOID(), envelope.getDestinationPath(), "Communication failure. Message could not be delivered."));
            }
        } else {
            super.messageArrived(me);
        }
    }

    private synchronized CellRoute createWellKnownRoute(String cell, String domain) {
        return new CellRoute(cell, "*@" + domain, 2);
    }

    private synchronized void updateRoutingInfo(String domain, Set<String> cells) {
        Set<String> oldCells = this._domains.get(domain);
        if (oldCells == null) {
            oldCells = Collections.emptySet();
        }
        for (String cell : cells) {
            if (this._localExports.contains(cell) || oldCells.remove(cell) || cell.startsWith("@")) continue;
            _log.info("Adding: {}", (Object)cell);
            try {
                this._nucleus.routeAdd(this.createWellKnownRoute(cell, domain));
            }
            catch (IllegalArgumentException e) {
                _log.error("Could not add wellknown route: {}", (Object)e.toString());
            }
        }
        for (String cell : oldCells) {
            if (cell.startsWith("@")) continue;
            _log.info("Removing: {}", (Object)cell);
            try {
                this._nucleus.routeDelete(this.createWellKnownRoute(cell, domain));
            }
            catch (IllegalArgumentException e) {
                _log.warn("Could not delete wellknown route: {}", (Object)e.getMessage());
            }
        }
        this._domains.put(domain, cells);
    }

    public synchronized void cellDied(CellEvent ce) {
        String name = (String)ce.getSource();
        this._localExports.remove(name);
    }

    public synchronized void cellExported(CellEvent ce) {
        String name = (String)ce.getSource();
        this._localExports.add(name);
    }

    public synchronized void routeAdded(CellEvent ce) {
        try {
            CellRoute cr = (CellRoute)ce.getSource();
            if (cr.getRouteType() == 3) {
                this._receiver.addConsumer(cr.getDomainName());
            }
        }
        catch (JMSException e) {
            _log.error("Failed to create JMS consumer: {}", (Object)e.getMessage());
        }
    }

    public synchronized void routeDeleted(CellEvent ce) {
        try {
            CellRoute cr = (CellRoute)ce.getSource();
            if (cr.getRouteType() == 3) {
                String domain = cr.getDomainName();
                Set<String> empty = Collections.emptySet();
                this.updateRoutingInfo(domain, empty);
                this._receiver.removeConsumer(domain);
            }
        }
        catch (JMSException e) {
            _log.error("Failed to remove JMS consumer: {}", (Object)e.getMessage());
        }
    }

    @Deprecated
    public synchronized Object ac_ls_$_0(Args args) {
        if (!args.hasOption("x")) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            this.getInfo(pw);
            pw.flush();
            return os.toString();
        }
        Object[] infoArray = new Object[]{this._nucleus.getCellDomainName(), this._localExports, this._domains};
        return infoArray;
    }

    class CnsClient
    extends TimerTask
    implements MessageListener,
    CellEventListener {
        protected final Session _session;
        protected final MessageConsumer _consumer;
        protected final MessageProducer _producer;
        protected final String _domain;
        protected final Set<String> _names = new HashSet<String>();

        public CnsClient(CellNucleus nucleus, Connection connection) throws JMSException {
            this._domain = nucleus.getCellDomainName();
            this._session = connection.createSession(false, 1);
            this._producer = this._session.createProducer((Destination)this._session.createTopic("cells.cns.registration"));
            this._producer.setDeliveryMode(1);
            this._producer.setDisableMessageID(true);
            this._producer.setDisableMessageTimestamp(true);
            this._producer.setTimeToLive(120000L);
            Session session = connection.createSession(false, 3);
            this._consumer = session.createConsumer((Destination)session.createTopic("cells.cns.refresh"));
            this._consumer.setMessageListener((MessageListener)this);
            nucleus.addCellEventListener((CellEventListener)this);
            JMSTunnel.this._timer.schedule((TimerTask)this, 0L, 120000L);
        }

        @Override
        public void run() {
            try {
                this.register();
            }
            catch (RuntimeException e) {
                JMSTunnel.this._logger.error("Failed to register with cell name service", (Throwable)e);
            }
        }

        public synchronized void register() {
            try {
                StreamMessage msg = this._session.createStreamMessage();
                msg.writeString(this._domain);
                msg.writeLong(360000L);
                msg.writeInt(this._names.size());
                for (String name : this._names) {
                    msg.writeString(name);
                }
                this._producer.send((Message)msg);
            }
            catch (JMSException e) {
                JMSTunnel.this._logger.error("Failed to register with cell name service: {}", (Object)e.getMessage());
            }
        }

        public synchronized void unregister() throws JMSException {
            StreamMessage msg = this._session.createStreamMessage();
            msg.writeString(this._domain);
            msg.writeLong(0L);
            msg.writeInt(0);
            this._producer.send((Message)msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            CDC cdc = CDC.reset((CellNucleus)JMSTunnel.this._nucleus);
            try {
                this.register();
            }
            finally {
                cdc.restore();
            }
        }

        public synchronized void routeAdded(CellEvent ce) {
            CellRoute cr = (CellRoute)ce.getSource();
            if (cr.getRouteType() == 2 && this._names.add(cr.getCellName())) {
                this.register();
            }
        }

        public synchronized void routeDeleted(CellEvent ce) {
            CellRoute cr = (CellRoute)ce.getSource();
            if (cr.getRouteType() == 2 && this._names.remove(cr.getCellName())) {
                this.register();
            }
        }

        public synchronized void cellDied(CellEvent ce) {
            String name = (String)ce.getSource();
            if (this._names.remove(name)) {
                this.register();
            }
        }

        public synchronized void cellExported(CellEvent ce) {
            String name = (String)ce.getSource();
            if (this._names.add(name)) {
                this.register();
            }
        }

        public void cellCreated(CellEvent ce) {
        }
    }

    class Receiver
    implements MessageListener {
        private final Connection _connection;
        private final Map<String, Session> _sessions = new HashMap<String, Session>();
        private long _counter;

        public Receiver(Connection connection) {
            this._connection = connection;
        }

        public synchronized long getMessageCount() {
            return this._counter;
        }

        private synchronized void logReceive(CellMessage envelope) {
            if (_logMessages.isDebugEnabled()) {
                String messageObject = envelope.getMessageObject() == null ? "NULL" : envelope.getMessageObject().getClass().getName();
                _logMessages.debug("tunnelSendMessage src=" + envelope.getSourceAddress() + " dest=" + envelope.getDestinationAddress() + " [" + messageObject + "] UOID=" + envelope.getUOID().toString());
            }
        }

        public synchronized Collection<String> getConsumers() {
            return new ArrayList<String>(this._sessions.keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onMessage(Message message) {
            CDC cdc = CDC.reset((CellNucleus)JMSTunnel.this._nucleus);
            try {
                ObjectMessage objectMessage = (ObjectMessage)message;
                Serializable object = objectMessage.getObject();
                CellMessage envelope = (CellMessage)object;
                try {
                    this.logReceive(envelope);
                    JMSTunnel.this.sendMessage(envelope);
                    ++this._counter;
                }
                catch (NoRouteToCellException e) {
                    JMSTunnel.this.returnToSender(envelope, e);
                }
            }
            catch (ClassCastException e) {
                _log.warn("Dropping unknown message: {}", (Object)message);
            }
            catch (JMSException e) {
                _log.error("Failed to retrieve object from JMS message: {}", (Object)e.getMessage());
            }
            finally {
                cdc.restore();
            }
        }

        public synchronized void addConsumer(String domain) throws JMSException {
            if (!this._sessions.containsKey(domain)) {
                Session session = this._connection.createSession(false, 1);
                Queue queue = session.createQueue(JMSTunnel.this.getDomainQueue(domain));
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)this);
                this._sessions.put(domain, session);
            }
        }

        public synchronized void removeConsumer(String domain) throws JMSException {
            Session session = this._sessions.remove(domain);
            if (session != null) {
                session.close();
            }
        }
    }

    static class CacheEntry {
        final long time;
        final String domain;

        public CacheEntry(long time, String domain) {
            this.time = time;
            this.domain = domain;
        }
    }

    class Sender
    implements MessageListener {
        private final Multimap<String, Lookup> _lookups = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        private final Map<String, CacheEntry> _cache = new LinkedHashMap<String, CacheEntry>();
        private final Session _session;
        private final MessageProducer _producer;
        private final MessageProducer _cns;
        private final Destination _replyQueue;
        private long _counter;

        public Sender(Connection connection) throws JMSException {
            this._session = connection.createSession(false, 1);
            this._producer = this._session.createProducer(null);
            this._producer.setDeliveryMode(1);
            this._producer.setDisableMessageID(true);
            this._producer.setDisableMessageTimestamp(true);
            this._producer.setTimeToLive(300000L);
            this._cns = this._session.createProducer((Destination)this._session.createQueue("cells.cns.lookup"));
            this._cns.setDeliveryMode(1);
            this._cns.setDisableMessageID(true);
            this._cns.setDisableMessageTimestamp(true);
            this._cns.setTimeToLive(40000L);
            Session session = connection.createSession(false, 3);
            this._replyQueue = session.createTemporaryQueue();
            session.createConsumer(this._replyQueue).setMessageListener((MessageListener)this);
        }

        private synchronized void logSend(CellMessage envelope) {
            if (_logMessages.isDebugEnabled()) {
                Object object = envelope.getMessageObject();
                String messageObject = object == null ? "NULL" : object.getClass().getName();
                _logMessages.debug("tunnelMessageArrived src=" + envelope.getSourceAddress() + " dest=" + envelope.getDestinationAddress() + " [" + messageObject + "] UOID=" + envelope.getUOID().toString());
            }
        }

        public synchronized Map<String, CacheEntry> getCnsCache() {
            return new HashMap<String, CacheEntry>(this._cache);
        }

        public synchronized String lookup(String cell) {
            long now = System.currentTimeMillis();
            Iterator<CacheEntry> i = this._cache.values().iterator();
            while (i.hasNext() && i.next().time < now) {
                i.remove();
            }
            CacheEntry entry = this._cache.get(cell);
            return entry == null ? null : entry.domain;
        }

        public synchronized void addToCache(String cell, String domain) {
            Collection lookupsForCell = this._lookups.removeAll((Object)cell);
            if (Strings.isNullOrEmpty((String)domain)) {
                for (Lookup lookup : lookupsForCell) {
                    if (!lookup.cancel()) continue;
                    CellMessage envelope = lookup.envelope;
                    JMSTunnel.this.returnToSender(envelope, new NoRouteToCellException(envelope.getUOID(), envelope.getDestinationPath(), "No route to " + cell));
                }
            } else {
                CacheEntry entry = new CacheEntry(System.currentTimeMillis() + 120000L, domain);
                this._cache.put(cell, entry);
                for (Lookup lookup : lookupsForCell) {
                    if (!lookup.cancel()) continue;
                    CellMessage envelope = lookup.envelope;
                    try {
                        this.send(envelope);
                    }
                    catch (JMSException e) {
                        _log.error("Failed to send message: {}", (Object)e.getMessage());
                        JMSTunnel.this.returnToSender(envelope, new NoRouteToCellException(envelope.getUOID(), envelope.getDestinationPath(), "Communication failure. Message could not be delivered."));
                    }
                }
            }
        }

        public synchronized void resolve(String cell, CellMessage envelope) throws JMSException {
            TextMessage request = this._session.createTextMessage(cell);
            request.setJMSReplyTo(this._replyQueue);
            this._cns.send((Message)request);
            Lookup lookup = new Lookup(cell, envelope);
            this._lookups.put((Object)cell, (Object)lookup);
            JMSTunnel.this._timer.schedule((TimerTask)lookup, 20000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void onMessage(Message message) {
            CDC cdc = CDC.reset((CellNucleus)JMSTunnel.this._nucleus);
            try {
                TextMessage textMessage = (TextMessage)message;
                String cell = textMessage.getJMSCorrelationID();
                String domain = textMessage.getText();
                this.addToCache(cell, domain);
            }
            catch (ClassCastException e) {
                _log.error("Received unexpected reply to CNS request: {}", (Object)message);
            }
            catch (JMSException e) {
                _log.error("Error while resolving well known cell: {}", (Object)e.getMessage());
            }
            finally {
                cdc.restore();
            }
        }

        public synchronized void send(CellMessage envelope) throws JMSException {
            CellPath address = envelope.getDestinationAddress();
            String cell = address.getCellName();
            String domain = address.getCellDomainName();
            if (cell == null || domain == null) {
                throw new JMSException("Message has no destination: " + envelope);
            }
            if (domain.equals("local") && (domain = this.lookup(cell)) == null) {
                this.resolve(cell, envelope);
            } else {
                this.logSend(envelope);
                Queue destination = this._session.createQueue(JMSTunnel.this.getDomainQueue(domain));
                ObjectMessage message = this._session.createObjectMessage((Serializable)envelope);
                this._producer.send((Destination)destination, (Message)message);
                ++this._counter;
            }
        }

        public synchronized long getMessageCount() {
            return this._counter;
        }

        class Lookup
        extends TimerTask {
            final String cell;
            final CellMessage envelope;

            Lookup(String cell, CellMessage envelope) {
                this.cell = cell;
                this.envelope = envelope;
            }

            @Override
            public void run() {
                try {
                    Sender.this._lookups.remove((Object)this.cell, (Object)this);
                    JMSTunnel.this.returnToSender(this.envelope, new NoRouteToCellException(this.envelope.getUOID(), this.envelope.getDestinationPath(), "Failed to resolve well known cell"));
                }
                catch (RuntimeException e) {
                    JMSTunnel.this._logger.error("Message timeout failed", (Throwable)e);
                }
            }
        }
    }
}

