/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import com.google.common.base.Objects;
import dmg.cells.nucleus.CellInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.StreamMessage;
import org.dcache.cells.CellInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellNameServiceRegistry
implements MessageListener,
CellInfoProvider {
    private static final Logger _log = LoggerFactory.getLogger(CellNameServiceRegistry.class);
    private final Map<String, String> _cells = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> _domains = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Long> _timeouts = new ConcurrentHashMap<String, Long>();

    private synchronized boolean isValid(long now, String domainName) {
        Long timeout = this._timeouts.get(domainName);
        if (timeout != null && timeout > now) {
            return true;
        }
        this.unregister(domainName);
        return false;
    }

    public Collection<String> getDomains() {
        long now = System.currentTimeMillis();
        ArrayList<String> domains = new ArrayList<String>();
        for (String domainName : this._domains.keySet()) {
            if (!this.isValid(now, domainName)) continue;
            domains.add(domainName);
        }
        return domains;
    }

    public String getDomain(String cell) {
        String domain = this._cells.get(cell);
        if (domain != null && this.isValid(System.currentTimeMillis(), domain)) {
            return domain;
        }
        return null;
    }

    private synchronized void unregister(String domainName) {
        this._timeouts.remove(domainName);
        Set<String> oldCells = this._domains.remove(domainName);
        if (oldCells != null) {
            for (String cell : oldCells) {
                if (!Objects.equal((Object)domainName, (Object)this._cells.get(cell))) continue;
                this._cells.remove(cell);
            }
        }
    }

    private synchronized void register(String domainName, Set<String> cells, long timeout) {
        this.unregister(domainName);
        for (String cellName : cells) {
            this._cells.put(cellName, domainName);
        }
        this._domains.put(domainName, cells);
        this._timeouts.put(domainName, System.currentTimeMillis() + timeout);
    }

    public void onMessage(Message message) {
        try {
            StreamMessage streamMessage = (StreamMessage)message;
            String domainName = streamMessage.readString();
            long timeout = streamMessage.readLong();
            if (timeout == 0L) {
                this.unregister(domainName);
            } else {
                int length = streamMessage.readInt();
                HashSet<String> cells = new HashSet<String>();
                for (int i = 0; i < length; ++i) {
                    cells.add(streamMessage.readString());
                }
                this.register(domainName, cells, timeout);
            }
        }
        catch (ClassCastException e) {
            _log.warn("Dropping unknown message: {}", (Object)message);
        }
        catch (JMSException e) {
            _log.error("Failed to register well-known cells: {}", (Object)e.getMessage());
        }
    }

    public void getInfo(PrintWriter pw) {
        for (String domain : this.getDomains()) {
            pw.append(domain);
            Set<String> cells = this._domains.get(domain);
            if (cells != null) {
                pw.append(": ");
                for (String cell : cells) {
                    pw.append(cell).append(" ");
                }
            }
            pw.println();
        }
    }

    public CellInfo getCellInfo(CellInfo info) {
        return info;
    }
}

