/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.OSMStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.namespace.ChimeraHsmStorageInfoExtractor;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.InodeStorageInformation;

public class ChimeraOsmStorageInfoExtractor
extends ChimeraHsmStorageInfoExtractor {
    public ChimeraOsmStorageInfoExtractor(AccessLatency defaultAL, RetentionPolicy defaultRP) {
        super(defaultAL, defaultRP);
    }

    @Override
    public StorageInfo getFileStorageInfo(FsInode inode) throws CacheException {
        OSMStorageInfo info;
        Stat stat = null;
        FsInode level2 = new FsInode(inode.getFs(), inode.toString(), 2);
        try {
            List locations = inode.getFs().getInodeLocations(inode, 0);
            if (locations.isEmpty()) {
                RetentionPolicy rp;
                info = (OSMStorageInfo)this.getDirStorageInfo(inode);
                AccessLatency al = inode.getFs().getAccessLatency(inode);
                if (al != null) {
                    info.setAccessLatency(AccessLatency.getAccessLatency((int)al.getId()));
                }
                if ((rp = inode.getFs().getRetentionPolicy(inode)) != null) {
                    info.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((int)rp.getId()));
                }
            } else {
                InodeStorageInformation inodeStorageInfo = inode.getFs().getSorageInfo(inode);
                info = new OSMStorageInfo(inodeStorageInfo.storageGroup(), inodeStorageInfo.storageSubGroup());
                info.setIsNew(false);
                info.setAccessLatency(inodeStorageInfo.accessLatency());
                info.setRetentionPolicy(inodeStorageInfo.retentionPolicy());
                for (StorageLocatable location : locations) {
                    if (!location.isOnline()) continue;
                    try {
                        info.addLocation(new URI(location.location()));
                    }
                    catch (URISyntaxException e) {}
                }
            }
        }
        catch (ChimeraFsException e) {
            throw new CacheException(e.getMessage());
        }
        try {
            stat = inode.stat();
        }
        catch (ChimeraFsException hfe) {
            throw new CacheException(hfe.getMessage());
        }
        info.setFileSize(stat.getSize());
        info.setIsNew(stat.getSize() == 0L && !level2.exists());
        return info;
    }

    @Override
    public StorageInfo getDirStorageInfo(FsInode inode) throws CacheException {
        FsInode dirInode = null;
        dirInode = !inode.isDirectory() ? inode.getParent() : inode;
        try {
            String[] sGroup;
            HashMap<String, String> hash = new HashMap<String, String>();
            String store = null;
            String group = null;
            String[] OSMTemplate = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "OSMTemplate");
            if (OSMTemplate != null) {
                for (String line : OSMTemplate) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 2) continue;
                    hash.put(st.nextToken(), st.nextToken());
                }
                store = (String)hash.get("StoreName");
                if (store == null) {
                    throw new CacheException(37, "StoreName not found in template");
                }
            }
            if ((sGroup = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "sGroup")) != null) {
                group = sGroup[0].trim();
            }
            OSMStorageInfo info = new OSMStorageInfo(store, group);
            info.addKeys(hash);
            String[] accessLatency = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "AccessLatency");
            String[] retentionPolicy = ChimeraOsmStorageInfoExtractor.getTag(dirInode, "RetentionPolicy");
            if (accessLatency != null) {
                try {
                    info.setAccessLatency(AccessLatency.getAccessLatency((String)accessLatency[0].trim()));
                    info.isSetAccessLatency(true);
                }
                catch (IllegalArgumentException iae) {}
            } else {
                info.setAccessLatency(this.getDefaultAccessLatency());
            }
            if (retentionPolicy != null) {
                try {
                    info.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((String)retentionPolicy[0].trim()));
                    info.isSetRetentionPolicy(true);
                }
                catch (IllegalArgumentException iae) {}
            } else {
                info.setRetentionPolicy(this.getDefaultRetentionPolicy());
            }
            return info;
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }
}

