/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.HsmLocationExtractorFactory;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.namespace.ChimeraStorageInfoExtractable;
import org.dcache.chimera.store.InodeStorageInformation;

public abstract class ChimeraHsmStorageInfoExtractor
implements ChimeraStorageInfoExtractable {
    private final AccessLatency _defaultAccessLatency;
    private final RetentionPolicy _defaultRetentionPolicy;

    public ChimeraHsmStorageInfoExtractor(AccessLatency defaultAL, RetentionPolicy defaultRP) {
        this._defaultAccessLatency = defaultAL;
        this._defaultRetentionPolicy = defaultRP;
    }

    public final AccessLatency getDefaultAccessLatency() {
        return this._defaultAccessLatency;
    }

    public final RetentionPolicy getDefaultRetentionPolicy() {
        return this._defaultRetentionPolicy;
    }

    @Override
    public StorageInfo getStorageInfo(FsInode inode) throws CacheException {
        FsInode dirInode;
        StorageInfo info;
        if (!inode.exists()) {
            throw new FileNotFoundCacheException(inode.toString() + " does not exists");
        }
        if (inode.isDirectory()) {
            info = this.getDirStorageInfo(inode);
            dirInode = inode;
        } else {
            info = this.getFileStorageInfo(inode);
            dirInode = inode.getParent();
        }
        try {
            String[] spaceToken;
            String[] cacheClass;
            String[] hsmInstance = ChimeraHsmStorageInfoExtractor.getTag(dirInode, "hsmInstance");
            if (hsmInstance != null) {
                info.setHsm(hsmInstance[0].toLowerCase().trim());
            }
            if ((cacheClass = ChimeraHsmStorageInfoExtractor.getTag(dirInode, "cacheClass")) != null) {
                info.setCacheClass(cacheClass[0].trim());
            }
            if ((spaceToken = ChimeraHsmStorageInfoExtractor.getTag(dirInode, "WriteToken")) != null) {
                info.setKey("writeToken", spaceToken[0].trim());
            }
        }
        catch (IOException e) {
            throw new CacheException(37, "Unable to fetch tags: " + e.getMessage());
        }
        return info;
    }

    public abstract StorageInfo getFileStorageInfo(FsInode var1) throws CacheException;

    public abstract StorageInfo getDirStorageInfo(FsInode var1) throws CacheException;

    @Override
    public void setStorageInfo(FsInode inode, StorageInfo dCacheStorageInfo, int arg3) throws CacheException {
        try {
            if (dCacheStorageInfo.isSetAccessLatency()) {
                AccessLatency accessLatency = dCacheStorageInfo.getAccessLatency();
                inode.getFs().setAccessLatency(inode, accessLatency);
            }
            if (dCacheStorageInfo.isSetRetentionPolicy()) {
                RetentionPolicy retentionPolicy = dCacheStorageInfo.getRetentionPolicy();
                inode.getFs().setRetentionPolicy(inode, retentionPolicy);
            }
            if (dCacheStorageInfo.isSetAddLocation()) {
                List locationURIs = dCacheStorageInfo.locations();
                if (!locationURIs.isEmpty()) {
                    InodeStorageInformation storageInfo = new InodeStorageInformation(inode, dCacheStorageInfo.getHsm(), dCacheStorageInfo.getKey("store"), dCacheStorageInfo.getKey("group"));
                    inode.getFs().setStorageInfo(inode, storageInfo);
                }
                for (URI location : locationURIs) {
                    if (location.toString().isEmpty()) continue;
                    URI validatedUri = HsmLocationExtractorFactory.validate((URI)location);
                    inode.getFs().addInodeLocation(inode, 0, validatedUri.toString());
                }
            }
        }
        catch (FileNotFoundHimeraFsException e) {
            throw new FileNotFoundCacheException(e.getMessage());
        }
        catch (ChimeraFsException he) {
            throw new CacheException(he.getMessage());
        }
    }

    public static String[] getTag(FsInode dirInode, String tag) throws IOException {
        FsInode_TAG tagInode = new FsInode_TAG(dirInode.getFs(), dirInode.toString(), tag);
        if (!tagInode.exists()) {
            return null;
        }
        byte[] buff = new byte[256];
        int len = tagInode.read(0L, buff, 0, buff.length);
        if (len <= 0) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        CharArrayReader ca = new CharArrayReader(new String(buff, 0, len).toCharArray());
        BufferedReader br = new BufferedReader(ca);
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }
}

