/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.EnstoreStorageInfo;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.namespace.ChimeraHsmStorageInfoExtractor;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.InodeStorageInformation;

public class ChimeraEnstoreStorageInfoExtractor
extends ChimeraHsmStorageInfoExtractor {
    public ChimeraEnstoreStorageInfoExtractor(AccessLatency defaultAL, RetentionPolicy defaultRP) {
        super(defaultAL, defaultRP);
    }

    @Override
    public StorageInfo getFileStorageInfo(FsInode inode) throws CacheException {
        EnstoreStorageInfo info;
        Stat stat = null;
        FsInode level2 = new FsInode(inode.getFs(), inode.toString(), 2);
        try {
            List locations = inode.getFs().getInodeLocations(inode, 0);
            EnstoreStorageInfo parentStorageInfo = (EnstoreStorageInfo)this.getDirStorageInfo(inode);
            if (locations.isEmpty()) {
                RetentionPolicy rp;
                info = parentStorageInfo;
                AccessLatency al = inode.getFs().getAccessLatency(inode);
                if (al != null) {
                    info.setAccessLatency(AccessLatency.getAccessLatency((int)al.getId()));
                }
                if ((rp = inode.getFs().getRetentionPolicy(inode)) != null) {
                    info.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((int)rp.getId()));
                }
            } else {
                InodeStorageInformation inodeStorageInfo = inode.getFs().getSorageInfo(inode);
                info = new EnstoreStorageInfo(parentStorageInfo.getStorageGroup(), parentStorageInfo.getFileFamily());
                info.setIsNew(false);
                info.setAccessLatency(inodeStorageInfo.accessLatency());
                info.setRetentionPolicy(inodeStorageInfo.retentionPolicy());
                for (StorageLocatable location : locations) {
                    if (!location.isOnline()) continue;
                    try {
                        URI uri = new URI(location.location());
                        info.addLocation(uri);
                        for (String part : uri.getQuery().split("&")) {
                            String value;
                            String[] data = part.split("=");
                            String key = data[0];
                            String string = value = data.length == 2 ? data[1] : "";
                            if (key.equals("bfid")) {
                                info.setBitfileId(value);
                                continue;
                            }
                            if (key.equals("volume")) {
                                info.setVolume(value);
                                continue;
                            }
                            if (key.equals("location_cookie")) {
                                info.setLocation(value);
                                continue;
                            }
                            if (!key.equals("original_name")) continue;
                            info.setPath(value);
                        }
                    }
                    catch (URISyntaxException e) {
                    }
                }
            }
        }
        catch (ChimeraFsException e) {
            throw new CacheException(e.getMessage());
        }
        try {
            stat = inode.stat();
        }
        catch (ChimeraFsException hfe) {
            throw new CacheException(hfe.getMessage());
        }
        info.setFileSize(stat.getSize());
        info.setIsNew(stat.getSize() == 0L && !level2.exists());
        return info;
    }

    @Override
    public StorageInfo getDirStorageInfo(FsInode inode) throws CacheException {
        FsInode dirInode = !inode.isDirectory() ? inode.getParent() : inode;
        try {
            String ff;
            String sg;
            HashMap<String, String> hash = new HashMap<String, String>();
            String[] OSMTemplate = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "OSMTemplate");
            String[] group = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "storage_group");
            String[] family = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "file_family");
            String[] spaceToken = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "WriteToken");
            if (OSMTemplate != null) {
                for (String line : OSMTemplate) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.countTokens() < 2) continue;
                    hash.put(st.nextToken(), st.nextToken());
                }
            }
            sg = group == null || group.length == 0 || (sg = group[0].trim()).equals("") ? "none" : sg;
            ff = family == null || family.length == 0 || (ff = family[0].trim()).equals("") ? "none" : ff;
            EnstoreStorageInfo info = new EnstoreStorageInfo(sg, ff);
            info.addKeys(hash);
            String[] accessLatency = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "AccessLatency");
            String[] retentionPolicy = ChimeraEnstoreStorageInfoExtractor.getTag(dirInode, "RetentionPolicy");
            if (accessLatency != null) {
                try {
                    info.setAccessLatency(AccessLatency.getAccessLatency((String)accessLatency[0].trim()));
                    info.isSetAccessLatency(true);
                }
                catch (IllegalArgumentException iae) {}
            } else {
                info.setAccessLatency(this.getDefaultAccessLatency());
            }
            if (retentionPolicy != null) {
                try {
                    info.setRetentionPolicy(RetentionPolicy.getRetentionPolicy((String)retentionPolicy[0].trim()));
                    info.isSetRetentionPolicy(true);
                }
                catch (IllegalArgumentException iae) {}
            } else {
                info.setRetentionPolicy(this.getDefaultRetentionPolicy());
            }
            return info;
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }
}

