/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import com.jolbox.bonecp.BoneCPDataSource;
import diskCacheV111.util.Version;
import diskCacheV111.vehicles.PoolManagerPoolUpMessage;
import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.cells.MessageCallback;
import org.dcache.cells.Option;
import org.dcache.services.hsmcleaner.PoolInformationBase;
import org.dcache.services.hsmcleaner.RequestTracker;
import org.dcache.services.hsmcleaner.Sink;
import org.dcache.util.BroadcastRegistrationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class ChimeraCleaner
extends AbstractCell
implements Runnable {
    private static final Class<?> POOLUP_MESSAGE = PoolManagerPoolUpMessage.class;
    private static final Logger _log = LoggerFactory.getLogger(ChimeraCleaner.class);
    @Option(name="refresh", description="Refresh interval", required=true, unit="seconds")
    protected long _refreshInterval;
    @Option(name="recover", description="", required=true, unit="seconds")
    protected long _recoverTimer;
    @Option(name="poolTimeout", description="", required=true, unit="seconds")
    protected long _replyTimeout;
    @Option(name="processFilesPerRun", description="The number of files to process at once", required=true, unit="files")
    protected int _processAtOnce;
    @Option(name="reportRemove", description="The cell to report removes to", required=true)
    protected String _reportTo;
    @Option(name="hsmCleaner", description="Whether to enable the HSM cleaner", required=true)
    protected boolean _hsmCleanerEnabled;
    @Option(name="hsmCleanerRequest", description="Maximum number of files to include in a single request", required=true, unit="files")
    protected int _hsmCleanerRequest;
    @Option(name="hsmCleanerTimeout", description="Timeout in milliseconds for delete requests send to HSM-pools", required=true, unit="seconds")
    protected long _hsmTimeout;
    @Option(name="threads", description="Size of thread pool", required=true)
    protected int _threadPoolSize;
    private final ConcurrentHashMap<String, Long> _poolsBlackList = new ConcurrentHashMap();
    private RequestTracker _requests;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _cleanerTask;
    private PoolInformationBase _pools = new PoolInformationBase();
    private DataSource _dataSource;
    private JdbcTemplate _db;
    private BroadcastRegistrationTask _broadcastRegistration;
    private CellStub _broadcasterStub;
    private CellStub _poolStub;
    private static final String sqlGetPoolList = "SELECT DISTINCT ilocation FROM t_locationinfo_trash WHERE itype=1";
    private static final String sqlGetPoolsForFile = "SELECT ilocation FROM t_locationinfo_trash WHERE ipnfsid=? AND itype=1 ORDER BY iatime";
    private static final String sqlGetFileListForPool = "SELECT ipnfsid FROM t_locationinfo_trash WHERE ilocation=? ORDER BY iatime";
    private static final String sqlRemoveFiles = "DELETE FROM t_locationinfo_trash WHERE ilocation=? AND ipnfsid=? AND itype=1";
    private static final String sqlGetIlocationHSM = "SELECT ilocation FROM t_locationinfo_trash WHERE itype=0";
    public static final String hh_rundelete = " # run Cleaner ";
    public static final String hh_show_info = " # show info ";
    public static final String hh_ls_blacklist = " # list pools in the Black List";
    public static final String hh_remove_from_blacklist = "<poolName> # remove this pool from the Black List";
    public static final String hh_clean_file = "<pnfsID> # clean this file (file will be deleted from DISK)";
    public static final String hh_clean_pool = "<poolName> # clean this pool ";
    public static final String hh_set_refresh = "[<refreshTimeInSeconds>]";
    public static final String fh_set_refresh = "Alters refresh rate and triggers a new run. Maximum rate is every 5 seconds.";
    public static final String hh_set_processedAtOnce = "<processedAtOnce> # max number of files sent to pool for processing at once ";
    public static final String hh_rundelete_hsm = " # run HSM Cleaner";
    private static final String sqlGetILocationForFileHSM = "SELECT ilocation FROM t_locationinfo_trash WHERE ipnfsid=? AND itype=0 ORDER BY iatime";
    public static final String hh_clean_file_hsm = "<pnfsID> # clean this file on HSM (file will be deleted from HSM)";
    public static final String hh_hsm_set_MaxFilesPerRequest = "<number> # maximal number of concurrent requests to a single HSM";
    public static final String hh_hsm_set_TimeOut = "<seconds> # cleaning request timeout in seconds (for HSM-pools)";
    private static final String sqlRemoveHSMFiles = "DELETE FROM t_locationinfo_trash WHERE ilocation=? AND itype=0";

    public ChimeraCleaner(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        this.doInit();
    }

    protected void init() throws Exception {
        this.useInterpreter(true);
        this._executor = Executors.newScheduledThreadPool(this._threadPoolSize);
        this.dbInit(this.getArgs().getOpt("chimera.db.url"), this.getArgs().getOpt("chimera.db.driver"), this.getArgs().getOpt("chimera.db.user"), this.getArgs().getOpt("chimera.db.password"));
        if (!this._reportTo.equals("none")) {
            this._broadcasterStub = new CellStub();
            this._broadcasterStub.setCellEndpoint((CellEndpoint)this);
            this._broadcasterStub.setDestination(this._reportTo);
        }
        if (this._hsmCleanerEnabled) {
            this._requests = new RequestTracker();
            this._requests.setMaxFilesPerRequest(this._hsmCleanerRequest);
            this._requests.setTimeout(this._hsmTimeout * 1000L);
            this._requests.setPoolStub(new CellStub((CellEndpoint)this));
            this._requests.setPoolInformationBase(this._pools);
            this._requests.setSuccessSink((Sink)new Sink<URI>(){

                public void push(final URI uri) {
                    ChimeraCleaner.this._executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ChimeraCleaner.this.onSuccess(uri);
                        }
                    });
                }
            });
            this._requests.setFailureSink((Sink)new Sink<URI>(){

                public void push(final URI uri) {
                    ChimeraCleaner.this._executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ChimeraCleaner.this.onFailure(uri);
                        }
                    });
                }
            });
            this.addMessageListener(this._requests);
            this.addCommandListener(this._requests);
        }
        this.addMessageListener(this._pools);
        this.addCommandListener(this._pools);
        this._poolStub = new CellStub();
        this._poolStub.setCellEndpoint((CellEndpoint)this);
        this._poolStub.setTimeout(this._replyTimeout * 1000L);
        CellPath me = new CellPath(this.getCellName(), this.getCellDomainName());
        this._broadcastRegistration = new BroadcastRegistrationTask((CellEndpoint)this, POOLUP_MESSAGE, me);
        this._executor.scheduleAtFixedRate((Runnable)this._broadcastRegistration, 0L, 5L, TimeUnit.MINUTES);
        this._cleanerTask = this._executor.scheduleWithFixedDelay(this, this._refreshInterval, this._refreshInterval, TimeUnit.SECONDS);
    }

    void dbInit(String jdbcUrl, String jdbcClass, String user, String pass) throws SQLException, ClassNotFoundException {
        if (jdbcUrl == null || jdbcClass == null || user == null || pass == null) {
            throw new IllegalArgumentException("Not enough arguments to Init SQL database");
        }
        Class.forName(jdbcClass);
        BoneCPDataSource ds = new BoneCPDataSource();
        ds.setJdbcUrl(jdbcUrl);
        ds.setUsername(user);
        ds.setPassword(pass);
        ds.setIdleConnectionTestPeriodInMinutes(60L);
        ds.setIdleMaxAgeInMinutes(240L);
        ds.setMaxConnectionsPerPartition(30);
        ds.setMaxConnectionsPerPartition(10);
        ds.setPartitionCount(3);
        ds.setAcquireIncrement(5);
        ds.setStatementsCacheSize(100);
        ds.setReleaseHelperThreads(3);
        this._dataSource = ds;
        this._db = new JdbcTemplate(this._dataSource);
        _log.info("Database connection with jdbcUrl={}; user={}", (Object)jdbcUrl, (Object)user);
    }

    public void cleanUp() {
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
    }

    @Override
    public void run() {
        try {
            _log.info("*********NEW_RUN*************");
            if (_log.isDebugEnabled()) {
                _log.debug("INFO: Refresh Interval (seconds): " + this._refreshInterval);
                _log.debug("INFO: Number of files processed at once: " + this._processAtOnce);
            }
            List<String> poolList = this.getPoolList();
            if (_log.isDebugEnabled()) {
                _log.debug("List of Pools from the trash-table : " + poolList);
            }
            if (this._poolsBlackList.size() > 0) {
                _log.debug("htBlackPools.size()=" + this._poolsBlackList.size());
                for (Map.Entry<String, Long> blackListEntry : this._poolsBlackList.entrySet()) {
                    String poolName = blackListEntry.getKey();
                    long valueTime = blackListEntry.getValue();
                    if (valueTime == 0L || this._recoverTimer <= 0L || System.currentTimeMillis() - valueTime <= this._recoverTimer * 1000L) continue;
                    this._poolsBlackList.remove(poolName);
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug("Remove the following pool from the Black List : " + poolName);
                }
                poolList.removeAll(this._poolsBlackList.keySet());
            }
            if (!poolList.isEmpty()) {
                _log.debug("The following pools are sent to runDelete(..): {}", poolList);
                this.runDelete(poolList);
            }
            if (this._hsmCleanerEnabled) {
                this.runDeleteHSM();
            }
        }
        catch (DataAccessException e) {
            _log.error("Database failure: " + e.getMessage());
        }
        catch (InterruptedException e) {
            _log.info("Cleaner was interrupted");
        }
        catch (RuntimeException e) {
            _log.error("Bug detected", (Throwable)e);
        }
    }

    List<String> getPoolList() {
        return this._db.query(sqlGetPoolList, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("ilocation");
            }
        });
    }

    void removeFiles(final String poolname, final List<String> filelist) {
        this.informBroadcaster(filelist);
        this._db.batchUpdate(sqlRemoveFiles, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return filelist.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, poolname);
                ps.setString(2, (String)filelist.get(i));
            }
        });
    }

    private void runDelete(List<String> poolList) throws InterruptedException {
        for (String pool : poolList) {
            if (Thread.interrupted()) {
                throw new InterruptedException("Cleaner interrupted");
            }
            _log.info("runDelete(): Now processing pool {}", (Object)pool);
            if (this._poolsBlackList.containsKey(pool)) continue;
            this.cleanPoolComplete(pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRemoveToPoolCleaner(String poolName, List<String> removeList) throws InterruptedException {
        RemoveMessageCallback callback;
        if (_log.isDebugEnabled()) {
            _log.debug("sendRemoveToPoolCleaner: poolName=" + poolName);
            _log.debug("sendRemoveToPoolCleaner: removeList=" + removeList);
        }
        PoolRemoveFilesMessage msg = new PoolRemoveFilesMessage(poolName);
        msg.setFiles(removeList.toArray(new String[0]));
        RemoveMessageCallback removeMessageCallback = callback = new RemoveMessageCallback(poolName, removeList);
        synchronized (removeMessageCallback) {
            this._poolStub.send(new CellPath(poolName), (Serializable)msg, PoolRemoveFilesMessage.class, (MessageCallback)callback);
            ((Object)((Object)callback)).wait(this._replyTimeout * 1000L);
        }
    }

    public void messageArrived(PoolManagerPoolUpMessage poolUpMessage) {
        String poolName = poolUpMessage.getPoolName();
        if (poolUpMessage.getPoolMode().isEnabled()) {
            this._poolsBlackList.remove(poolName);
        }
        if (poolUpMessage.getPoolMode().isDisabled()) {
            this._poolsBlackList.putIfAbsent(poolName, System.currentTimeMillis());
        }
    }

    void cleanPoolComplete(final String poolName) {
        _log.trace("CleanPoolComplete(): poolname={}", (Object)poolName);
        this._db.query(sqlGetFileListForPool, new Object[]{poolName}, new RowCallbackHandler(){
            List<String> files;
            {
                this.files = new ArrayList<String>(ChimeraCleaner.this._processAtOnce);
            }

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    this.files.add(rs.getString("ipnfsid"));
                    if (this.files.size() >= ChimeraCleaner.this._processAtOnce || rs.isLast()) {
                        ChimeraCleaner.this.sendRemoveToPoolCleaner(poolName, this.files);
                        this.files.clear();
                    }
                }
                catch (InterruptedException e) {
                    throw new TransientDataAccessResourceException("Cleaner was interrupted", (Throwable)e);
                }
            }
        });
    }

    private void informBroadcaster(List<String> fileList) {
        if (fileList.isEmpty() || this._broadcasterStub == null) {
            return;
        }
        try {
            PoolRemoveFilesMessage msg = new PoolRemoveFilesMessage("");
            msg.setFiles(fileList.toArray(new String[0]));
            msg.setReplyRequired(false);
            this._broadcasterStub.send((Serializable)msg);
            _log.debug("have broadcasted 'remove files' message to " + this._broadcasterStub.getDestinationPath());
        }
        catch (NoRouteToCellException e) {
            _log.debug("Failed to broadcast 'remove files' message: " + e.getMessage());
        }
    }

    List<String> getHsmLocations() {
        return this._db.query(sqlGetIlocationHSM, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("ilocation");
            }
        });
    }

    private void runDeleteHSM() {
        this._db.query(sqlGetIlocationHSM, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    URI uri = new URI(rs.getString("ilocation"));
                    _log.debug("Submitting a request to delete a file: {}", (Object)uri);
                    ChimeraCleaner.this._requests.submit(uri);
                }
                catch (URISyntaxException e) {
                    throw new DataIntegrityViolationException("Invalid URI in database: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public String ac_rundelete(Args args) throws InterruptedException {
        this.runDelete(this.getPoolList());
        return "";
    }

    public String ac_show_info(Args args) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Refresh Interval (sec) : ").append(this._refreshInterval).append("\n");
        sb.append("Reply Timeout (sec): ").append(this._replyTimeout).append("\n");
        sb.append("Recover Timer (min): ").append(this._recoverTimer / 60L).append("\n");
        sb.append("Number of files processed at once: ").append(this._processAtOnce);
        if (this._hsmCleanerEnabled) {
            sb.append("\n HSM Cleaner enabled. Info : \n");
            sb.append("Timeout for cleaning requests to HSM-pools (sec): ").append(this._hsmTimeout).append("\n");
            sb.append("Maximal number of concurrent requests to a single HSM : ").append(this._hsmCleanerRequest);
        } else {
            sb.append("\n HSM Cleaner disabled.");
        }
        return sb.toString();
    }

    public String ac_ls_blacklist(Args args) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String pool : this._poolsBlackList.keySet()) {
            sb.append(pool).append("\n");
        }
        return sb.toString();
    }

    public String ac_remove_from_blacklist_$_1(Args args) throws Exception {
        String poolName = args.argv(0);
        if (this._poolsBlackList.remove(poolName) != null) {
            return "Pool " + poolName + " is removed from the Black List ";
        }
        return "Pool " + poolName + " was not found in the Black List ";
    }

    public String ac_clean_file_$_1(Args args) {
        final String pnfsid = args.argv(0);
        this._db.query(sqlGetPoolsForFile, new Object[]{pnfsid}, new RowCallbackHandler(){
            List<String> removeFile;
            {
                this.removeFile = Collections.singletonList(pnfsid);
            }

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    String pool = rs.getString("ilocation");
                    ChimeraCleaner.this.sendRemoveToPoolCleaner(pool, this.removeFile);
                }
                catch (InterruptedException e) {
                    throw new TransientDataAccessResourceException("Cleaner was interrupted", (Throwable)e);
                }
            }
        });
        return "";
    }

    public String ac_clean_pool_$_1(Args args) throws Exception {
        String poolName = args.argv(0);
        if (!this._poolsBlackList.containsKey(poolName)) {
            this.cleanPoolComplete(poolName);
            return "";
        }
        return "This pool is not available for the moment and therefore will not be cleaned.";
    }

    public String ac_set_refresh_$_0_1(Args args) {
        if (args.argc() > 0) {
            long newRefresh = Long.parseLong(args.argv(0));
            if (newRefresh < 5L) {
                throw new IllegalArgumentException("Time must be greater than 5 seconds");
            }
            this._refreshInterval = newRefresh;
            if (this._cleanerTask != null) {
                this._cleanerTask.cancel(true);
            }
            this._cleanerTask = this._executor.scheduleWithFixedDelay(this, 0L, this._refreshInterval, TimeUnit.SECONDS);
        }
        return "Refresh set to " + this._refreshInterval + " seconds";
    }

    public String ac_set_processedAtOnce_$_1(Args args) throws Exception {
        if (args.argc() > 0) {
            int processAtOnce = Integer.valueOf(args.argv(0));
            if (processAtOnce == 0) {
                throw new IllegalArgumentException("Number of files must be greater than 0 ");
            }
            this._processAtOnce = processAtOnce;
        }
        return "Number of files processed at once set to " + this._processAtOnce;
    }

    public String ac_rundelete_hsm(Args args) throws Exception {
        if (!this._hsmCleanerEnabled) {
            return "HSM Cleaner is disabled.";
        }
        this.runDeleteHSM();
        return "";
    }

    public String ac_clean_file_hsm_$_1(Args args) {
        if (!this._hsmCleanerEnabled) {
            return "HSM Cleaner is disabled.";
        }
        this._db.query(sqlGetILocationForFileHSM, new Object[]{args.argv(0)}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                try {
                    ChimeraCleaner.this._requests.submit(new URI(rs.getString("ilocation")));
                }
                catch (URISyntaxException e) {
                    throw new DataIntegrityViolationException("Invalid URI in database: " + e.getMessage(), (Throwable)e);
                }
            }
        });
        return "";
    }

    public String ac_hsm_set_MaxFilesPerRequest_$_1(Args args) throws NumberFormatException {
        if (this._hsmCleanerEnabled) {
            if (args.argc() > 0) {
                int maxFilesPerRequest = Integer.valueOf(args.argv(0));
                if (maxFilesPerRequest == 0) {
                    throw new IllegalArgumentException("The number must be greater than 0 ");
                }
                this._hsmCleanerRequest = maxFilesPerRequest;
            }
            return "Maximal number of concurrent requests to a single HSM is set to " + this._hsmCleanerRequest;
        }
        return "HSM Cleaner is disabled.";
    }

    public String ac_hsm_set_TimeOut_$_1(Args args) throws NumberFormatException {
        if (this._hsmCleanerEnabled) {
            if (args.argc() > 0) {
                long timeOutHSM;
                this._hsmTimeout = timeOutHSM = Long.valueOf(args.argv(0)).longValue();
            }
            return "Timeout for cleaning requests to HSM-pools is set to " + this._hsmTimeout + " seconds";
        }
        return "HSM Cleaner is disabled.";
    }

    public CellVersion getCellVersion() {
        return new CellVersion(Version.getVersion(), "$Revision: 1.23 $");
    }

    public void getInfo(PrintWriter pw) {
        pw.println("ChimeraCleaner $Revision: 1.23 $");
    }

    protected void onSuccess(URI uri) {
        try {
            _log.debug("HSM-ChimeraCleaner: remove entries from the trash-table. ilocation={}", (Object)uri);
            this._db.update(sqlRemoveHSMFiles, new Object[]{uri.toString()});
        }
        catch (DataAccessException e) {
            _log.error("Error when deleting from the trash-table: " + e.getMessage());
        }
    }

    protected void onFailure(URI uri) {
        _log.info("Failed to delete a file {} from HSM. Will try again later.", (Object)uri);
    }

    private class RemoveMessageCallback
    extends AbstractMessageCallback<PoolRemoveFilesMessage> {
        private final String _poolName;
        private final List<String> _filesToRemove;

        RemoveMessageCallback(String poolName, List<String> filesToRemove) {
            this._poolName = poolName;
            this._filesToRemove = filesToRemove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void success(PoolRemoveFilesMessage message) {
            try {
                ChimeraCleaner.this.removeFiles(this._poolName, this._filesToRemove);
            }
            finally {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void failure(int rc, Object o) {
            try {
                if (o instanceof String[]) {
                    HashSet<String> notRemoved = new HashSet<String>(Arrays.asList((String[])o));
                    ArrayList<String> removed = new ArrayList<String>(this._filesToRemove);
                    removed.removeAll(notRemoved);
                    ChimeraCleaner.this.removeFiles(this._poolName, removed);
                }
            }
            finally {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void noroute(CellPath path) {
            try {
                _log.warn("Pool {} is down.", (Object)this._poolName);
                ChimeraCleaner.this._poolsBlackList.put(this._poolName, System.currentTimeMillis());
            }
            finally {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void timeout(CellPath path) {
            try {
                _log.warn("remove message to {} timed out.", (Object)this._poolName);
                ChimeraCleaner.this._poolsBlackList.put(this._poolName, System.currentTimeMillis());
            }
            finally {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }
}

