/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.namespace;

import diskCacheV111.vehicles.CacheStatistics;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.posix.Stat;

public class ChimeraCacheInfo
implements Serializable {
    private static final long serialVersionUID = -2625909340883039244L;
    private CacheStatistics _cacheStatistics;
    private final List<String> _cacheLocations = new ArrayList<String>();
    private CacheFlags _cacheFlags = null;

    public CacheFlags getFlags() {
        return this._cacheFlags;
    }

    private void readCacheInfo(BufferedReader file) throws IOException {
        this._cacheFlags = new CacheFlags();
        String line = file.readLine();
        if (line == null) {
            this._cacheStatistics = new CacheStatistics();
            return;
        }
        this._cacheStatistics = new CacheStatistics(line);
        while ((line = file.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.charAt(0) == ':') {
                if (line.length() <= 1) continue;
                this._cacheFlags.addLine(line.substring(1));
                continue;
            }
            this._cacheLocations.add(line);
        }
        this._cacheFlags.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheInfo(FsInode inode) throws IOException {
        this._cacheStatistics.setVersion(2);
        CharArrayWriter cw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(cw);
        try {
            pw.println(this._cacheStatistics.toPnfsString());
            pw.println(this._cacheFlags.toPnfsString());
            for (String location : this._cacheLocations) {
                pw.println(location);
            }
        }
        finally {
            pw.close();
        }
        byte[] buff = cw.toString().getBytes();
        inode.write(0L, buff, 0, buff.length);
    }

    public void addCacheLocation(String location) {
        this._cacheLocations.add(location);
    }

    public boolean clearCacheLocation(String location) {
        return this._cacheLocations.remove(location);
    }

    public List<String> getCacheLocations() {
        return this._cacheLocations;
    }

    public CacheStatistics getCacheStatistics() {
        return this._cacheStatistics;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._cacheStatistics.toString());
        for (String location : this._cacheLocations) {
            sb.append(" ").append(location);
        }
        return sb.toString();
    }

    public void setCacheStatistics(CacheStatistics cs) {
        this._cacheStatistics = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChimeraCacheInfo(FsInode inode) throws ChimeraFsException, IOException {
        byte[] buff = null;
        int len = 0;
        try {
            Stat stat = inode.stat();
            buff = new byte[(int)stat.getSize()];
            len = inode.read(0L, buff, 0, buff.length);
        }
        catch (FileNotFoundHimeraFsException fnf) {
            buff = new byte[]{};
        }
        CharArrayReader ca = new CharArrayReader(new String(buff, 0, len).toCharArray());
        BufferedReader br = new BufferedReader(ca);
        try {
            this.readCacheInfo(br);
        }
        finally {
            br.close();
        }
    }

    public static class CacheFlags
    implements Serializable {
        static final long serialVersionUID = -5709322056371005585L;
        private final Map<String, String> _hash = new HashMap<String, String>();
        private final StringBuilder _inputLine = new StringBuilder();

        private void addLine(String line) {
            this._inputLine.append(line);
        }

        private void commit() {
            StringTokenizer st = new StringTokenizer(this._inputLine.toString(), ";");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                int l = t.length();
                if (l == 0) continue;
                int i = t.indexOf(61);
                if (i < 0 || i == l - 1) {
                    this._hash.put(t, "");
                    continue;
                }
                if (i <= 0) continue;
                this._hash.put(t.substring(0, i), t.substring(i + 1));
            }
        }

        public String get(String key) {
            return this._hash.get(key);
        }

        public String remove(String key) {
            return this._hash.remove(key);
        }

        public void put(String key, String value) {
            this._hash.put(key, value);
        }

        public Set<Map.Entry<String, String>> entrySet() {
            return this._hash.entrySet();
        }

        private String toPnfsString() {
            StringBuilder sb = new StringBuilder();
            int l = 0;
            sb.append(":");
            for (Map.Entry<String, String> entry : this._hash.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
                if (sb.length() - l <= 70) continue;
                l = sb.length();
                sb.append("\n:");
            }
            return sb.toString();
        }

        public String toString() {
            return this.toPnfsString();
        }
    }
}

