/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javatunnel.Convertable;

class TunnelInputStream
extends InputStream {
    private InputStream _in = null;
    private Convertable _converter = null;
    private byte[] _buffer = null;
    int _pos = 0;

    public TunnelInputStream(InputStream in, Convertable converter) {
        this._in = in;
        this._converter = converter;
    }

    @Override
    public int read() throws IOException {
        if (this._buffer == null || this._pos >= this._buffer.length) {
            try {
                this._buffer = this._converter.decode(this._in);
            }
            catch (EOFException e) {
                return -1;
            }
            this._pos = 0;
        }
        byte b = this._buffer[this._pos];
        ++this._pos;
        return b;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }
}

