/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javatunnel.Base64;
import javatunnel.Convertable;
import javatunnel.UserBindible;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TunnelConverter
implements Convertable,
UserBindible {
    private static final Logger _log = LoggerFactory.getLogger(TunnelConverter.class);
    private boolean _isAuthentificated = false;
    private static final int IO_BUFFER_SIZE = 0x100000;

    TunnelConverter() {
    }

    @Override
    public void encode(byte[] buf, int len, OutputStream out) throws IOException {
        byte[] realBytes = new byte[len];
        System.arraycopy(buf, 0, realBytes, 0, len);
        String outData = "enc " + Base64.byteArrayToBase64(realBytes);
        out.write(outData.getBytes());
        out.write(10);
    }

    @Override
    public byte[] decode(InputStream in) throws IOException {
        int c;
        byte[] buf = new byte[0x100000];
        int total = 0;
        do {
            if ((c = in.read()) < 0) {
                throw new EOFException("Remote end point has closed connection");
            }
            buf[total] = (byte)c;
            ++total;
        } while (c != 10 && c != 13);
        if (total < 5) {
            throw new IOException("short read: " + total + new String(buf, 0, total));
        }
        return Base64.base64ToByteArray(new String(buf, 4, total - 5));
    }

    @Override
    public boolean auth(InputStream in, OutputStream out, Object addon) {
        if (this._isAuthentificated) {
            return true;
        }
        try {
            PrintStream os = null;
            Object is = null;
            os = new PrintStream(out);
            String secret = "xxx >> SECRET << xxxx";
            os.println(secret);
        }
        catch (Exception e) {
            _log.error("failed auth", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean verify(InputStream in, OutputStream out, Object addon) {
        try {
            DataInputStream is = null;
            is = new DataInputStream(in);
            System.out.println(is.readLine());
        }
        catch (IOException e) {
            _log.error("verify failed", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Convertable makeCopy() throws IOException {
        return this;
    }

    @Override
    public Subject getSubject() {
        return new Subject();
    }
}

