/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javatunnel.Convertable;
import javatunnel.GssTunnel;
import javatunnel.TunnelServerSocketCreator;
import javatunnel.TunnelSocket;
import javax.net.ServerSocketFactory;

class SelfTest {
    SelfTest() {
    }

    public static void main(String[] args) throws Exception {
        int port = 1717;
        String host = "localhost";
        Reciever r = new Reciever(port);
        r.start();
        Sender s = new Sender(host, port);
        s.start();
    }

    private static class Reciever
    extends Thread {
        private int _port;

        Reciever(int port) {
            super("Reciever");
            this._port = port;
        }

        @Override
        public void run() {
            ServerSocket server = null;
            Socket s = null;
            OutputStream out = null;
            InputStream in = null;
            PrintStream os = null;
            DataInputStream is = null;
            try {
                String[] initArgs = new String[]{"javatunnel.GssTunnel", "nfs/anahit.desy.de@DESY.DE"};
                TunnelServerSocketCreator factory = new TunnelServerSocketCreator(initArgs);
                server = ((ServerSocketFactory)factory).createServerSocket();
                server.bind(new InetSocketAddress(this._port));
                s = server.accept();
                TunnelSocket ts = (TunnelSocket)s;
                ts.verify();
                System.out.println(ts.getSubject());
                out = s.getOutputStream();
                in = s.getInputStream();
                os = new PrintStream(out);
                is = new DataInputStream(in);
            }
            catch (Throwable e) {
                System.out.println(e);
                e.printStackTrace();
                return;
            }
            while (!Thread.interrupted()) {
                try {
                    System.out.println(" RECIVER Got : " + is.readLine());
                    System.out.println(" RECIVER to sender : What?!");
                    os.println("What?!");
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    private static class Sender
    extends Thread {
        private String _host;
        private int _port;

        Sender(String host, int port) {
            super("Sender");
            this._port = port;
            this._host = host;
        }

        @Override
        public void run() {
            OutputStream out = null;
            InputStream in = null;
            PrintStream os = null;
            DataInputStream is = null;
            try {
                TunnelSocket s = new TunnelSocket(this._host, this._port, (Convertable)new GssTunnel("tigran@DESY.DE", "nfs/anahit.desy.de@DESY.DE"));
                Thread.sleep(20000L);
                out = ((Socket)s).getOutputStream();
                in = ((Socket)s).getInputStream();
                os = new PrintStream(out);
                is = new DataInputStream(in);
            }
            catch (Exception e) {
                System.out.println(e);
                return;
            }
            while (!Thread.interrupted()) {
                try {
                    System.out.println(" Sender to reciver : Hello tunnel");
                    os.println("Hello tunnel");
                    System.out.println(" Sender Got : " + is.readLine());
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    break;
                }
            }
        }
    }
}

