/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import javatunnel.Convertable;
import javatunnel.TunnelConverter;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GssTunnel
extends TunnelConverter {
    private static final Logger _log = LoggerFactory.getLogger(GssTunnel.class);
    private GSSManager _gManager = null;
    protected GSSContext _context = null;
    private GSSCredential _myCredential = null;
    private GSSCredential _userCredential = null;
    protected GSSName _userPrincipal = null;
    protected GSSName _myPrincipal = null;
    protected GSSName _peerPrincipal = null;
    private boolean _authDone = false;
    MessageProp _prop = new MessageProp(true);
    private String _principalStr = null;
    private boolean _useChannelBinding = true;

    protected GssTunnel() {
    }

    public GssTunnel(String principalStr) {
        this._principalStr = principalStr;
    }

    public GssTunnel(String principalStr, boolean init) throws GSSException {
        if (init) {
            Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
            this._gManager = GSSManager.getInstance();
            this._myPrincipal = this._gManager.createName(principalStr, null);
            this._myCredential = this._gManager.createCredential(this._myPrincipal, Integer.MAX_VALUE, krb5Mechanism, 2);
            this._context = this._gManager.createContext(this._myCredential);
        }
    }

    public GssTunnel(String principalStr, String peerName) throws GSSException {
        Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
        this._gManager = GSSManager.getInstance();
        this._myPrincipal = this._gManager.createName(principalStr, null);
        this._myCredential = this._gManager.createCredential(this._myPrincipal, 0, krb5Mechanism, 1);
        this._peerPrincipal = this._gManager.createName(peerName, null);
        this._context = this._gManager.createContext(this._peerPrincipal, krb5Mechanism, this._myCredential, 0);
    }

    protected void useChannelBinding(boolean use) {
        this._useChannelBinding = use;
    }

    @Override
    public byte[] decode(InputStream in) throws IOException {
        byte[] retValue = super.decode(in);
        if (this._authDone) {
            try {
                retValue = this._context.unwrap(retValue, 0, retValue.length, this._prop);
            }
            catch (GSSException ge) {
                throw new IOException("Failed to unwrap message: " + ge.getMessage());
            }
        }
        return retValue;
    }

    @Override
    public void encode(byte[] buf, int len, OutputStream out) throws IOException {
        byte[] nb = null;
        int nlen = 0;
        if (this._authDone) {
            try {
                nb = this._context.wrap(buf, 0, len, this._prop);
            }
            catch (GSSException ge) {
                throw new IOException(ge.getMessage());
            }
            nlen = nb.length;
        } else {
            nb = buf;
            nlen = len;
        }
        super.encode(nb, nlen, out);
    }

    @Override
    public boolean auth(InputStream in, OutputStream out, Object addon) {
        boolean established = false;
        try {
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            Socket socket = (Socket)addon;
            this._context.requestMutualAuth(true);
            if (this._useChannelBinding) {
                ChannelBinding cb = new ChannelBinding(socket.getInetAddress(), InetAddress.getLocalHost(), null);
                this._context.setChannelBinding(cb);
            }
            while (!established) {
                outToken = this._context.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    this.encode(outToken, outToken.length, out);
                }
                if (!this._context.isEstablished()) {
                    inToken = this.decode(in);
                    continue;
                }
                established = true;
            }
        }
        catch (Exception e) {
            _log.error("Failed to authenticate", (Throwable)e);
        }
        this._authDone = established;
        return established;
    }

    @Override
    public boolean verify(InputStream in, OutputStream out, Object addon) {
        try {
            byte[] inToken = null;
            byte[] outToken = null;
            Socket socket = (Socket)addon;
            if (this._useChannelBinding) {
                ChannelBinding cb = new ChannelBinding(socket.getInetAddress(), InetAddress.getLocalHost(), null);
                this._context.setChannelBinding(cb);
            }
            while (!this._context.isEstablished()) {
                inToken = this.decode(in);
                outToken = this._context.acceptSecContext(inToken, 0, inToken.length);
                if (outToken == null) continue;
                this.encode(outToken, outToken.length, out);
            }
            this._userPrincipal = this._context.getSrcName();
        }
        catch (EOFException e) {
            _log.debug("connection closed");
        }
        catch (IOException e) {
            _log.error("Failed to verify: {}", (Object)e.toString());
        }
        catch (GSSException e) {
            _log.error("Failed to verify: {}", (Object)e.toString());
        }
        this._authDone = this._context.isEstablished();
        return this._authDone;
    }

    @Override
    public Subject getSubject() {
        HashSet<KerberosPrincipal> pricipals = new HashSet<KerberosPrincipal>();
        try {
            pricipals.add(new KerberosPrincipal(((Object)this._context.getSrcName()).toString()));
        }
        catch (GSSException e) {
            _log.error("Failed to create a kerberos principal:", (Throwable)e);
        }
        return new Subject(false, pricipals, Collections.EMPTY_SET, Collections.EMPTY_SET);
    }

    @Override
    public Convertable makeCopy() throws IOException {
        try {
            return new GssTunnel(this._principalStr, true);
        }
        catch (GSSException e) {
            throw new IOException(e);
        }
    }
}

