/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Iterator;
import javatunnel.Convertable;
import javatunnel.GssTunnel;
import javax.security.auth.Subject;
import org.dcache.auth.FQANPrincipal;
import org.dcache.gplazma.util.CertificateUtils;
import org.dcache.util.Files;
import org.glite.voms.FQAN;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GsiTunnel
extends GssTunnel {
    private static final Logger _log = LoggerFactory.getLogger(GsiTunnel.class);
    private ExtendedGSSContext _e_context = null;
    private static final String service_key = "/etc/grid-security/hostkey.pem";
    private static final String service_cert = "/etc/grid-security/hostcert.pem";
    private static final String service_trusted_certs = "/etc/grid-security/certificates";
    private Subject _subject = new Subject();

    public GsiTunnel(String dummy) throws GSSException, IOException {
        this(dummy, true);
    }

    public GsiTunnel(String dummy, boolean init) throws GSSException, IOException {
        if (init) {
            GlobusCredential serviceCredential;
            Files.checkFile((String)service_key);
            Files.checkFile((String)service_cert);
            Files.checkDirectory((String)service_trusted_certs);
            try {
                serviceCredential = new GlobusCredential(service_cert, service_key);
            }
            catch (GlobusCredentialException e) {
                throw new GSSException(13, 0, e.getMessage());
            }
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(serviceCredential, 2);
            TrustedCertificates trusted_certs = TrustedCertificates.load((String)service_trusted_certs);
            GSSManager manager = ExtendedGSSManager.getInstance();
            this._e_context = (ExtendedGSSContext)manager.createContext((GSSCredential)cred);
            this._e_context.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            this._e_context.setOption(GSSConstants.TRUSTED_CERTIFICATES, (Object)trusted_certs);
            this._context = this._e_context;
            super.useChannelBinding(false);
        }
    }

    @Override
    public boolean verify(InputStream in, OutputStream out, Object addon) {
        try {
            if (super.verify(in, out, addon)) {
                this._subject.getPrincipals().add((Principal)new GlobusPrincipal(((Object)this._e_context.getSrcName()).toString()));
                this.scanExtendedAttributes(this._e_context);
            }
        }
        catch (GSSException e) {
            _log.error("Failed to verify: {}", (Object)e.toString());
        }
        return this._context.isEstablished();
    }

    @Override
    public Convertable makeCopy() throws IOException {
        try {
            return new GsiTunnel(null, true);
        }
        catch (GSSException e) {
            throw new IOException(e);
        }
    }

    private void scanExtendedAttributes(ExtendedGSSContext gssContext) {
        try {
            Iterator fqans = CertificateUtils.getFQANsFromGSSContext((ExtendedGSSContext)gssContext).iterator();
            boolean primary = true;
            while (fqans.hasNext()) {
                String fqanValue = (String)fqans.next();
                FQAN fqan = new FQAN(fqanValue);
                String group = fqan.getGroup();
                String role = fqan.getRole();
                String s = role == null || role.equals("") ? group : group + "/Role=" + role;
                this._subject.getPrincipals().add((Principal)new FQANPrincipal(s, primary));
                primary = false;
            }
        }
        catch (AuthorizationException e) {
            _log.error("Failed to get users group and role context: {}", (Object)e.toString());
        }
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }
}

