/*
 * Decompiled with CFR 0.152.
 */
package javatunnel;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class Args
implements Serializable {
    private Hashtable _optHash = new Hashtable();
    private Vector _optv = new Vector();
    private Vector _argv = new Vector();
    private String _oneChar = null;
    private static final int IDLE = 0;
    private static final int PLAIN_STRING = 1;
    private static final int QUOTED_STRING = 2;
    private static final int OPT_KEY = 3;
    private static final int OPT_VALUE = 4;
    private static final int OPT_QUOTED = 5;
    private static final int OPT_PLAIN = 6;
    private boolean _undo = false;
    private char _res = '\u0000';
    private int _current = 0;
    private String _line = null;
    private static final char END_OF_INFO = '\uffff';

    public Args(String args) {
        this.scanLine(args);
    }

    public Args(String[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]).append(" ");
        }
        this.scanLine(sb.toString());
    }

    Args(Args in) {
        this._argv = (Vector)in._argv.clone();
        this._optv = (Vector)in._optv.clone();
        this._optHash = (Hashtable)in._optHash.clone();
        this._line = in._line;
    }

    public boolean isOneCharOption(char c) {
        return this._oneChar.indexOf(c) > -1;
    }

    public int argc() {
        return this._argv.size();
    }

    public int optc() {
        return this._optv.size();
    }

    public String getOpt(String optName) {
        return (String)this._optHash.get(optName);
    }

    public String argv(int i) {
        try {
            return this._argv.elementAt(i).toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public String optv(int i) {
        try {
            return (String)this._optv.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void shift() {
        try {
            this._argv.removeElementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Dictionary options() {
        return this._optHash;
    }

    public String toString() {
        return this._line;
    }

    public String getInfo() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("Positional :\n");
        for (i = 0; i < this._argv.size(); ++i) {
            sb.append(i).append(" -> ").append(this._argv.elementAt(i)).append("\n");
        }
        sb.append("Options :\n");
        for (i = 0; i < this._optv.size(); ++i) {
            String key = (String)this._optv.elementAt(i);
            String val = (String)this._optHash.get(key);
            sb.append(key);
            if (val != null) {
                sb.append(" -> ").append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void undo(char r) {
        this._res = r;
        this._undo = true;
    }

    private char nextChar() {
        if (this._undo) {
            this._undo = false;
            return this._res;
        }
        return this._current >= this._line.length() ? (char)'\uffff' : this._line.charAt(this._current++);
    }

    private void scanLine(String line) {
        char c;
        this._line = line;
        int state = 0;
        StringBuffer key = null;
        StringBuffer value = null;
        StringBuffer oneChar = new StringBuffer();
        block9: do {
            c = this.nextChar();
            switch (state) {
                case 0: {
                    if (c == '\uffff' || c == ' ') continue block9;
                    if (c == '\"') {
                        state = 2;
                        value = new StringBuffer();
                        break;
                    }
                    if (c == '-') {
                        state = 3;
                        key = new StringBuffer();
                        break;
                    }
                    value = new StringBuffer();
                    value.append(c);
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == '\uffff' || c == ' ') {
                        this._argv.addElement(value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 2: {
                    if (c == '\uffff' || c == '\"') {
                        this._argv.addElement(value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 3: {
                    if (c == '\uffff' || c == ' ') {
                        if (key.length() != 0) {
                            this._optv.addElement(key.toString());
                            this._optHash.put(key.toString(), "");
                            oneChar.append(key.toString());
                        }
                        state = 0;
                        break;
                    }
                    if (c == '=') {
                        value = new StringBuffer();
                        state = 4;
                        break;
                    }
                    key.append(c);
                    break;
                }
                case 4: {
                    if (c == '\uffff' || c == ' ') {
                        if (key.length() != 0) {
                            this._optv.addElement(key.toString());
                            this._optHash.put(key.toString(), "");
                        }
                        state = 0;
                        break;
                    }
                    if (c == '\"') {
                        value = new StringBuffer();
                        state = 5;
                        break;
                    }
                    state = 6;
                    value = new StringBuffer();
                    value.append(c);
                    break;
                }
                case 5: {
                    if (c == '\uffff' || c == '\"') {
                        this._optv.addElement(key.toString());
                        this._optHash.put(key.toString(), value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                    break;
                }
                case 6: {
                    if (c == '\uffff' || c == ' ') {
                        this._optv.addElement(key.toString());
                        this._optHash.put(key.toString(), value.toString());
                        state = 0;
                        break;
                    }
                    value.append(c);
                }
            }
        } while (c != '\uffff');
        this._oneChar = oneChar.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage : ... <parseString>");
            System.exit(4);
        }
        Args lineArgs = null;
        lineArgs = args.length == 1 ? new Args(args[0]) : new Args(args);
        System.out.print(lineArgs.getInfo());
        System.out.println("pvr=" + lineArgs.getOpt("pvr"));
    }
}

