/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dcache.auth.FQANPrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.util.CertificateUtils;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class VomsPlugin
implements GPlazmaAuthenticationPlugin {
    private static final Logger _log = LoggerFactory.getLogger(VomsPlugin.class);
    private static final String CADIR = "gplazma.vomsdir.ca";
    private static final String VOMSDIR = "gplazma.vomsdir.dir";
    private final String _caDir;
    private final String _vomsDir;
    private final Map<?, ?> _mdcContext;

    public VomsPlugin(Properties properties) {
        this._caDir = properties.getProperty(CADIR);
        this._vomsDir = properties.getProperty(VOMSDIR);
        Preconditions.checkArgument((this._vomsDir != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.vomsdir.dir");
        Preconditions.checkArgument((this._caDir != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.vomsdir.ca");
        this._mdcContext = MDC.getCopyOfContextMap();
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        try {
            VOMSValidator validator = new VOMSValidator(null, new ACValidator(CertificateUtils.getPkiVerifier((String)this._vomsDir, (String)this._caDir, this._mdcContext)));
            boolean primary = true;
            boolean hasX509 = false;
            boolean hasFQANs = false;
            for (Object credential : publicCredentials) {
                if (!(credential instanceof X509Certificate[])) continue;
                hasX509 = true;
                X509Certificate[] chain = (X509Certificate[])credential;
                validator.setClientChain(chain).validate();
                for (String fqan : validator.getAllFullyQualifiedAttributes()) {
                    hasFQANs = true;
                    identifiedPrincipals.add((Principal)new FQANPrincipal(fqan, primary));
                    primary = false;
                }
            }
            if (!hasX509) {
                throw new AuthenticationException("no X509 certificate chain");
            }
            if (!hasFQANs) {
                throw new AuthenticationException("no FQANs");
            }
        }
        catch (IOException e) {
            _log.error("failed to load PKI stores: {}", (Object)e.getMessage());
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (CRLException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }
}

