/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.BehaviorsUtil;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.markup.html.link.PageLink;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.MockWebApplication;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.diff.DiffUtil;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.DummyPanelPage;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.ITestPageSource;
import org.apache.wicket.util.tester.ITestPanelSource;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.TagTester;
import org.apache.wicket.util.tester.WicketTester;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWicketTester
extends MockWebApplication {
    private static final Logger log = LoggerFactory.getLogger(BaseWicketTester.class);

    public BaseWicketTester() {
        this(new DummyWebApplication(), null);
    }

    public <C extends Page> BaseWicketTester(final Class<C> homePage) {
        this(new WebApplication(){

            @Override
            public Class<? extends Page> getHomePage() {
                return homePage;
            }

            @Override
            protected void outputDevelopmentModeWarning() {
            }

            @Override
            protected ISessionStore newSessionStore() {
                return new HttpSessionStore(this);
            }
        }, null);
    }

    public BaseWicketTester(WebApplication application) {
        this(application, null);
    }

    public BaseWicketTester(WebApplication application, String path) {
        super(application, path);
    }

    public final Page startPage(ITestPageSource testPageSource) {
        this.startPage(DummyHomePage.class);
        DummyHomePage page = (DummyHomePage)this.getLastRenderedPage();
        page.setTestPageSource(testPageSource);
        this.executeListener(page.getTestPageLink());
        return this.getLastRenderedPage();
    }

    public void executeListener(Component component) {
        WebRequestCycle cycle = this.setupRequestAndResponse();
        this.getServletRequest().setRequestToComponent(component);
        this.processRequestCycle(cycle);
    }

    public void executeBehavior(AbstractAjaxBehavior behavior) {
        CharSequence url = behavior.getCallbackUrl(false);
        WebRequestCycle cycle = this.setupRequestAndResponse(true);
        this.getServletRequest().setRequestToRedirectString(((Object)url).toString());
        this.processRequestCycle(cycle);
    }

    public final Page startPage(Page page) {
        return this.startPage(new TestPageSource(page));
    }

    public final <C extends Page> Page startPage(Class<C> pageClass) {
        this.processRequestCycle(pageClass);
        return this.getLastRenderedPage();
    }

    public final <C extends Page> Page startPage(Class<C> pageClass, PageParameters parameters) {
        this.processRequestCycle(pageClass, parameters);
        return this.getLastRenderedPage();
    }

    public FormTester newFormTester(String path) {
        return this.newFormTester(path, true);
    }

    public FormTester newFormTester(String path, boolean fillBlankString) {
        return new FormTester(path, (Form)this.getComponentFromLastRenderedPage(path), this, fillBlankString);
    }

    public final Panel startPanel(final ITestPanelSource testPanelSource) {
        return (Panel)this.startPage(new ITestPageSource(){
            private static final long serialVersionUID = 1L;

            public Page getTestPage() {
                return new DummyPanelPage(testPanelSource);
            }
        }).get("panel");
    }

    public final <C extends Panel> Panel startPanel(final Class<C> panelClass) {
        return (Panel)this.startPage(new ITestPageSource(){
            private static final long serialVersionUID = 1L;

            public Page getTestPage() {
                return new DummyPanelPage(new ITestPanelSource(){
                    private static final long serialVersionUID = 1L;

                    public Panel getTestPanel(String panelId) {
                        try {
                            Constructor c = panelClass.getConstructor(String.class);
                            return (Panel)c.newInstance(panelId);
                        }
                        catch (SecurityException e) {
                            throw BaseWicketTester.this.convertoUnexpect(e);
                        }
                        catch (NoSuchMethodException e) {
                            throw BaseWicketTester.this.convertoUnexpect(e);
                        }
                        catch (InstantiationException e) {
                            throw BaseWicketTester.this.convertoUnexpect(e);
                        }
                        catch (IllegalAccessException e) {
                            throw BaseWicketTester.this.convertoUnexpect(e);
                        }
                        catch (InvocationTargetException e) {
                            throw BaseWicketTester.this.convertoUnexpect(e);
                        }
                    }
                });
            }
        }).get("panel");
    }

    public void startComponent(Component component) {
        if (component instanceof FormComponent) {
            ((FormComponent)component).processInput();
        }
        component.beforeRender();
    }

    private RuntimeException convertoUnexpect(Exception e) {
        return new WicketRuntimeException("tester: unexpected", e);
    }

    public Component getComponentFromLastRenderedPage(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does not exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
            return component;
        }
        if (component.isVisibleInHierarchy()) {
            return component;
        }
        return null;
    }

    public Result hasLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        return this.isEqual(expectedLabelText, label.getDefaultModelObjectAsString());
    }

    public <C extends Page> Result isPageLink(String path, Class<C> expectedPageClass) {
        PageLink pageLink = (PageLink)this.getComponentFromLastRenderedPage(path);
        try {
            for (Class<?> type = pageLink.getClass(); type != PageLink.class.getSuperclass(); type = type.getSuperclass()) {
                try {
                    Field iPageLinkField = type.getDeclaredField("pageLink");
                    iPageLinkField.setAccessible(true);
                    IPageLink iPageLink = (IPageLink)iPageLinkField.get(pageLink);
                    return this.isEqual(expectedPageClass, iPageLink.getPageIdentity());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            throw new WicketRuntimeException("Is this realy a PageLink? Cannot find 'pageLink' field");
        }
        catch (SecurityException e) {
            throw this.convertoUnexpect(e);
        }
        catch (IllegalAccessException e) {
            throw this.convertoUnexpect(e);
        }
    }

    public <C extends Component> Result isComponent(String path, Class<C> expectedComponentClass) {
        Component component = this.getComponentFromLastRenderedPage(path);
        if (component == null) {
            return Result.fail("Component not found: " + path);
        }
        return this.isTrue("component '" + Classes.simpleName(component.getClass()) + "' is not type:" + Classes.simpleName(expectedComponentClass), expectedComponentClass.isAssignableFrom(component.getClass()));
    }

    public Result isVisible(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
        }
        return this.isTrue("component '" + path + "' is not visible", component.isVisibleInHierarchy());
    }

    public Result isInvisible(String path) {
        return this.isNull("component '" + path + "' is visible", this.getComponentFromLastRenderedPage(path));
    }

    public Result isEnabled(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
        }
        return this.isTrue("component '" + path + "' is disabled", component.isEnabledInHierarchy());
    }

    public Result isDisabled(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
        }
        return this.isFalse("component '" + path + "' is enabled", component.isEnabledInHierarchy());
    }

    public Result isRequired(String path) {
        Component component = this.getLastRenderedPage().get(path);
        if (component == null) {
            this.fail("path: '" + path + "' does no exist for page: " + Classes.simpleName(this.getLastRenderedPage().getClass()));
        } else if (!(component instanceof FormComponent)) {
            this.fail("path: '" + path + "' is not a form component");
        }
        return this.isRequired((FormComponent)component);
    }

    public Result isRequired(FormComponent<?> component) {
        return this.isTrue("component '" + component + "' is not required", component.isRequired());
    }

    public Result ifContains(String pattern) {
        return this.isTrue("pattern '" + pattern + "' not found", this.getServletResponse().getDocument().matches("(?s).*" + pattern + ".*"));
    }

    public Result ifContainsNot(String pattern) {
        return this.isFalse("pattern '" + pattern + "' found", this.getServletResponse().getDocument().matches("(?s).*" + pattern + ".*"));
    }

    public void assertListView(String path, List<?> expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void clickLink(String path) {
        this.clickLink(path, true);
    }

    public void clickLink(String path, boolean isAjax) {
        Component linkComponent = this.getComponentFromLastRenderedPage(path);
        this.checkUsability(linkComponent);
        if (linkComponent instanceof AjaxLink) {
            if (!isAjax) {
                this.fail("Link " + path + "is an AjaxLink and will " + "not be invoked when AJAX (javascript) is disabled.");
            }
            AjaxLink link = (AjaxLink)linkComponent;
            this.setupRequestAndResponse(true);
            WebRequestCycle requestCycle = this.createRequestCycle();
            AjaxRequestTarget target = this.getApplication().newAjaxRequestTarget(link.getPage());
            requestCycle.setRequestTarget(target);
            link.onClick(target);
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof AjaxFallbackLink && isAjax) {
            AjaxFallbackLink link = (AjaxFallbackLink)linkComponent;
            this.setupRequestAndResponse(true);
            WebRequestCycle requestCycle = this.createRequestCycle();
            AjaxRequestTarget target = this.getApplication().newAjaxRequestTarget(link.getPage());
            requestCycle.setRequestTarget(target);
            link.onClick(target);
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof AjaxSubmitLink) {
            if (!isAjax) {
                this.fail("Link " + path + "is an AjaxSubmitLink and " + "will not be invoked when AJAX (javascript) is disabled.");
            }
            AjaxSubmitLink link = (AjaxSubmitLink)linkComponent;
            List<IBehavior> behaviors = link.getBehaviors();
            AjaxFormSubmitBehavior ajaxFormSubmitBehavior = null;
            for (IBehavior behavior : behaviors) {
                AjaxFormSubmitBehavior submitBehavior;
                if (!(behavior instanceof AjaxFormSubmitBehavior)) continue;
                ajaxFormSubmitBehavior = submitBehavior = (AjaxFormSubmitBehavior)behavior;
            }
            String failMessage = "No form submit behavior found on the submit link. Strange!!";
            this.notNull(failMessage, ajaxFormSubmitBehavior);
            WebRequestCycle requestCycle = this.setupRequestAndResponse(true);
            this.setupAjaxSubmitRequestParameters(linkComponent, ajaxFormSubmitBehavior);
            ajaxFormSubmitBehavior.onRequest();
            this.processRequestCycle(requestCycle);
        } else if (linkComponent instanceof SubmitLink) {
            SubmitLink submitLink = (SubmitLink)linkComponent;
            String pageRelativePath = submitLink.getInputName();
            this.getParametersForNextRequest().put(pageRelativePath, new String[]{"x"});
            Form<?> form = submitLink.getForm();
            form.visitFormComponents(new FormComponent.IVisitor(){

                public Object formComponent(IFormVisitorParticipant formComponent) {
                    FormComponent component = (FormComponent)formComponent;
                    if (!BaseWicketTester.this.getParametersForNextRequest().containsKey(component.getInputName())) {
                        BaseWicketTester.this.getParametersForNextRequest().put(component.getInputName(), new String[]{component.getDefaultModelObjectAsString()});
                    }
                    return Component.IVisitor.CONTINUE_TRAVERSAL;
                }
            });
            this.submitForm(submitLink.getForm().getPageRelativePath());
        } else if (linkComponent instanceof AbstractLink) {
            AbstractLink link = (AbstractLink)linkComponent;
            if (link instanceof BookmarkablePageLink) {
                BookmarkablePageLink bookmarkablePageLink = (BookmarkablePageLink)link;
                try {
                    BookmarkablePageLink.class.getDeclaredField("parameters");
                    Method getParametersMethod = BookmarkablePageLink.class.getDeclaredMethod("getPageParameters", null);
                    getParametersMethod.setAccessible(true);
                    PageParameters parameters = (PageParameters)getParametersMethod.invoke((Object)bookmarkablePageLink, (Object[])null);
                    this.setParametersForNextRequest(parameters.toRequestParameters());
                }
                catch (Exception e) {
                    this.fail("Internal error in WicketTester. Please report this in Wickets Issue Tracker.");
                }
            }
            this.executeListener(link);
        } else {
            this.fail("Link " + path + " is not a Link, AjaxLink, AjaxFallbackLink or AjaxSubmitLink");
        }
    }

    public void submitForm(String path) {
        Form form = (Form)this.getComponentFromLastRenderedPage(path);
        this.executeListener(form);
    }

    public void setParameterForNextRequest(String componentPath, Object value) {
        Component c;
        if (this.getLastRenderedPage() == null) {
            this.fail("before using this method, at least one page has to be rendered");
        }
        if ((c = this.getComponentFromLastRenderedPage(componentPath)) == null) {
            this.fail("component " + componentPath + " was not found");
            return;
        }
        if (c instanceof FormComponent) {
            this.getParametersForNextRequest().put(((FormComponent)c).getInputName(), new String[]{value.toString()});
        } else {
            this.getParametersForNextRequest().put(c.getPath(), new String[]{value.toString()});
        }
    }

    public <C extends Page> Result isRenderedPage(Class<C> expectedRenderedPageClass) {
        Page page = this.getLastRenderedPage();
        if (page == null) {
            return Result.fail("page was null");
        }
        if (!page.getClass().isAssignableFrom(expectedRenderedPageClass)) {
            return this.isEqual(Classes.simpleName(expectedRenderedPageClass), Classes.simpleName(page.getClass()));
        }
        return Result.pass();
    }

    public void assertResultPage(Class<?> pageClass, String filename) throws Exception {
        String document = this.getServletResponse().getDocument();
        DiffUtil.validatePage(document, pageClass, filename, true);
    }

    public Result isResultPage(String expectedDocument) throws Exception {
        String document = this.getServletResponse().getDocument();
        return this.isTrue("expected rendered page equals", document.equals(expectedDocument));
    }

    public Result hasNoErrorMessage() {
        List<Serializable> messages = this.getMessages(400);
        return this.isTrue("expect no error message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public Result hasNoInfoMessage() {
        List<Serializable> messages = this.getMessages(200);
        return this.isTrue("expect no info message, but contains\n" + WicketTesterHelper.asLined(messages), messages.isEmpty());
    }

    public List<Serializable> getMessages(final int level) {
        FeedbackMessages feedbackMessages = Session.get().getFeedbackMessages();
        List<FeedbackMessage> allMessages = feedbackMessages.messages(new IFeedbackMessageFilter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(FeedbackMessage message) {
                return message.getLevel() == level;
            }
        });
        ArrayList<Serializable> actualMessages = new ArrayList<Serializable>();
        for (FeedbackMessage message : allMessages) {
            actualMessages.add(message.getMessage());
        }
        return actualMessages;
    }

    public void dumpPage() {
        log.info(this.getServletResponse().getDocument());
    }

    public void debugComponentTrees() {
        this.debugComponentTrees("");
    }

    public void debugComponentTrees(String filter) {
        log.info("debugging ----------------------------------------------");
        for (WicketTesterHelper.ComponentData obj : WicketTesterHelper.getComponentData(this.getLastRenderedPage())) {
            if (!obj.path.matches(".*" + filter + ".*")) continue;
            log.info("path\t" + obj.path + " \t" + obj.type + " \t[" + obj.value + "]");
        }
    }

    public Result isComponentOnAjaxResponse(Component component) {
        Result result;
        String failMessage = "A component which is null could not have been added to the AJAX response";
        this.notNull(failMessage, component);
        if (!component.isVisible() && (result = this.isTrue(failMessage = "A component which is invisible and doesn't render a placeholder tag will not be rendered at all and thus won't be accessible for subsequent AJAX interaction", component.getOutputMarkupPlaceholderTag())).wasFailed()) {
            return result;
        }
        String ajaxResponse = this.getServletResponse().getDocument();
        failMessage = "The Previous response was not an AJAX response. You need to execute an AJAX event, using clickLink, before using this assert";
        boolean isAjaxResponse = Pattern.compile("^<\\?xml version=\"1.0\" encoding=\".*?\"\\?><ajax-response>").matcher(ajaxResponse).find();
        result = this.isTrue(failMessage, isAjaxResponse);
        if (result.wasFailed()) {
            return result;
        }
        failMessage = "The component doesn't have a markup id, which means that it can't have been added to the AJAX response";
        String markupId = component.getMarkupId();
        result = this.isTrue(failMessage, !Strings.isEmpty(markupId));
        if (result.wasFailed()) {
            return result;
        }
        boolean isComponentInAjaxResponse = ajaxResponse.matches("(?s).*<component id=\"" + markupId + "\"[^>]*?>.*");
        failMessage = "Component wasn't found in the AJAX response";
        return this.isTrue(failMessage, isComponentInAjaxResponse);
    }

    public void executeAjaxEvent(String componentPath, String event) {
        Component component = this.getComponentFromLastRenderedPage(componentPath);
        this.executeAjaxEvent(component, event);
    }

    public void executeAllTimerBehaviors(MarkupContainer container) {
        container.visitChildren(MarkupContainer.class, new Component.IVisitor<MarkupContainer>(){

            @Override
            public Object component(MarkupContainer component) {
                List<IBehavior> behaviors = BehaviorsUtil.getBehaviors(component, AjaxSelfUpdatingTimerBehavior.class);
                for (IBehavior b : behaviors) {
                    if (!(b instanceof AjaxSelfUpdatingTimerBehavior)) continue;
                    BaseWicketTester.this.checkUsability(component);
                    log.debug("Triggering AjaxSelfUpdatingTimerBehavior: " + component.getClassRelativePath());
                    AjaxSelfUpdatingTimerBehavior abstractAjaxBehaviour = (AjaxSelfUpdatingTimerBehavior)b;
                    if (abstractAjaxBehaviour.isStopped()) continue;
                    BaseWicketTester.this.executeBehavior(abstractAjaxBehaviour);
                }
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    public void executeAjaxEvent(Component component, String event) {
        this.setCreateAjaxRequest(true);
        String failMessage = "Can't execute event on a component which is null.";
        this.notNull(failMessage, component);
        failMessage = "event must not be null";
        this.notNull(failMessage, event);
        this.checkUsability(component);
        AjaxEventBehavior ajaxEventBehavior = null;
        List<IBehavior> behaviors = component.getBehaviors();
        for (IBehavior behavior : behaviors) {
            AjaxEventBehavior tmp;
            if (!(behavior instanceof AjaxEventBehavior) || !event.equals((tmp = (AjaxEventBehavior)behavior).getEvent())) continue;
            ajaxEventBehavior = tmp;
        }
        failMessage = "No AjaxEventBehavior found on component: " + component.getId() + " which matches the event: " + event;
        this.notNull(failMessage, ajaxEventBehavior);
        WebRequestCycle requestCycle = this.resolveRequestCycle();
        if (!requestCycle.getWebRequest().isAjax()) {
            throw new IllegalStateException("The ServletWebRequest was created without wicket-ajax header. Please use tester.setCreateAjaxRequest(true)");
        }
        if (ajaxEventBehavior instanceof AjaxFormSubmitBehavior) {
            AjaxFormSubmitBehavior ajaxFormSubmitBehavior = (AjaxFormSubmitBehavior)ajaxEventBehavior;
            this.setupAjaxSubmitRequestParameters(component, ajaxFormSubmitBehavior);
        }
        ajaxEventBehavior.onRequest();
        this.processRequestCycle(requestCycle);
    }

    protected WebRequestCycle resolveRequestCycle() {
        WebRequestCycle requestCycle;
        if (RequestCycle.get() == null) {
            requestCycle = this.setupRequestAndResponse();
        } else {
            requestCycle = (WebRequestCycle)RequestCycle.get();
            if (!requestCycle.getWebRequest().isAjax() && this.isCreateAjaxRequest()) {
                this.setParametersForNextRequest(requestCycle.getWebRequest().getParameterMap());
                requestCycle = this.setupRequestAndResponse();
            }
        }
        return requestCycle;
    }

    public TagTester getTagByWicketId(String wicketId) {
        return TagTester.createTagByAttribute(this.getServletResponse().getDocument(), "wicket:id", wicketId);
    }

    public static List<TagTester> getTagsByWicketId(WicketTester tester, String wicketId) {
        return TagTester.createTagsByAttribute(tester.getServletResponse().getDocument(), "wicket:id", wicketId, false);
    }

    public TagTester getTagById(String id) {
        return TagTester.createTagByAttribute(this.getServletResponse().getDocument(), "id", id);
    }

    private void setupAjaxSubmitRequestParameters(final Component component, AjaxFormSubmitBehavior behavior) {
        Form<?> form = behavior.getForm();
        String failMessage = "No form attached to the submitlink.";
        this.notNull(failMessage, form);
        this.checkUsability(form);
        Map<String, Object> requestParameters = this.getServletRequest().getParameterMap();
        if (component instanceof Button) {
            Button clickedButton = (Button)component;
            this.getServletRequest().setParameter(clickedButton.getInputName(), clickedButton.getValue());
        } else if (component instanceof AjaxSubmitLink) {
            String inputName = ((IFormSubmittingComponent)((Object)component)).getInputName();
            requestParameters.put(inputName, new String[]{"x"});
        }
        form.visitFormComponents(new FormComponent.AbstractVisitor(){

            @Override
            public void onFormComponent(FormComponent<?> formComponent) {
                if (!(formComponent instanceof RadioGroup || formComponent instanceof CheckGroup || formComponent instanceof Button || !formComponent.isVisibleInHierarchy() || !formComponent.isEnabledInHierarchy() || formComponent instanceof IFormSubmittingComponent && component instanceof IFormSubmittingComponent && component != formComponent)) {
                    String name = formComponent.getInputName();
                    String value = formComponent.getValue();
                    if (!BaseWicketTester.this.getServletRequest().getParameterMap().containsKey(name) && !BaseWicketTester.this.getParametersForNextRequest().containsKey(name)) {
                        BaseWicketTester.this.getServletRequest().setParameter(name, value);
                        BaseWicketTester.this.getParametersForNextRequest().put(name, new String[]{value});
                    }
                }
            }
        });
    }

    public String getContentTypeFromResponseHeader() {
        String contentType = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Type");
        if (contentType == null) {
            throw new WicketRuntimeException("No Content-Type header found");
        }
        return contentType;
    }

    public int getContentLengthFromResponseHeader() {
        String contentLength = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Length");
        if (contentLength == null) {
            throw new WicketRuntimeException("No Content-Length header found");
        }
        return Integer.parseInt(contentLength);
    }

    public String getLastModifiedFromResponseHeader() {
        return ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Last-Modified");
    }

    public String getContentDispositionFromResponseHeader() {
        return ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Content-Disposition");
    }

    private Result isTrue(String message, boolean condition) {
        if (condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    private Result isFalse(String message, boolean condition) {
        if (!condition) {
            return Result.pass();
        }
        return Result.fail(message);
    }

    protected final Result isEqual(Object expected, Object actual) {
        if (expected == null && actual == null) {
            return Result.pass();
        }
        if (expected != null && expected.equals(actual)) {
            return Result.pass();
        }
        String message = "expected:<" + expected + "> but was:<" + actual + ">";
        return Result.fail(message);
    }

    private void notNull(String message, Object object) {
        if (object == null) {
            this.fail(message);
        }
    }

    private Result isNull(String message, Object object) {
        if (object != null) {
            return Result.fail(message);
        }
        return Result.pass();
    }

    protected void checkUsability(Component component) {
        if (!component.isVisibleInHierarchy()) {
            this.fail("The component is currently not visible in the hierarchy and thus you can not be used. Component: " + component);
        }
        if (!component.isEnabledInHierarchy()) {
            this.fail("The component is currently not enabled in the hierarchy and thus you can not be used. Component: " + component);
        }
    }

    protected final void fail(String message) {
        throw new WicketRuntimeException(message);
    }

    @Deprecated
    public static void callOnBeginRequest(RequestCycle rc) {
        try {
            Method method = RequestCycle.class.getDeclaredMethod("onBeginRequest", null);
            method.setAccessible(true);
            method.invoke((Object)rc, (Object[])null);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception invoking requestcycle.onbeginrequest()", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyWebApplication
    extends WebApplication {
        @Override
        public Class<? extends Page> getHomePage() {
            return DummyHomePage.class;
        }

        @Override
        protected void outputDevelopmentModeWarning() {
        }

        @Override
        protected ISessionStore newSessionStore() {
            return new HttpSessionStore(this);
        }
    }

    private static final class TestPageSource
    implements ITestPageSource {
        private final Page page;
        private static final long serialVersionUID = 1L;

        private TestPageSource(Page page) {
            this.page = page;
        }

        public Page getTestPage() {
            return this.page;
        }
    }
}

