/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.util.Locale;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolverConverter
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final IConverterLocator converterSupplier;
    private final Locale locale;

    public PropertyResolverConverter(IConverterLocator converterSupplier, Locale locale) {
        this.converterSupplier = converterSupplier;
        this.locale = locale;
    }

    public Object convert(Object object, Class<?> clz) {
        if (object == null) {
            return null;
        }
        if (clz.isAssignableFrom(object.getClass())) {
            return object;
        }
        IConverter converter = this.converterSupplier.getConverter(clz);
        if (object instanceof String) {
            return converter.convertToObject((String)object, this.locale);
        }
        if (clz == String.class) {
            return converter.convertToString(object, this.locale);
        }
        try {
            return Objects.convertValue(object, clz);
        }
        catch (RuntimeException ex) {
            String tmp = converter.convertToString(object, this.locale);
            return converter.convertToObject(tmp, this.locale);
        }
    }
}

