/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class Connections {
    private Connections() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        try {
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                try {
                    long l = jarFileConnection.getLastModified();
                    return l;
                }
                finally {
                    Connections.close(jarFileConnection);
                }
            }
            long l = connection.getLastModified();
            return l;
        }
        finally {
            Connections.closeQuietly(connection);
        }
    }

    public static void closeQuietly(URLConnection connection) {
        try {
            Connections.close(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(URLConnection connection) throws IOException {
        if (connection == null) {
            return;
        }
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        } else {
            connection.getInputStream().close();
        }
    }
}

