/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.filtering;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.response.StringResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderResponseContainerFilteringHeaderResponse
extends DecoratingHeaderResponse {
    private static final Logger log = LoggerFactory.getLogger(HeaderResponseContainerFilteringHeaderResponse.class);
    private static final MetaDataKey<HeaderResponseContainerFilteringHeaderResponse> RESPONSE_KEY = new MetaDataKey<HeaderResponseContainerFilteringHeaderResponse>(){
        private static final long serialVersionUID = 1L;
    };
    private final Map<String, StringResponse> responseFilterMap = new HashMap<String, StringResponse>();
    private IHeaderResponseFilter[] filters;
    private final String headerFilterName;

    public HeaderResponseContainerFilteringHeaderResponse(IHeaderResponse response, String headerFilterName, IHeaderResponseFilter[] filters) {
        super(response);
        this.headerFilterName = headerFilterName;
        this.setFilters(filters);
        RequestCycle.get().setMetaData(RESPONSE_KEY, this);
    }

    protected void setFilters(IHeaderResponseFilter[] filters) {
        this.filters = filters;
        if (filters == null) {
            return;
        }
        for (IHeaderResponseFilter filter : filters) {
            this.responseFilterMap.put(filter.getName(), new StringResponse());
        }
    }

    public static HeaderResponseContainerFilteringHeaderResponse get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("you can only get the HeaderResponseContainerFilteringHeaderResponse when there is a RequestCycle present");
        }
        HeaderResponseContainerFilteringHeaderResponse response = requestCycle.getMetaData(RESPONSE_KEY);
        if (response == null) {
            throw new IllegalStateException("no HeaderResponseContainerFilteringHeaderResponse is present in the request cycle.  This may mean that you have not decorated the header response with a HeaderResponseContainerFilteringHeaderResponse.  Simply calling the HeaderResponseContainerFilteringHeaderResponse constructor sets itself on the request cycle");
        }
        return response;
    }

    public void renderJavascriptReference(final ResourceReference reference) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavascriptReference(reference);
            }
        });
    }

    public void renderJavascriptReference(final ResourceReference reference, final String id) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavascriptReference(reference, id);
            }
        });
    }

    public void renderJavascriptReference(final String url) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavascriptReference(url);
            }
        });
    }

    public void renderJavascriptReference(final String url, final String id) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavascriptReference(url, id);
            }
        });
    }

    public void renderJavascript(final CharSequence javascript, final String id) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavascript(javascript, id);
            }
        });
    }

    public void renderCSSReference(final ResourceReference reference) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(reference);
            }
        });
    }

    public void renderCSSReference(final String url) {
        this.forCss(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(url);
            }
        });
    }

    public void renderCSSReference(final ResourceReference reference, final String media) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(reference, media);
            }
        });
    }

    public void renderCSSReference(final String url, final String media) {
        this.forCss(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(url, media);
            }
        });
    }

    public void renderOnDomReadyJavascript(final String javascript) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnDomReadyJavascript(javascript);
            }
        });
    }

    public void renderOnLoadJavascript(final String javascript) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnLoadJavascript(javascript);
            }
        });
    }

    public void renderOnEventJavascript(final String target, final String event, final String javascript) {
        this.forJavascript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnEventJavascript(target, event, javascript);
            }
        });
    }

    public void close() {
        CharSequence headerContent = this.getContent(this.headerFilterName);
        RequestCycle.get().getResponse().write(headerContent);
        super.close();
    }

    public final CharSequence getContent(String filterName) {
        if (filterName == null) {
            return "";
        }
        StringResponse resp = this.responseFilterMap.get(filterName);
        return resp == null ? "" : resp.getBuffer();
    }

    private void forReference(ResourceReference reference, Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptReference(reference)) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("a ResourceReference was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    private void forJavascript(Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptOtherJavascript()) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("javascript was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    private void forCss(Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptOtherCss()) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("css was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    protected final void runWithFilter(Runnable runnable, String filterName) {
        this.run(runnable, this.responseFilterMap.get(filterName));
    }

    private void run(Runnable runnable, IHeaderResponseFilter filter) {
        this.run(runnable, this.responseFilterMap.get(filter.getName()));
    }

    private void run(Runnable runnable, Response response) {
        if (AjaxRequestTarget.get() != null) {
            runnable.run();
            return;
        }
        Response original = RequestCycle.get().setResponse(response);
        try {
            runnable.run();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            RequestCycle.get().setResponse(original);
        }
    }

    public static interface IHeaderResponseFilter {
        public String getName();

        public boolean acceptReference(ResourceReference var1);

        public boolean acceptOtherJavascript();

        public boolean acceptOtherCss();
    }
}

