/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component.listener;

import java.util.List;
import org.apache.wicket.AbortException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.behavior.IIgnoreDisabledComponentBehavior;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.listener.AbstractListenerInterfaceRequestTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BehaviorRequestTarget
extends AbstractListenerInterfaceRequestTarget {
    private static final Logger logger = LoggerFactory.getLogger(BehaviorRequestTarget.class);

    public BehaviorRequestTarget(Page page, Component component, RequestListenerInterface listener) {
        this(page, component, listener, null);
    }

    public BehaviorRequestTarget(Page page, Component component, RequestListenerInterface listener, RequestParameters requestParameters) {
        super(page, component, listener, requestParameters);
    }

    public final void processEvents(RequestCycle requestCycle) {
        IBehavior behavior;
        this.onProcessEvents(requestCycle);
        Component component = this.getTarget();
        String id = this.getRequestParameters().getBehaviorId();
        if (id == null) {
            throw new PageExpiredException("Parameter behaviorId was not provided: unable to locate listener. Component: " + component.toString());
        }
        int idAsInt = Integer.parseInt(id);
        List<IBehavior> behaviors = component.getBehaviorsRawList();
        if (behaviors == null) {
            throw new PageExpiredException("No behaviors attached to component " + component.toString());
        }
        IBehaviorListener behaviorListener = null;
        if (behaviors.size() > idAsInt && (behavior = behaviors.get(idAsInt)) instanceof IBehaviorListener) {
            if (!behavior.isEnabled(component)) {
                logger.warn("behavior not enabled; ignoring call. behavior: {} at index: {} on component: {}", new Object[]{behavior, idAsInt, component});
                if (requestCycle.getRequest() instanceof WebRequest && ((WebRequest)requestCycle.getRequest()).isAjax()) {
                    throw new AbortException();
                }
                return;
            }
            behaviorListener = (IBehaviorListener)((Object)behavior);
        }
        if (behaviorListener == null) {
            throw new PageExpiredException("No behavior listener found with behaviorId " + id + "; Component: " + component.toString());
        }
        if (!component.isVisibleInHierarchy() || !(behaviorListener instanceof IIgnoreDisabledComponentBehavior) && !component.isEnabledInHierarchy()) {
            logger.warn("component not enabled or visible; ignoring call. Component: {}", (Object)component);
            if (requestCycle.getRequest() instanceof WebRequest && ((WebRequest)requestCycle.getRequest()).isAjax()) {
                throw new AbortException();
            }
            return;
        }
        behaviorListener.onRequest();
    }
}

