/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.RequestContext;
import org.apache.wicket.Response;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.apache.wicket.response.StringResponse;

public class EmbeddedPortletHeaderResponse
extends HeaderResponse {
    private final Response realResponse;
    private final StringResponse bufferedResponse;

    public EmbeddedPortletHeaderResponse(Response realResponse) {
        this.realResponse = realResponse;
        this.bufferedResponse = new StringResponse();
    }

    public void renderCSSReference(String url, String media) {
        List<Object> token;
        if (!this.isClosed() && !this.wasRendered(token = Arrays.asList("css", url, media))) {
            this.getResponse().write("<script type=\"text/javascript\">");
            this.getResponse().write("var elem=document.createElement(\"link\");");
            this.getResponse().write("elem.setAttribute(\"rel\",\"stylesheet\");");
            this.getResponse().write("elem.setAttribute(\"type\",\"text/css\");");
            this.getResponse().write("elem.setAttribute(\"href\",\"" + url + "\");");
            if (media != null) {
                this.getResponse().write("elem.setAttribute(\"media\",\"" + media + "\");");
            }
            this.getResponse().write("document.getElementsByTagName(\"head\")[0].appendChild(elem);");
            this.getResponse().println("</script>");
            this.markRendered(token);
        }
    }

    public void close() {
        super.close();
        CharSequence output = this.bufferedResponse.getBuffer();
        if (output.length() > 0) {
            if (output.charAt(0) == '\r') {
                for (int i = 2; i < output.length(); i += 2) {
                    char ch = output.charAt(i);
                    if (ch == '\r') continue;
                    output = output.subSequence(i - 2, output.length());
                    break;
                }
            } else if (output.charAt(0) == '\n') {
                for (int i = 1; i < output.length(); ++i) {
                    char ch = output.charAt(i);
                    if (ch == '\n') continue;
                    output = output.subSequence(i - 1, output.length());
                    break;
                }
            }
        }
        if (output.length() > 0) {
            this.realResponse.write("<span id=\"" + RequestContext.get().getNamespace() + "_embedded_head\" style=\"display:none\">");
            this.realResponse.write(output);
            this.realResponse.write("</span>");
        }
        this.bufferedResponse.reset();
    }

    protected Response getRealResponse() {
        return this.bufferedResponse;
    }
}

