/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IRequestLogger {
    public int getTotalCreatedSessions();

    public int getPeakSessions();

    public List<RequestData> getRequests();

    public RequestLogger.SessionData[] getLiveSessions();

    public int getCurrentActiveRequestCount();

    public int getPeakActiveRequestCount();

    public void sessionCreated(String var1);

    public void sessionDestroyed(String var1);

    public void requestTime(long var1);

    public void objectRemoved(Object var1);

    public void objectUpdated(Object var1);

    public void objectCreated(Object var1);

    public void logResponseTarget(IRequestTarget var1);

    public void logEventTarget(IRequestTarget var1);

    public static class RequestData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private long startDate;
        private long timeTaken;
        private final List<String> entries = new ArrayList<String>(5);
        private String eventTarget;
        private String responseTarget;
        private String sessionId;
        private long totalSessionSize;
        private Object sessionInfo;
        private int activeRequest;

        public Long getTimeTaken() {
            return new Long(this.timeTaken);
        }

        public void setActiveRequest(int activeRequest) {
            this.activeRequest = activeRequest;
        }

        public int getActiveRequest() {
            return this.activeRequest;
        }

        public Object getSessionInfo() {
            return this.sessionInfo;
        }

        public void setSessionInfo(Object sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public void setSessionSize(long sizeInBytes) {
            this.totalSessionSize = sizeInBytes;
        }

        public void setSessionId(String id) {
            this.sessionId = id;
        }

        public Date getStartDate() {
            return new Date(this.startDate);
        }

        public String getEventTarget() {
            return this.eventTarget;
        }

        public String getResponseTarget() {
            return this.responseTarget;
        }

        public void addResponseTarget(String target) {
            this.responseTarget = target;
        }

        public void addEventTarget(String target) {
            this.eventTarget = target;
        }

        public void setTimeTaken(long timeTaken) {
            this.timeTaken = timeTaken;
            this.startDate = System.currentTimeMillis() - timeTaken;
        }

        public void addEntry(String string) {
            this.entries.add(string);
        }

        public String getAlteredObjects() {
            AppendingStringBuffer sb = new AppendingStringBuffer();
            for (int i = 0; i < this.entries.size(); ++i) {
                String element = this.entries.get(i);
                sb.append(element);
                if (this.entries.size() == i + 1) continue;
                sb.append("<br/>");
            }
            return sb.toString();
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Long getSessionSize() {
            return new Long(this.totalSessionSize);
        }

        public String toString() {
            return "Request[timetaken=" + this.getTimeTaken() + ",sessioninfo=" + this.sessionInfo + ",sessionid=" + this.sessionId + ",sessionsize=" + this.totalSessionSize + ",request=" + this.eventTarget + ",response=" + this.responseTarget + ",alteredobjects=" + this.getAlteredObjects() + ",activerequest=" + this.activeRequest + "]";
        }
    }
}

