/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.internal.InlineEnclosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxEnclosureListener
implements AjaxRequestTarget.IListener {
    @Override
    public void onBeforeRespond(Map<String, Component> map, final AjaxRequestTarget target) {
        final List<Component> originalComponents = Collections.unmodifiableList(new ArrayList<Component>(map.values()));
        target.getPage().visitChildren(InlineEnclosure.class, new Component.IVisitor<InlineEnclosure>(){

            @Override
            public Object component(InlineEnclosure enclosure) {
                for (Component component : originalComponents) {
                    if (!AjaxEnclosureListener.this.isControllerOfEnclosure(component, enclosure)) continue;
                    enclosure.setOutputMarkupId(true);
                    enclosure.setOutputMarkupPlaceholderTag(true);
                    enclosure.setMarkupId(enclosure.getId());
                    enclosure.updateVisibility();
                    target.addComponent(enclosure);
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    private boolean isControllerOfEnclosure(Component component, InlineEnclosure enclosure) {
        return enclosure.getParent().get(enclosure.getChildId()) == component;
    }

    @Override
    public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavascriptResponse response) {
    }
}

