/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.MapModel;
import org.apache.wicket.model.util.WildcardCollectionModel;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.model.util.WildcardSetModel;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model<T extends Serializable>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    public Model() {
    }

    public Model(T object) {
        this.setObject(object);
    }

    @Deprecated
    public static <K, V> IModel<Map<K, V>> valueOf(Map<K, V> map) {
        return Model.of(map);
    }

    @Deprecated
    public static <C> IModel<List<? extends C>> valueOf(List<? extends C> list) {
        return Model.of(list);
    }

    @Deprecated
    public static <C> IModel<List<? extends C>> of(List<? extends C> list) {
        return new WildcardListModel<C>(list);
    }

    public static <C> IModel<List<? extends C>> ofList(List<? extends C> list) {
        return new WildcardListModel<C>(list);
    }

    @Deprecated
    public static <K, V> IModel<Map<K, V>> of(Map<K, V> map) {
        return new MapModel<K, V>(map);
    }

    public static <K, V> IModel<Map<K, V>> ofMap(Map<K, V> map) {
        return new MapModel<K, V>(map);
    }

    @Deprecated
    public static <C> IModel<Set<? extends C>> of(Set<? extends C> set) {
        return new WildcardSetModel<C>(set);
    }

    public static <C> IModel<Set<? extends C>> ofSet(Set<? extends C> set) {
        return new WildcardSetModel<C>(set);
    }

    public static <C> IModel<Collection<? extends C>> of(Collection<? extends C> set) {
        return new WildcardCollectionModel<C>(set);
    }

    public static <T extends Serializable> Model<T> of(T object) {
        return new Model<T>(object);
    }

    public static <T extends Serializable> Model<T> of() {
        return new Model<T>();
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new WicketRuntimeException("Model object must be Serializable");
        }
        this.object = object;
    }

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Model:classname=[");
        sb.append(this.getClass().getName()).append("]");
        sb.append(":object=[").append(this.object).append("]");
        return sb.toString();
    }

    @Deprecated
    public final Object getObject(Component component) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void setObject(Component component, Object object) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode(this.object);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model that = (Model)obj;
        return Objects.equal(this.object, that.object);
    }
}

